/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sis.util.Static;
import org.apache.sis.util.logging.Logging;

public final class Loggers
extends Static {
    public static final String ROOT = "org.apache.sis";
    public static final String SYSTEM = "org.apache.sis.system";
    public static final String MATH = "org.apache.sis.math";
    public static final String MEASURE = "org.apache.sis.measure";
    public static final String SQL = "org.apache.sis.sql";
    public static final String XML = "org.apache.sis.xml";
    public static final String WKT = "org.apache.sis.io.wkt";
    public static final String FILTER = "org.apache.sis.filter";
    public static final String GEOMETRY = "org.apache.sis.geometry";
    public static final String ISO_19115 = "org.apache.sis.metadata.iso";
    public static final String CRS_FACTORY = "org.apache.sis.referencing.factory";
    public static final String COORDINATE_OPERATION = "org.apache.sis.referencing.operation";
    public static final String LOCALIZATION = "org.apache.sis.util.resources";
    public static final String APPLICATION = "org.apache.sis.application";

    private Loggers() {
    }

    public static SortedMap<String, Level> getEffectiveLevels() {
        TreeMap<String, Level> treeMap = new TreeMap<String, Level>();
        for (Field object : Loggers.class.getDeclaredFields()) {
            if (!Modifier.isStatic(object.getModifiers()) || object.getType() != String.class) continue;
            try {
                treeMap.put((String)object.get(null), null);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logging.unexpectedException(Logging.getLogger(SYSTEM), Loggers.class, "getEffectiveLevels", illegalAccessException);
            }
        }
        Iterator iterator = treeMap.entrySet().iterator();
        block3: while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string = (String)entry.getKey();
            Logger logger = Logging.getLogger(string);
            Level level = Loggers.getEffectiveLevel(logger);
            Level level2 = Loggers.getHandlerLevel(logger);
            if (level2.intValue() > level.intValue()) {
                level = level2;
            }
            entry.setValue(level);
            Logger logger2 = logger;
            while ((logger2 = logger2.getParent()) != null) {
                Level level3 = (Level)treeMap.get(logger2.getName());
                if (level3 == null) continue;
                if (!level3.equals(level)) continue block3;
                iterator.remove();
                continue block3;
            }
        }
        return treeMap;
    }

    private static Level getEffectiveLevel(Logger logger) {
        while (logger != null) {
            Level level = logger.getLevel();
            if (level != null) {
                return level;
            }
            logger = logger.getParent();
        }
        return Level.INFO;
    }

    private static Level getHandlerLevel(Logger logger) {
        Level level = Level.OFF;
        while (logger != null) {
            for (Handler handler : logger.getHandlers()) {
                Level level2 = handler.getLevel();
                if (level2 == null || level2.intValue() >= level.intValue()) continue;
                level = level2;
            }
            if (!logger.getUseParentHandlers()) break;
            logger = logger.getParent();
        }
        return level;
    }
}

