/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.internal.ClassHelper;
import org.testng.internal.MethodHelper;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IDataProvider;
import org.testng.internal.annotations.IParameterizable;
import org.testng.internal.annotations.IParameters;
import org.testng.internal.annotations.ITest;
import org.testng.xml.XmlSuite;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameters {
    private static final String NULL_VALUE = "null";
    static /* synthetic */ Class class$org$testng$internal$annotations$ITest;
    static /* synthetic */ Class class$org$testng$internal$annotations$IConfiguration;
    static /* synthetic */ Class class$org$testng$internal$annotations$IFactory;
    static /* synthetic */ Class class$java$lang$reflect$Method;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$testng$internal$Parameters;
    static /* synthetic */ Class class$org$testng$internal$annotations$IDataProvider;
    static /* synthetic */ Class class$org$testng$internal$annotations$IParameters;

    public static Object[] createParameters(Constructor ctor, String methodAnnotation, String[] parameterNames, Map<String, String> params, XmlSuite xmlSuite) {
        return Parameters.createParameters(ctor.toString(), ctor.getParameterTypes(), methodAnnotation, parameterNames, new MethodParameters(params), xmlSuite);
    }

    public static Object[] createTestParameters(Method m, Map<String, String> params, IAnnotationFinder finder, XmlSuite xmlSuite) {
        return Parameters.createParameters(m, new MethodParameters(params), finder, xmlSuite, class$org$testng$internal$annotations$ITest == null ? (class$org$testng$internal$annotations$ITest = Parameters.class$("org.testng.internal.annotations.ITest")) : class$org$testng$internal$annotations$ITest, "@Test");
    }

    public static Object[] createConfigurationParameters(Method m, Map<String, String> params, ITestNGMethod currentTestMethod, IAnnotationFinder finder, XmlSuite xmlSuite) {
        Method currentTestMeth = currentTestMethod != null ? currentTestMethod.getMethod() : null;
        return Parameters.createParameters(m, new MethodParameters(params, currentTestMeth), finder, xmlSuite, class$org$testng$internal$annotations$IConfiguration == null ? (class$org$testng$internal$annotations$IConfiguration = Parameters.class$("org.testng.internal.annotations.IConfiguration")) : class$org$testng$internal$annotations$IConfiguration, "@Configuration");
    }

    public static Object[] createFactoryParameters(Method m, Map<String, String> params, IAnnotationFinder finder, XmlSuite xmlSuite) {
        return Parameters.createParameters(m, new MethodParameters(params), finder, xmlSuite, class$org$testng$internal$annotations$IFactory == null ? (class$org$testng$internal$annotations$IFactory = Parameters.class$("org.testng.internal.annotations.IFactory")) : class$org$testng$internal$annotations$IFactory, "@Factory");
    }

    private static Object[] createParameters(String methodName, Class[] parameterTypes, String methodAnnotation, String[] parameterNames, MethodParameters params, XmlSuite xmlSuite) {
        Object[] result = new Object[]{};
        if (parameterTypes.length > 0) {
            ArrayList<Object> vResult = new ArrayList<Object>();
            if (parameterNames.length != parameterTypes.length && parameterTypes.length != parameterNames.length + 1) {
                throw new TestNGException(new StringBuffer().append("Method ").append(methodName).append(" needs ").append(parameterTypes.length).append(" parameters but ").append(parameterNames.length).append(" were supplied in the ").append(methodAnnotation).append(" annotation.").toString());
            }
            int j = 0;
            for (int i = 0; i < parameterTypes.length; ++i) {
                if ((class$java$lang$reflect$Method == null ? Parameters.class$("java.lang.reflect.Method") : class$java$lang$reflect$Method).equals(parameterTypes[i])) {
                    vResult.add(params.m_currentTestMethod);
                    continue;
                }
                String p = parameterNames[j];
                String value = (String)params.m_parameters.get(p);
                if (null == value) {
                    throw new TestNGException(new StringBuffer().append("Parameter '").append(p).append("' is required by ").append(methodAnnotation).append(" on method ").append(methodName).append("\nbut has not been defined in ").append(xmlSuite.getFileName()).toString());
                }
                vResult.add(Parameters.convertType(parameterTypes[i], value, p));
                ++j;
            }
            result = vResult.toArray(new Object[vResult.size()]);
        }
        return result;
    }

    private static Object convertType(Class type, String value, String paramName) {
        Object result = null;
        if (NULL_VALUE.equals(value.toLowerCase())) {
            if (type.isPrimitive()) {
                Utils.log("Parameters", 2, new StringBuffer().append("Attempt to pass null value to primitive type parameter '").append(paramName).append("'").toString());
            }
            return null;
        }
        if (type == (class$java$lang$String == null ? (class$java$lang$String = Parameters.class$("java.lang.String")) : class$java$lang$String)) {
            result = value;
        } else if (type == Integer.TYPE || type == (class$java$lang$Integer == null ? (class$java$lang$Integer = Parameters.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            result = new Integer(Integer.parseInt(value));
        } else if (type == Boolean.TYPE || type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Parameters.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            result = new Boolean(value);
        } else if (type == Byte.TYPE || type == (class$java$lang$Byte == null ? (class$java$lang$Byte = Parameters.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            result = new Byte(Byte.parseByte(value));
        } else if (type == Character.TYPE || type == (class$java$lang$Character == null ? (class$java$lang$Character = Parameters.class$("java.lang.Character")) : class$java$lang$Character)) {
            result = new Character(value.charAt(0));
        } else if (type == Double.TYPE || type == (class$java$lang$Double == null ? (class$java$lang$Double = Parameters.class$("java.lang.Double")) : class$java$lang$Double)) {
            result = new Double(Double.parseDouble(value));
        } else if (type == Float.TYPE || type == (class$java$lang$Float == null ? (class$java$lang$Float = Parameters.class$("java.lang.Float")) : class$java$lang$Float)) {
            result = new Float(Float.parseFloat(value));
        } else if (type == Long.TYPE || type == (class$java$lang$Long == null ? (class$java$lang$Long = Parameters.class$("java.lang.Long")) : class$java$lang$Long)) {
            result = new Long(Long.parseLong(value));
        } else if (type == Short.TYPE || type == (class$java$lang$Short == null ? (class$java$lang$Short = Parameters.class$("java.lang.Short")) : class$java$lang$Short)) {
            result = new Short(Short.parseShort(value));
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)new StringBuffer().append("Unsupported type parameter : ").append(type).toString());
        }
        return result;
    }

    public static Method findDataProvider(Class clazz, Method m, IAnnotationFinder finder) {
        String dataProviderName;
        Method result = null;
        ITest annotation = AnnotationHelper.findTest(finder, m);
        if (null != annotation && null != (dataProviderName = annotation.getDataProvider()) && !"".equals(dataProviderName)) {
            result = Parameters.findDataProvider(clazz, finder, dataProviderName, annotation.getDataProviderClass());
        }
        return result;
    }

    private static Method findDataProvider(Class cls, IAnnotationFinder finder, String name, Class dataProviderClass) {
        boolean shouldBeStatic = false;
        if (dataProviderClass != null) {
            cls = dataProviderClass;
            shouldBeStatic = true;
        }
        for (Method m : ClassHelper.getAvailableMethods(cls)) {
            IDataProvider dp = (IDataProvider)finder.findAnnotation(m, class$org$testng$internal$annotations$IDataProvider == null ? Parameters.class$("org.testng.internal.annotations.IDataProvider") : class$org$testng$internal$annotations$IDataProvider);
            if (null == dp || !name.equals(dp.getName()) && !name.equals(m.getName())) continue;
            if (shouldBeStatic && (m.getModifiers() & 8) == 0) {
                throw new TestNGException(new StringBuffer().append("DataProvider should be static: ").append(m).toString());
            }
            return m;
        }
        return null;
    }

    private static Object[] createParameters(Method m, MethodParameters params, IAnnotationFinder finder, XmlSuite xmlSuite, Class annotationClass, String atName) {
        Object[] result = new Object[]{};
        IParameters annotation = (IParameters)finder.findAnnotation(m, class$org$testng$internal$annotations$IParameters == null ? (class$org$testng$internal$annotations$IParameters = Parameters.class$("org.testng.internal.annotations.IParameters")) : class$org$testng$internal$annotations$IParameters);
        if (null != annotation) {
            String[] parameterNames = annotation.getValue();
            result = Parameters.createParameters(m.getName(), m.getParameterTypes(), atName, parameterNames, params, xmlSuite);
        } else {
            IParameterizable a = (IParameterizable)finder.findAnnotation(m, annotationClass);
            if (null != a) {
                String[] parameterNames = a.getParameters();
                result = Parameters.createParameters(m.getName(), m.getParameterTypes(), "@Configuration", parameterNames, params, xmlSuite);
            } else {
                Class[] paramTypes = m.getParameterTypes();
                if (paramTypes.length == 1 && (class$java$lang$reflect$Method == null ? (class$java$lang$reflect$Method = Parameters.class$("java.lang.reflect.Method")) : class$java$lang$reflect$Method).equals(paramTypes[0])) {
                    result = Parameters.createParameters(m.getName(), paramTypes, "@Configuration", new String[0], params, xmlSuite);
                }
            }
        }
        return result;
    }

    public static Iterator<Object[]> handleParameters(ITestNGMethod testMethod, Map<String, String> allParameterNames, ITestClass testClass, Map<String, String> parameters, XmlSuite xmlSuite, IAnnotationFinder annotationFinder, ITestContext testContext) {
        Iterator<Object[]> result = null;
        Method dataProvider = Parameters.findDataProvider(testMethod.getTestClass().getRealClass(), testMethod.getMethod(), annotationFinder);
        if (null != dataProvider) {
            int parameterCount = testMethod.getMethod().getParameterTypes().length;
            for (int i = 0; i < parameterCount; ++i) {
                String n = new StringBuffer().append("param").append(i).toString();
                allParameterNames.put(n, n);
            }
            boolean isStatic = (dataProvider.getModifiers() & 8) != 0;
            Object instance = isStatic ? null : testClass.getInstances(true)[0];
            result = MethodHelper.invokeDataProvider(instance, dataProvider, testMethod, testContext);
        } else {
            allParameterNames.putAll(parameters);
            Object[][] allParameterValuesArray = new Object[][]{Parameters.createTestParameters(testMethod.getMethod(), parameters, annotationFinder, xmlSuite)};
            testMethod.setParameterInvocationCount(allParameterValuesArray.length);
            result = MethodHelper.createArrayIterator(allParameterValuesArray);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$org$testng$internal$Parameters == null ? (class$org$testng$internal$Parameters = Parameters.class$("org.testng.internal.Parameters")) : class$org$testng$internal$Parameters).desiredAssertionStatus();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodParameters {
        private final Map<String, String> m_parameters;
        private final Method m_currentTestMethod;

        public MethodParameters(Map<String, String> params) {
            this(params, null);
        }

        public MethodParameters(Map<String, String> params, Method m) {
            this.m_parameters = params;
            this.m_currentTestMethod = m;
        }
    }
}

