/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.util.regex.Pattern;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.utils.filter.FilterImpl;
import org.osgi.framework.InvalidSyntaxException;

public class RequirementImpl
implements Requirement {
    private static final Pattern REMOVE_LT = Pattern.compile("\\(([^<>=~()]*)<([^*=]([^\\\\\\*\\(\\)]|\\\\|\\*|\\(|\\))*)\\)");
    private static final Pattern REMOVE_GT = Pattern.compile("\\(([^<>=~()]*)>([^*=]([^\\\\\\*\\(\\)]|\\\\|\\*|\\(|\\))*)\\)");
    private static final Pattern REMOVE_NV = Pattern.compile("\\(version>=0.0.0\\)");
    private String m_name = null;
    private boolean m_extend = false;
    private boolean m_multiple = false;
    private boolean m_optional = false;
    private FilterImpl m_filter = null;
    private String m_comment = null;

    public RequirementImpl() {
    }

    public RequirementImpl(String name) {
        this.setName(name);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name.intern();
    }

    public String getFilter() {
        return this.m_filter.toString();
    }

    public void setFilter(String filter) {
        try {
            String nf = REMOVE_LT.matcher(filter).replaceAll("(!($1>=$2))");
            nf = REMOVE_GT.matcher(nf).replaceAll("(!($1<=$2))");
            nf = REMOVE_NV.matcher(nf).replaceAll("");
            this.m_filter = FilterImpl.newInstance(nf, true);
        }
        catch (InvalidSyntaxException e) {
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
    }

    public boolean isSatisfied(Capability capability) {
        return this.m_name.equals(capability.getName()) && this.m_filter.matchCase(capability.getPropertiesAsMap()) && (this.m_filter.toString().indexOf("(mandatory:<*") >= 0 || capability.getPropertiesAsMap().get("mandatory:") == null);
    }

    public boolean isExtend() {
        return this.m_extend;
    }

    public void setExtend(boolean extend) {
        this.m_extend = extend;
    }

    public boolean isMultiple() {
        return this.m_multiple;
    }

    public void setMultiple(boolean multiple) {
        this.m_multiple = multiple;
    }

    public boolean isOptional() {
        return this.m_optional;
    }

    public void setOptional(boolean optional) {
        this.m_optional = optional;
    }

    public String getComment() {
        return this.m_comment;
    }

    public void addText(String s) {
        this.m_comment = s;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Requirement) {
            Requirement r = (Requirement)o;
            return this.m_name.equals(r.getName()) && this.m_optional == r.isOptional() && this.m_multiple == r.isMultiple() && this.m_filter.toString().equals(r.getFilter()) && (this.m_comment == r.getComment() || this.m_comment != null && this.m_comment.equals(r.getComment()));
        }
        return false;
    }

    public int hashCode() {
        return this.m_filter.toString().hashCode();
    }

    public String toString() {
        return this.m_name + ":" + this.getFilter();
    }
}

