/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.graph.visitor.AbstractDependencyNodeConsumerVisitor;
import org.eclipse.aether.util.graph.visitor.Stack;

public final class LevelOrderDependencyNodeConsumerVisitor
extends AbstractDependencyNodeConsumerVisitor {
    public static final String NAME = "levelOrder";
    private final HashMap<Integer, ArrayList<DependencyNode>> nodesPerLevel = new HashMap(16);
    private final Stack<Boolean> visits = new Stack();

    public LevelOrderDependencyNodeConsumerVisitor(Consumer<DependencyNode> nodeConsumer) {
        this(nodeConsumer, null);
    }

    public LevelOrderDependencyNodeConsumerVisitor(Consumer<DependencyNode> nodeConsumer, DependencyFilter filter) {
        super(nodeConsumer, filter);
    }

    @Override
    protected boolean doVisitEnter(DependencyNode node) {
        boolean visited = !this.setVisited(node);
        this.visits.push(visited);
        if (!visited) {
            List nodesOnLevel = this.nodesPerLevel.computeIfAbsent(this.visits.size(), k -> new ArrayList());
            if (this.acceptNode(node)) {
                nodesOnLevel.add(node);
            }
        }
        return !visited;
    }

    @Override
    protected boolean doVisitLeave(DependencyNode node) {
        Boolean visited = this.visits.pop();
        if (visited.booleanValue()) {
            return true;
        }
        if (this.visits.isEmpty()) {
            int l = 1;
            while (this.nodesPerLevel.containsKey(l)) {
                this.nodesPerLevel.get(l).forEach(this::consumeNode);
                ++l;
            }
        }
        return true;
    }
}

