/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class IssueManagement
implements Serializable,
InputLocationTracker {
    final String system;
    final String url;
    final Map<Object, InputLocation> locations;
    final InputLocation importedFrom;

    protected IssueManagement(Builder builder) {
        String string = builder.system != null ? builder.system : (this.system = builder.base != null ? builder.base.system : null);
        this.url = builder.url != null ? builder.url : (builder.base != null ? builder.base.url : null);
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    public String getSystem() {
        return this.system;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public InputLocation getLocation(Object key) {
        Objects.requireNonNull(key, "key");
        return this.locations.get(key);
    }

    public Set<Object> getLocationKeys() {
        return this.locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return this.locations.keySet().stream();
    }

    @Override
    public InputLocation getImportedFrom() {
        return this.importedFrom;
    }

    @Nonnull
    public Builder with() {
        return IssueManagement.newBuilder(this);
    }

    @Nonnull
    public IssueManagement withSystem(String system) {
        return IssueManagement.newBuilder(this, true).system(system).build();
    }

    @Nonnull
    public IssueManagement withUrl(String url) {
        return IssueManagement.newBuilder(this, true).url(url).build();
    }

    @Nonnull
    public static IssueManagement newInstance() {
        return IssueManagement.newInstance(true);
    }

    @Nonnull
    public static IssueManagement newInstance(boolean withDefaults) {
        return IssueManagement.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return IssueManagement.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(IssueManagement from) {
        return IssueManagement.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(IssueManagement from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public String toString() {
        return "IssueManagement {system=" + this.getSystem() + ", url=" + this.getUrl() + "}";
    }

    @NotThreadSafe
    public static class Builder {
        IssueManagement base;
        String system;
        String url;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(IssueManagement base, boolean forceCopy) {
            if (forceCopy) {
                this.system = base.system;
                this.url = base.url;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder system(String system) {
            this.system = system;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public IssueManagement build() {
            if (!(this.base == null || this.system != null && this.system != this.base.system || this.url != null && this.url != this.base.url)) {
                return this.base;
            }
            return new IssueManagement(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map oldlocs;
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Map.of();
            Map<Object, Object> map = oldlocs = this.base != null ? this.base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }
}

