/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.util.List;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.DependencyCoordinates;
import org.apache.maven.api.Node;
import org.apache.maven.api.PathScope;
import org.apache.maven.api.Project;
import org.apache.maven.api.Service;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.ArtifactResolverException;
import org.apache.maven.api.services.DependencyResolverException;
import org.apache.maven.api.services.DependencyResolverRequest;
import org.apache.maven.api.services.DependencyResolverResult;

@Experimental
public interface DependencyResolver
extends Service {
    @Nonnull
    default public DependencyResolverResult collect(@Nonnull Session session, @Nonnull DependencyCoordinates root, @Nonnull PathScope scope) {
        return this.collect(DependencyResolverRequest.build(session, DependencyResolverRequest.RequestType.COLLECT, root, scope));
    }

    @Nonnull
    default public DependencyResolverResult collect(@Nonnull Session session, @Nonnull Project project, @Nonnull PathScope scope) {
        return this.collect(DependencyResolverRequest.build(session, DependencyResolverRequest.RequestType.COLLECT, project, scope));
    }

    @Nonnull
    default public DependencyResolverResult collect(@Nonnull Session session, @Nonnull Artifact artifact, @Nonnull PathScope scope) {
        return this.collect(DependencyResolverRequest.build(session, DependencyResolverRequest.RequestType.COLLECT, artifact, scope));
    }

    @Nonnull
    default public DependencyResolverResult collect(@Nonnull DependencyResolverRequest request) {
        if (request.getRequestType() != DependencyResolverRequest.RequestType.COLLECT) {
            throw new IllegalArgumentException("requestType should be COLLECT when calling collect()");
        }
        return this.resolve(request);
    }

    public List<Node> flatten(@Nonnull Session var1, @Nonnull Node var2, @Nullable PathScope var3) throws DependencyResolverException;

    @Nonnull
    default public DependencyResolverResult flatten(@Nonnull Session session, @Nonnull Project project, @Nonnull PathScope scope) {
        return this.flatten(DependencyResolverRequest.build(session, DependencyResolverRequest.RequestType.FLATTEN, project, scope));
    }

    @Nonnull
    default public DependencyResolverResult flatten(@Nonnull DependencyResolverRequest request) {
        if (request.getRequestType() != DependencyResolverRequest.RequestType.FLATTEN) {
            throw new IllegalArgumentException("requestType should be FLATTEN when calling flatten()");
        }
        return this.resolve(request);
    }

    @Nonnull
    default public DependencyResolverResult resolve(@Nonnull Session session, @Nonnull Project project) {
        return this.resolve(DependencyResolverRequest.build(session, DependencyResolverRequest.RequestType.RESOLVE, project));
    }

    @Nonnull
    default public DependencyResolverResult resolve(@Nonnull Session session, @Nonnull Project project, @Nonnull PathScope scope) {
        return this.resolve(DependencyResolverRequest.build(session, DependencyResolverRequest.RequestType.RESOLVE, project, scope));
    }

    @Nonnull
    default public DependencyResolverResult resolve(@Nonnull Session session, @Nonnull DependencyCoordinates dependency) {
        return this.resolve(DependencyResolverRequest.build(session, DependencyResolverRequest.RequestType.RESOLVE, dependency));
    }

    @Nonnull
    default public DependencyResolverResult resolve(@Nonnull Session session, @Nonnull DependencyCoordinates dependency, @Nonnull PathScope scope) {
        return this.resolve(DependencyResolverRequest.build(session, DependencyResolverRequest.RequestType.RESOLVE, dependency, scope));
    }

    @Nonnull
    default public DependencyResolverResult resolve(@Nonnull Session session, @Nonnull List<DependencyCoordinates> dependencies) {
        return this.resolve(DependencyResolverRequest.build(session, DependencyResolverRequest.RequestType.RESOLVE, dependencies));
    }

    @Nonnull
    default public DependencyResolverResult resolve(@Nonnull Session session, @Nonnull List<DependencyCoordinates> dependencies, @Nonnull PathScope scope) {
        return this.resolve(DependencyResolverRequest.build(session, DependencyResolverRequest.RequestType.RESOLVE, dependencies, scope));
    }

    public DependencyResolverResult resolve(DependencyResolverRequest var1) throws DependencyResolverException, ArtifactResolverException;
}

