/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Collection;
import java.util.Objects;
import org.apache.maven.api.Service;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;

@Experimental
public interface PathMatcherFactory
extends Service {
    @Nonnull
    public PathMatcher createPathMatcher(@Nonnull Path var1, Collection<String> var2, Collection<String> var3, boolean var4);

    @Nonnull
    default public PathMatcher createPathMatcher(@Nonnull Path baseDirectory, Collection<String> includes, Collection<String> excludes) {
        return this.createPathMatcher(baseDirectory, includes, excludes, false);
    }

    @Nonnull
    default public PathMatcher createExcludeOnlyMatcher(@Nonnull Path baseDirectory, Collection<String> excludes, boolean useDefaultExcludes) {
        return this.createPathMatcher(baseDirectory, null, excludes, useDefaultExcludes);
    }

    @Nonnull
    default public PathMatcher createIncludeOnlyMatcher(@Nonnull Path baseDirectory, Collection<String> includes) {
        return this.createPathMatcher(baseDirectory, includes, null, false);
    }

    @Nonnull
    public PathMatcher deriveDirectoryMatcher(@Nonnull PathMatcher var1);

    @Nonnull
    public PathMatcher includesAll();

    default public boolean isIncludesAll(@Nonnull PathMatcher matcher) {
        return Objects.requireNonNull(matcher) == this.includesAll();
    }
}

