/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.Request;

@Experimental
@Immutable
public interface RepositoryAwareRequest
extends Request<Session> {
    @Nullable
    public List<RemoteRepository> getRepositories();

    default public List<RemoteRepository> validate(List<RemoteRepository> repositories) {
        if (repositories == null) {
            return null;
        }
        HashSet<RemoteRepository> set = new HashSet<RemoteRepository>(repositories);
        if (repositories.size() != set.size()) {
            throw new IllegalArgumentException("Repository list contains duplicate entries. Each repository must be unique based on its ID and URL. Found " + repositories.size() + " repositories but only " + set.size() + " unique entries.");
        }
        if (repositories.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("Repository list contains null entries. All repository entries must be non-null RemoteRepository instances.");
        }
        return repositories;
    }
}

