/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services.xml;

import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Path;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.Nullable;

@Experimental
@Immutable
public interface XmlReaderRequest {
    @Nullable
    public Path getPath();

    @Nullable
    public Path getRootDirectory();

    @Nullable
    public URL getURL();

    @Nullable
    public InputStream getInputStream();

    @Nullable
    public Reader getReader();

    @Nullable
    public Transformer getTransformer();

    public boolean isStrict();

    @Nullable
    public String getModelId();

    @Nullable
    public String getLocation();

    public boolean isAddDefaultEntities();

    @Nonnull
    public static XmlReaderRequestBuilder builder() {
        return new XmlReaderRequestBuilder();
    }

    @NotThreadSafe
    public static class XmlReaderRequestBuilder {
        Path path;
        Path rootDirectory;
        URL url;
        InputStream inputStream;
        Reader reader;
        Transformer transformer;
        boolean strict;
        String modelId;
        String location;
        boolean addDefaultEntities = true;

        public XmlReaderRequestBuilder path(Path path) {
            this.path = path;
            return this;
        }

        public XmlReaderRequestBuilder rootDirectory(Path rootDirectory) {
            this.rootDirectory = rootDirectory;
            return this;
        }

        public XmlReaderRequestBuilder url(URL url) {
            this.url = url;
            return this;
        }

        public XmlReaderRequestBuilder inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public XmlReaderRequestBuilder reader(Reader reader) {
            this.reader = reader;
            return this;
        }

        public XmlReaderRequestBuilder transformer(Transformer transformer) {
            this.transformer = transformer;
            return this;
        }

        public XmlReaderRequestBuilder strict(boolean strict) {
            this.strict = strict;
            return this;
        }

        public XmlReaderRequestBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public XmlReaderRequestBuilder location(String location) {
            this.location = location;
            return this;
        }

        public XmlReaderRequestBuilder addDefaultEntities(boolean addDefaultEntities) {
            this.addDefaultEntities = addDefaultEntities;
            return this;
        }

        public XmlReaderRequest build() {
            return new DefaultXmlReaderRequest(this.path, this.rootDirectory, this.url, this.inputStream, this.reader, this.transformer, this.strict, this.modelId, this.location, this.addDefaultEntities);
        }

        private static class DefaultXmlReaderRequest
        implements XmlReaderRequest {
            final Path path;
            final Path rootDirectory;
            final URL url;
            final InputStream inputStream;
            final Reader reader;
            final Transformer transformer;
            final boolean strict;
            final String modelId;
            final String location;
            final boolean addDefaultEntities;

            DefaultXmlReaderRequest(Path path, Path rootDirectory, URL url, InputStream inputStream, Reader reader, Transformer transformer, boolean strict, String modelId, String location, boolean addDefaultEntities) {
                this.path = path;
                this.rootDirectory = rootDirectory;
                this.url = url;
                this.inputStream = inputStream;
                this.reader = reader;
                this.transformer = transformer;
                this.strict = strict;
                this.modelId = modelId;
                this.location = location;
                this.addDefaultEntities = addDefaultEntities;
            }

            @Override
            public Path getPath() {
                return this.path;
            }

            @Override
            public Path getRootDirectory() {
                return this.rootDirectory;
            }

            @Override
            public URL getURL() {
                return this.url;
            }

            @Override
            public InputStream getInputStream() {
                return this.inputStream;
            }

            @Override
            public Reader getReader() {
                return this.reader;
            }

            @Override
            public Transformer getTransformer() {
                return this.transformer;
            }

            @Override
            public boolean isStrict() {
                return this.strict;
            }

            @Override
            public String getModelId() {
                return this.modelId;
            }

            @Override
            public String getLocation() {
                return this.location;
            }

            @Override
            public boolean isAddDefaultEntities() {
                return this.addDefaultEntities;
            }
        }
    }

    public static interface Transformer {
        public String transform(String var1, String var2);
    }
}

