/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.ArtifactUpload;
import org.eclipse.aether.spi.connector.MetadataDownload;
import org.eclipse.aether.spi.connector.MetadataUpload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilter;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.MetadataNotFoundException;
import org.eclipse.aether.transfer.MetadataTransferException;

public final class FilteringRepositoryConnector
implements RepositoryConnector {
    private final RemoteRepository remoteRepository;
    private final RepositoryConnector delegate;
    private final RemoteRepositoryFilter remoteRepositoryFilter;

    public FilteringRepositoryConnector(RemoteRepository remoteRepository, RepositoryConnector delegate, RemoteRepositoryFilter remoteRepositoryFilter) {
        this.remoteRepository = Objects.requireNonNull(remoteRepository);
        this.delegate = Objects.requireNonNull(delegate);
        this.remoteRepositoryFilter = Objects.requireNonNull(remoteRepositoryFilter);
    }

    public void close() {
        this.delegate.close();
    }

    public void get(Collection<? extends ArtifactDownload> artifactDownloads, Collection<? extends MetadataDownload> metadataDownloads) {
        ArrayList<ArtifactDownload> filteredArtifactDownloads = null;
        if (artifactDownloads != null && !artifactDownloads.isEmpty()) {
            filteredArtifactDownloads = new ArrayList<ArtifactDownload>(artifactDownloads.size());
            for (ArtifactDownload artifactDownload : artifactDownloads) {
                RemoteRepositoryFilter.Result result = this.remoteRepositoryFilter.acceptArtifact(this.remoteRepository, artifactDownload.getArtifact());
                if (result.isAccepted()) {
                    filteredArtifactDownloads.add(artifactDownload);
                    continue;
                }
                artifactDownload.setException((ArtifactTransferException)new ArtifactNotFoundException(artifactDownload.getArtifact(), this.remoteRepository, result.reasoning()));
            }
        }
        ArrayList<MetadataDownload> filteredMetadataDownloads = null;
        if (metadataDownloads != null && !metadataDownloads.isEmpty()) {
            filteredMetadataDownloads = new ArrayList<MetadataDownload>(metadataDownloads.size());
            for (MetadataDownload metadataDownload : metadataDownloads) {
                RemoteRepositoryFilter.Result result = this.remoteRepositoryFilter.acceptMetadata(this.remoteRepository, metadataDownload.getMetadata());
                if (result.isAccepted()) {
                    filteredMetadataDownloads.add(metadataDownload);
                    continue;
                }
                metadataDownload.setException((MetadataTransferException)new MetadataNotFoundException(metadataDownload.getMetadata(), this.remoteRepository, result.reasoning()));
            }
        }
        this.delegate.get(filteredArtifactDownloads, filteredMetadataDownloads);
    }

    public void put(Collection<? extends ArtifactUpload> artifactUploads, Collection<? extends MetadataUpload> metadataUploads) {
        this.delegate.put(artifactUploads, metadataUploads);
    }

    public String toString() {
        return "rrf( " + this.delegate.toString() + " )";
    }
}

