/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.filter.ruletree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.aether.internal.impl.filter.ruletree.Node;

public class GroupTree
extends Node {
    public static final GroupTree SENTINEL = new GroupTree("sentinel");
    private static final String MOD_EXCLUSION = "!";
    private static final String MOD_STOP = "=";

    private static List<String> elementsOfGroup(String groupId) {
        return Arrays.stream(groupId.split("\\.")).filter(e -> !e.isEmpty()).collect(Collectors.toList());
    }

    public GroupTree(String name) {
        super(name, false, null);
    }

    public int loadNodes(Stream<String> linesStream) {
        AtomicInteger counter = new AtomicInteger(0);
        linesStream.forEach(line -> {
            if (this.loadNode((String)line)) {
                counter.incrementAndGet();
            }
        });
        return counter.get();
    }

    public boolean loadNode(String line) {
        if (!line.startsWith("#") && !line.trim().isEmpty()) {
            Node currentNode = this;
            boolean allow = true;
            if (line.startsWith(MOD_EXCLUSION)) {
                allow = false;
                line = line.substring(MOD_EXCLUSION.length());
            }
            boolean stop = false;
            if (line.startsWith(MOD_STOP)) {
                stop = true;
                line = line.substring(MOD_STOP.length());
            }
            List<String> groupElements = GroupTree.elementsOfGroup(line);
            for (String groupElement : groupElements.subList(0, groupElements.size() - 1)) {
                currentNode = currentNode.addSibling(groupElement, false, null);
            }
            currentNode.addSibling(groupElements.get(groupElements.size() - 1), stop, allow);
            return true;
        }
        return false;
    }

    public boolean acceptedGroupId(String groupId) {
        ArrayList<String> current = new ArrayList<String>();
        List<String> groupElements = GroupTree.elementsOfGroup(groupId);
        Boolean accepted = null;
        Node currentNode = this;
        for (String groupElement : groupElements) {
            current.add(groupElement);
            currentNode = currentNode.getSibling(groupElement);
            if (currentNode == null) break;
            if (currentNode.isStop() && groupElements.equals(current)) {
                accepted = currentNode.isAllow();
                continue;
            }
            if (currentNode.isStop()) continue;
            accepted = currentNode.isAllow();
        }
        return accepted != null && accepted != false;
    }
}

