/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.maven.InternalErrorException;
import org.apache.maven.Maven;
import org.apache.maven.building.FileSource;
import org.apache.maven.building.Problem;
import org.apache.maven.building.Source;
import org.apache.maven.cli.CLIManager;
import org.apache.maven.cli.CLIReportingUtils;
import org.apache.maven.cli.CliRequest;
import org.apache.maven.cli.DaemonCli;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.cli.MvndHelpFormatter;
import org.apache.maven.cli.configuration.ConfigurationProcessor;
import org.apache.maven.cli.event.ExecutionEventLogger;
import org.apache.maven.cli.internal.BootstrapCoreExtensionManager;
import org.apache.maven.cli.internal.extension.model.CoreExtension;
import org.apache.maven.cli.logging.Slf4jConfiguration;
import org.apache.maven.cli.logging.Slf4jConfigurationFactory;
import org.apache.maven.cli.transfer.QuietMavenTransferListener;
import org.apache.maven.cli.transfer.Slf4jMavenTransferListener;
import org.apache.maven.eventspy.internal.EventSpyDispatcher;
import org.apache.maven.exception.DefaultExceptionHandler;
import org.apache.maven.exception.ExceptionSummary;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.scope.internal.MojoExecutionScopeModule;
import org.apache.maven.extension.internal.CoreExports;
import org.apache.maven.extension.internal.CoreExtensionEntry;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.plugin.ExtensionRealmCache;
import org.apache.maven.plugin.PluginArtifactsCache;
import org.apache.maven.plugin.PluginRealmCache;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifactsCache;
import org.apache.maven.properties.internal.SystemProperties;
import org.apache.maven.session.scope.internal.SessionScopeModule;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.apache.maven.toolchain.building.DefaultToolchainsBuildingRequest;
import org.apache.maven.toolchain.building.ToolchainsBuilder;
import org.apache.maven.toolchain.building.ToolchainsBuildingRequest;
import org.apache.maven.toolchain.building.ToolchainsBuildingResult;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.interpolation.AbstractValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.logging.LoggerManager;
import org.eclipse.aether.transfer.TransferListener;
import org.mvndaemon.mvnd.cache.invalidating.InvalidatingExtensionRealmCache;
import org.mvndaemon.mvnd.cache.invalidating.InvalidatingPluginArtifactsCache;
import org.mvndaemon.mvnd.cache.invalidating.InvalidatingPluginRealmCache;
import org.mvndaemon.mvnd.cache.invalidating.InvalidatingProjectArtifactsCache;
import org.mvndaemon.mvnd.cli.EnvHelper;
import org.mvndaemon.mvnd.common.Environment;
import org.mvndaemon.mvnd.common.Os;
import org.mvndaemon.mvnd.execution.BuildResumptionData;
import org.mvndaemon.mvnd.execution.BuildResumptionPersistenceException;
import org.mvndaemon.mvnd.execution.DefaultBuildResumptionAnalyzer;
import org.mvndaemon.mvnd.execution.DefaultBuildResumptionDataRepository;
import org.mvndaemon.mvnd.logging.internal.Slf4jLoggerManager;
import org.mvndaemon.mvnd.logging.smart.BuildEventListener;
import org.mvndaemon.mvnd.logging.smart.LoggingExecutionListener;
import org.mvndaemon.mvnd.logging.smart.LoggingOutputStream;
import org.mvndaemon.mvnd.plugin.CachingPluginVersionResolver;
import org.mvndaemon.mvnd.transfer.DaemonMavenTransferListener;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.MvndSimpleLogger;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;

public class DaemonMavenCli
implements DaemonCli {
    public static final String LOCAL_REPO_PROPERTY = "maven.repo.local";
    public static final String MULTIMODULE_PROJECT_DIRECTORY = "maven.multiModuleProjectDirectory";
    public static final String USER_HOME = System.getProperty("user.home");
    public static final File USER_MAVEN_CONFIGURATION_HOME = new File(USER_HOME, ".m2");
    public static final File DEFAULT_USER_TOOLCHAINS_FILE = new File(USER_MAVEN_CONFIGURATION_HOME, "toolchains.xml");
    public static final File DEFAULT_GLOBAL_TOOLCHAINS_FILE = new File(System.getProperty("maven.conf"), "toolchains.xml");
    private static final String EXT_CLASS_PATH = "maven.ext.class.path";
    private static final String DOT_MVN = ".mvn";
    private static final String UNABLE_TO_FIND_ROOT_PROJECT_MESSAGE = "Unable to find the root directory. Create a .mvn directory in the project root directory to identify it.";
    private static final String EXTENSIONS_FILENAME = ".mvn/extensions.xml";
    private static final String MVN_MAVEN_CONFIG = ".mvn/maven.config";
    public static final String STYLE_COLOR_PROPERTY = "style.color";
    public static final String RESUME = "r";
    public static final String RAW_STREAMS = "raw-streams";
    private final Slf4jLoggerManager plexusLoggerManager;
    private final ILoggerFactory slf4jLoggerFactory;
    private final Logger slf4jLogger;
    private final ClassWorld classWorld;
    private final DefaultPlexusContainer container;
    private final EventSpyDispatcher eventSpyDispatcher;
    private final ModelProcessor modelProcessor;
    private final Maven maven;
    private final MavenExecutionRequestPopulator executionRequestPopulator;
    private final ToolchainsBuilder toolchainsBuilder;
    private final DefaultSecDispatcher dispatcher;
    private final Map<String, ConfigurationProcessor> configurationProcessors;
    private final LoggingExecutionListener executionListener;
    private BuildEventListener buildEventListener = BuildEventListener.dummy();
    private static final Pattern LAST_ANSI_SEQUENCE = Pattern.compile("(\u001b\\[[;\\d]*[ -/]*[@-~])[^\u001b]*$");
    private static final String ANSI_RESET = "\u001b[m";

    public DaemonMavenCli() throws Exception {
        this.slf4jLoggerFactory = LoggerFactory.getILoggerFactory();
        this.slf4jLogger = this.slf4jLoggerFactory.getLogger(this.getClass().getName());
        this.plexusLoggerManager = new Slf4jLoggerManager();
        this.classWorld = ((ClassRealm)Thread.currentThread().getContextClassLoader()).getWorld();
        this.container = this.container();
        this.eventSpyDispatcher = (EventSpyDispatcher)this.container.lookup(EventSpyDispatcher.class);
        this.maven = (Maven)this.container.lookup(Maven.class);
        this.executionRequestPopulator = (MavenExecutionRequestPopulator)this.container.lookup(MavenExecutionRequestPopulator.class);
        this.modelProcessor = this.createModelProcessor((PlexusContainer)this.container);
        this.configurationProcessors = this.container.lookupMap(ConfigurationProcessor.class);
        this.toolchainsBuilder = (ToolchainsBuilder)this.container.lookup(ToolchainsBuilder.class);
        this.dispatcher = (DefaultSecDispatcher)this.container.lookup(SecDispatcher.class, "maven");
        this.executionListener = (LoggingExecutionListener)this.container.lookup(LoggingExecutionListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int main(List<String> arguments, String workingDirectory, String projectDirectory, Map<String, String> clientEnv, BuildEventListener buildEventListener) throws Exception {
        this.buildEventListener = buildEventListener;
        try {
            CliRequest req = new CliRequest(null, null);
            req.args = arguments.toArray(new String[0]);
            req.workingDirectory = new File(workingDirectory).getCanonicalPath();
            req.multiModuleProjectDirectory = new File(projectDirectory);
            int n = this.doMain(req, clientEnv);
            return n;
        }
        finally {
            this.buildEventListener = BuildEventListener.dummy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doMain(CliRequest cliRequest, Map<String, String> clientEnv) throws Exception {
        Properties props = (Properties)System.getProperties().clone();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.container.getContainerRealm());
            this.initialize(cliRequest);
            this.environment(cliRequest.workingDirectory, clientEnv);
            this.cli(cliRequest);
            this.properties(cliRequest);
            this.logging(cliRequest);
            this.informativeCommands(cliRequest);
            this.version(cliRequest);
            this.container(cliRequest);
            DaemonMavenCli.configure(cliRequest, this.eventSpyDispatcher, this.configurationProcessors);
            this.toolchains(cliRequest);
            this.populateRequest(cliRequest);
            this.encryption(cliRequest);
            int n = this.execute(cliRequest);
            return n;
        }
        catch (ExitException e) {
            int n = e.exitCode;
            return n;
        }
        catch (UnrecognizedOptionException e) {
            int n = 1;
            return n;
        }
        finally {
            this.eventSpyDispatcher.close();
            System.setProperties(props);
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    void initialize(CliRequest cliRequest) throws ExitException {
        cliRequest.classWorld = this.classWorld;
        if (cliRequest.workingDirectory == null) {
            cliRequest.workingDirectory = System.getProperty("user.dir");
        }
        if (cliRequest.multiModuleProjectDirectory == null) {
            String basedirProperty = System.getProperty(MULTIMODULE_PROJECT_DIRECTORY);
            if (basedirProperty == null) {
                System.err.format("-D%s system property is not set.", MULTIMODULE_PROJECT_DIRECTORY);
                throw new ExitException(1);
            }
            File basedir = new File(basedirProperty);
            try {
                cliRequest.multiModuleProjectDirectory = basedir.getCanonicalFile();
            }
            catch (IOException e) {
                cliRequest.multiModuleProjectDirectory = basedir.getAbsoluteFile();
            }
        }
        Path topDirectory = Paths.get(cliRequest.workingDirectory, new String[0]);
        boolean isAltFile = false;
        for (String arg : cliRequest.args) {
            if (isAltFile) {
                Path path = topDirectory.resolve(arg);
                if (Files.isDirectory(path, new LinkOption[0])) {
                    topDirectory = path;
                    break;
                }
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    topDirectory = path.getParent();
                    if (Files.isDirectory(topDirectory, new LinkOption[0])) break;
                    System.err.println("Directory " + topDirectory + " extracted from the -f/--file command-line argument " + arg + " does not exist");
                    throw new ExitException(1);
                }
                System.err.println("POM file " + arg + " specified with the -f/--file command line argument does not exist");
                throw new ExitException(1);
            }
            isAltFile = arg.equals(String.valueOf('f')) || arg.equals("file");
        }
        cliRequest.topDirectory = topDirectory = DaemonMavenCli.getCanonicalPath(topDirectory);
        cliRequest.rootDirectory = this.searchAcceptableRootDirectory(topDirectory);
        String mavenHome = System.getProperty("maven.home");
        if (mavenHome != null) {
            System.setProperty("maven.home", new File(mavenHome).getAbsolutePath());
        }
    }

    protected boolean isAcceptableRootDirectory(Path path) {
        return path != null && Files.isDirectory(path.resolve(DOT_MVN), new LinkOption[0]);
    }

    protected Path searchAcceptableRootDirectory(Path path) {
        if (path == null) {
            return null;
        }
        if (this.isAcceptableRootDirectory(path)) {
            return path;
        }
        return this.searchAcceptableRootDirectory(path.getParent());
    }

    private static Path getCanonicalPath(Path path) {
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return DaemonMavenCli.getCanonicalPath(path.getParent()).resolve(path.getFileName());
        }
    }

    void cli(CliRequest cliRequest) throws Exception {
        CommandLine mavenConfig;
        CLIManager cliManager;
        block11: {
            cliManager = this.newCLIManager();
            mavenConfig = null;
            try {
                File configFile = new File(cliRequest.multiModuleProjectDirectory, MVN_MAVEN_CONFIG);
                if (!configFile.isFile()) break block11;
                try (Stream<String> lines = Files.lines(configFile.toPath(), Charset.defaultCharset());){
                    String[] args = (String[])lines.filter(arg -> !arg.isEmpty() && !arg.startsWith("#")).toArray(String[]::new);
                    mavenConfig = cliManager.parse(args);
                    List unrecognized = mavenConfig.getArgList();
                    if (!unrecognized.isEmpty()) {
                        throw new ParseException("Unrecognized maven.config file entries: " + unrecognized);
                    }
                }
            }
            catch (ParseException e) {
                this.buildEventListener.log("Unable to parse maven.config: " + e.getMessage());
                this.buildEventListener.log("Run 'mvnd --help' for available options.");
                throw new ExitException(1);
            }
        }
        try {
            cliRequest.commandLine = mavenConfig == null ? cliManager.parse(cliRequest.args) : this.cliMerge(cliManager.parse(cliRequest.args), mavenConfig);
        }
        catch (ParseException e) {
            this.buildEventListener.log("Unable to parse command line options: " + e.getMessage());
            this.buildEventListener.log("Run 'mvnd --help' for available options.");
            throw new ExitException(1);
        }
    }

    private void informativeCommands(CliRequest cliRequest) throws Exception {
        if (cliRequest.commandLine.hasOption('h')) {
            this.buildEventListener.log(MvndHelpFormatter.displayHelp(this.newCLIManager()));
            throw new ExitException(0);
        }
        if (cliRequest.commandLine.hasOption('v')) {
            if (cliRequest.commandLine.hasOption('q')) {
                this.buildEventListener.log(CLIReportingUtils.showVersionMinimal());
            } else {
                this.buildEventListener.log(CLIReportingUtils.showVersion());
            }
            throw new ExitException(0);
        }
    }

    private CLIManager newCLIManager() {
        CLIManager cliManager = new CLIManager();
        cliManager.options.addOption(Option.builder((String)RESUME).longOpt("resume").desc("Resume reactor from the last failed project, using the resume.properties file in the build directory").build());
        cliManager.options.addOption(Option.builder().longOpt(RAW_STREAMS).desc("Do not decorate output and error streams").build());
        return cliManager;
    }

    private CommandLine cliMerge(CommandLine mavenArgs, CommandLine mavenConfig) {
        CommandLine.Builder commandLineBuilder = new CommandLine.Builder();
        for (String arg : mavenArgs.getArgs()) {
            commandLineBuilder.addArg(arg);
        }
        for (String arg : mavenConfig.getArgs()) {
            commandLineBuilder.addArg(arg);
        }
        ArrayList<Option> setPropertyOptions = new ArrayList<Option>();
        for (Option opt : mavenArgs.getOptions()) {
            if (String.valueOf('D').equals(opt.getOpt())) {
                setPropertyOptions.add(opt);
                continue;
            }
            commandLineBuilder.addOption(opt);
        }
        for (Option opt : mavenConfig.getOptions()) {
            commandLineBuilder.addOption(opt);
        }
        for (Option opt : setPropertyOptions) {
            commandLineBuilder.addOption(opt);
        }
        return commandLineBuilder.build();
    }

    void logging(CliRequest cliRequest) {
        cliRequest.debug = cliRequest.commandLine.hasOption('X');
        cliRequest.quiet = !cliRequest.debug && cliRequest.commandLine.hasOption('q');
        cliRequest.showErrors = cliRequest.debug || cliRequest.commandLine.hasOption('e');
        Slf4jConfiguration slf4jConfiguration = Slf4jConfigurationFactory.getConfiguration((ILoggerFactory)this.slf4jLoggerFactory);
        if (cliRequest.debug) {
            cliRequest.request.setLoggingLevel(0);
            slf4jConfiguration.setRootLoggerLevel(Slf4jConfiguration.Level.DEBUG);
        } else if (cliRequest.quiet) {
            cliRequest.request.setLoggingLevel(3);
            slf4jConfiguration.setRootLoggerLevel(Slf4jConfiguration.Level.ERROR);
        }
        String styleColor = cliRequest.getUserProperties().getProperty(STYLE_COLOR_PROPERTY, "auto");
        if ("always".equals(styleColor)) {
            MessageUtils.setColorEnabled((boolean)true);
        } else if ("never".equals(styleColor)) {
            MessageUtils.setColorEnabled((boolean)false);
        } else {
            if (!"auto".equals(styleColor)) {
                throw new IllegalArgumentException("Invalid color configuration option [" + styleColor + "]. Supported values are (auto|always|never).");
            }
            if (cliRequest.commandLine.hasOption('B') || cliRequest.commandLine.hasOption("l")) {
                MessageUtils.setColorEnabled((boolean)false);
            }
        }
        if (cliRequest.commandLine.hasOption("l")) {
            File logFile = new File(cliRequest.commandLine.getOptionValue("l"));
            logFile = DaemonMavenCli.resolveFile(logFile, cliRequest.workingDirectory);
            try {
                PrintStream ps = new PrintStream(new FileOutputStream(logFile), true);
                System.setOut(ps);
                System.setErr(ps);
            }
            catch (FileNotFoundException ps) {}
        } else if (!Environment.MVND_RAW_STREAMS.asOptional().map(Boolean::parseBoolean).orElse(Boolean.FALSE).booleanValue()) {
            MvndSimpleLogger stdout = (MvndSimpleLogger)this.slf4jLoggerFactory.getLogger("stdout");
            MvndSimpleLogger stderr = (MvndSimpleLogger)this.slf4jLoggerFactory.getLogger("stderr");
            stdout.setLogLevel(20);
            stderr.setLogLevel(20);
            System.setOut(new LoggingOutputStream(s -> stdout.info("[stdout] " + s)).printStream());
            System.setErr(new LoggingOutputStream(s -> stderr.warn("[stderr] " + s)).printStream());
        }
        slf4jConfiguration.activate();
    }

    private void version(CliRequest cliRequest) throws ExitException {
        if (cliRequest.debug || cliRequest.commandLine.hasOption('V')) {
            this.buildEventListener.log(CLIReportingUtils.showVersion());
        }
    }

    private void commands(CliRequest cliRequest) {
        if (cliRequest.showErrors) {
            this.slf4jLogger.info("Error stacktraces are turned on.");
        }
        if ("warn".equals(cliRequest.request.getGlobalChecksumPolicy())) {
            this.slf4jLogger.info("Disabling strict checksum verification on all artifact downloads.");
        } else if ("fail".equals(cliRequest.request.getGlobalChecksumPolicy())) {
            this.slf4jLogger.info("Enabling strict checksum verification on all artifact downloads.");
        }
        if (this.slf4jLogger.isDebugEnabled()) {
            this.slf4jLogger.debug("Message scheme: {}", (Object)(MessageUtils.isColorEnabled() ? "color" : "plain"));
            if (MessageUtils.isColorEnabled()) {
                MessageBuilder buff = MessageUtils.buffer();
                buff.a((CharSequence)"Message styles: ");
                buff.a((CharSequence)MessageUtils.level().debug("debug")).a((Object)Character.valueOf(' '));
                buff.a((CharSequence)MessageUtils.level().info("info")).a((Object)Character.valueOf(' '));
                buff.a((CharSequence)MessageUtils.level().warning("warning")).a((Object)Character.valueOf(' '));
                buff.a((CharSequence)MessageUtils.level().error("error")).a((Object)Character.valueOf(' '));
                buff.success((Object)"success").a((Object)Character.valueOf(' '));
                buff.failure((Object)"failure").a((Object)Character.valueOf(' '));
                buff.strong((Object)"strong").a((Object)Character.valueOf(' '));
                buff.mojo((Object)"mojo").a((Object)Character.valueOf(' '));
                buff.project((Object)"project");
                this.slf4jLogger.debug(buff.toString());
            }
        }
    }

    void properties(CliRequest cliRequest) throws ExitException {
        try {
            DaemonMavenCli.populateProperties(cliRequest, cliRequest.systemProperties, cliRequest.userProperties);
            StringSearchInterpolator interpolator = DaemonMavenCli.createInterpolator(cliRequest, cliRequest.systemProperties, cliRequest.userProperties);
            CommandLine.Builder commandLineBuilder = new CommandLine.Builder();
            for (Option option : cliRequest.commandLine.getOptions()) {
                if (!String.valueOf('D').equals(option.getOpt())) {
                    List values = option.getValuesList();
                    ListIterator<String> it = values.listIterator();
                    while (it.hasNext()) {
                        it.set(interpolator.interpolate((String)it.next()));
                    }
                }
                commandLineBuilder.addOption(option);
            }
            for (String arg : cliRequest.commandLine.getArgList()) {
                commandLineBuilder.addArg(interpolator.interpolate(arg));
            }
            cliRequest.commandLine = commandLineBuilder.build();
        }
        catch (InterpolationException e) {
            String message = "ERROR: Could not interpolate properties and/or arguments: " + e.getMessage();
            System.err.println(message);
            throw new ExitException(1);
        }
        catch (MavenCli.IllegalUseOfUndefinedProperty e) {
            String message = "ERROR: Illegal use of undefined property: " + e.property;
            System.err.println(message);
            if (cliRequest.rootDirectory == null) {
                System.err.println();
                System.err.println(UNABLE_TO_FIND_ROOT_PROJECT_MESSAGE);
            }
            throw new ExitException(1);
        }
    }

    protected static StringSearchInterpolator createInterpolator(final CliRequest cliRequest, final Properties ... properties) {
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.addValueSource((ValueSource)new AbstractValueSource(false){

            public Object getValue(String expression) {
                if ("session.topDirectory".equals(expression)) {
                    Path topDirectory = cliRequest.topDirectory;
                    if (topDirectory != null) {
                        return topDirectory.toString();
                    }
                    throw new MavenCli.IllegalUseOfUndefinedProperty(expression);
                }
                if ("session.rootDirectory".equals(expression)) {
                    Path rootDirectory = cliRequest.rootDirectory;
                    if (rootDirectory != null) {
                        return rootDirectory.toString();
                    }
                    throw new MavenCli.IllegalUseOfUndefinedProperty(expression);
                }
                return null;
            }
        });
        interpolator.addValueSource((ValueSource)new AbstractValueSource(false){

            public Object getValue(String expression) {
                for (Properties props : properties) {
                    String val = props.getProperty(expression);
                    if (val == null) continue;
                    return val;
                }
                return null;
            }
        });
        return interpolator;
    }

    void container(CliRequest cliRequest) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("plexus", this.container);
        data.put("workingDirectory", cliRequest.workingDirectory);
        data.put("systemProperties", cliRequest.systemProperties);
        data.put("userProperties", cliRequest.userProperties);
        data.put("versionProperties", CLIReportingUtils.getBuildProperties());
        this.eventSpyDispatcher.init(() -> data);
    }

    DefaultPlexusContainer container() throws Exception {
        ClassRealm coreRealm = this.classWorld.getClassRealm("plexus.core");
        if (coreRealm == null) {
            coreRealm = (ClassRealm)this.classWorld.getRealms().iterator().next();
        }
        List<File> extClassPath = Stream.of(Environment.MVND_EXT_CLASSPATH.asString().split(",")).filter(s -> s != null && !s.isEmpty()).map(File::new).collect(Collectors.toList());
        CoreExtensionEntry coreEntry = CoreExtensionEntry.discoverFrom((ClassRealm)coreRealm);
        List<CoreExtension> extensions = Stream.of(Environment.MVND_CORE_EXTENSIONS.asString().split(";")).filter(s -> s != null && !s.isEmpty()).map(s -> {
            String[] parts = s.split(":");
            CoreExtension ce = new CoreExtension();
            ce.setGroupId(parts[0]);
            ce.setArtifactId(parts[1]);
            ce.setVersion(parts[2]);
            return ce;
        }).collect(Collectors.toList());
        List<CoreExtensionEntry> extensionsEntries = this.loadCoreExtensions(extensions, coreRealm, coreEntry.getExportedArtifacts());
        ClassRealm containerRealm = this.setupContainerRealm(this.classWorld, coreRealm, extClassPath, extensionsEntries);
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(this.classWorld).setRealm(containerRealm).setClassPathScanning("index").setAutoWiring(true).setJSR250Lifecycle(true).setName("maven");
        HashSet<String> exportedArtifacts = new HashSet<String>(coreEntry.getExportedArtifacts());
        HashSet<String> exportedPackages = new HashSet<String>(coreEntry.getExportedPackages());
        for (CoreExtensionEntry extension : extensionsEntries) {
            exportedArtifacts.addAll(extension.getExportedArtifacts());
            exportedPackages.addAll(extension.getExportedPackages());
        }
        exportedPackages.add("org.codehaus.plexus.components.interactivity");
        exportedPackages.add("org.mvndaemon.mvnd.interactivity");
        exportedArtifacts.add("org.codehaus.plexus:plexus-interactivity-api");
        final CoreExports exports = new CoreExports(containerRealm, exportedArtifacts, exportedPackages);
        DefaultPlexusContainer container = new DefaultPlexusContainer(cc, new Module[]{new AbstractModule(this){
            final /* synthetic */ DaemonMavenCli this$0;
            {
                this.this$0 = this$0;
            }

            protected void configure() {
                this.bind(ILoggerFactory.class).toInstance((Object)this.this$0.slf4jLoggerFactory);
                this.bind(CoreExports.class).toInstance((Object)exports);
                this.bind(ExtensionRealmCache.class).to(InvalidatingExtensionRealmCache.class);
                this.bind(PluginArtifactsCache.class).to(InvalidatingPluginArtifactsCache.class);
                this.bind(PluginRealmCache.class).to(InvalidatingPluginRealmCache.class);
                this.bind(ProjectArtifactsCache.class).to(InvalidatingProjectArtifactsCache.class);
                this.bind(PluginVersionResolver.class).to(CachingPluginVersionResolver.class);
            }
        }});
        container.setLookupRealm(null);
        Thread.currentThread().setContextClassLoader((ClassLoader)container.getContainerRealm());
        container.setLoggerManager((LoggerManager)this.plexusLoggerManager);
        for (CoreExtensionEntry extension : extensionsEntries) {
            container.discoverComponents(extension.getClassRealm(), new Module[]{new SessionScopeModule((PlexusContainer)container), new MojoExecutionScopeModule((PlexusContainer)container)});
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CoreExtensionEntry> loadCoreExtensions(List<CoreExtension> extensions, ClassRealm containerRealm, Set<String> providedArtifacts) throws Exception {
        if (extensions.isEmpty()) {
            return Collections.emptyList();
        }
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(this.classWorld).setRealm(containerRealm).setClassPathScanning("index").setAutoWiring(true).setJSR250Lifecycle(true).setName("maven");
        DefaultPlexusContainer container = new DefaultPlexusContainer(cc, new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(ILoggerFactory.class).toInstance((Object)DaemonMavenCli.this.slf4jLoggerFactory);
            }
        }});
        MavenExecutionRequestPopulator executionRequestPopulator = null;
        try {
            CliRequest cliRequest = new CliRequest(new String[0], this.classWorld);
            cliRequest.commandLine = new CommandLine.Builder().build();
            container.setLookupRealm(null);
            container.setLoggerManager((LoggerManager)this.plexusLoggerManager);
            container.getLoggerManager().setThresholds(cliRequest.request.getLoggingLevel());
            Thread.currentThread().setContextClassLoader((ClassLoader)container.getContainerRealm());
            executionRequestPopulator = (MavenExecutionRequestPopulator)container.lookup(MavenExecutionRequestPopulator.class);
            Map configurationProcessors = container.lookupMap(ConfigurationProcessor.class);
            EventSpyDispatcher eventSpyDispatcher = (EventSpyDispatcher)container.lookup(EventSpyDispatcher.class);
            this.properties(cliRequest);
            DaemonMavenCli.configure(cliRequest, eventSpyDispatcher, configurationProcessors);
            LoggingExecutionListener executionListener = (LoggingExecutionListener)container.lookup(LoggingExecutionListener.class);
            DaemonMavenCli.populateRequest(cliRequest, cliRequest.request, this.slf4jLogger, eventSpyDispatcher, (ModelProcessor)container.lookup(ModelProcessor.class), this.createTransferListener(cliRequest), this.buildEventListener, executionListener);
            executionRequestPopulator.populateDefaults(cliRequest.request);
            BootstrapCoreExtensionManager resolver = (BootstrapCoreExtensionManager)container.lookup(BootstrapCoreExtensionManager.class);
            List<CoreExtensionEntry> list = Collections.unmodifiableList(resolver.loadCoreExtensions(cliRequest.request, providedArtifacts, extensions));
            return list;
        }
        finally {
            executionRequestPopulator = null;
            container.dispose();
        }
    }

    private ClassRealm setupContainerRealm(ClassWorld classWorld, ClassRealm coreRealm, List<File> extClassPath, List<CoreExtensionEntry> extensions) throws Exception {
        if (!extClassPath.isEmpty() || !extensions.isEmpty()) {
            ClassRealm extRealm = classWorld.newRealm("maven.ext", null);
            extRealm.setParentRealm(coreRealm);
            this.slf4jLogger.debug("Populating class realm {}", (Object)extRealm.getId());
            for (File file : extClassPath) {
                extRealm.addURL(file.toURI().toURL());
            }
            for (CoreExtensionEntry entry : DaemonMavenCli.reverse(extensions)) {
                Set exportedPackages = entry.getExportedPackages();
                ClassRealm realm = entry.getClassRealm();
                for (String exportedPackage : exportedPackages) {
                    extRealm.importFrom((ClassLoader)realm, exportedPackage);
                }
                if (!exportedPackages.isEmpty()) continue;
                extRealm.importFrom((ClassLoader)realm, realm.getId());
            }
            return extRealm;
        }
        return coreRealm;
    }

    private static <T> List<T> reverse(List<T> list) {
        ArrayList<T> copy = new ArrayList<T>(list);
        Collections.reverse(copy);
        return copy;
    }

    private List<File> parseExtClasspath(CliRequest cliRequest) {
        String extClassPath = cliRequest.userProperties.getProperty(EXT_CLASS_PATH);
        if (extClassPath == null) {
            extClassPath = cliRequest.systemProperties.getProperty(EXT_CLASS_PATH);
        }
        ArrayList<File> jars = new ArrayList<File>();
        if (extClassPath != null) {
            for (String jar : extClassPath.split(File.pathSeparator)) {
                File file = DaemonMavenCli.resolveFile(new File(jar), cliRequest.workingDirectory);
                this.slf4jLogger.debug("  Included {}", (Object)file);
                jars.add(file);
            }
        }
        return jars;
    }

    private void encryption(CliRequest cliRequest) throws Exception {
        if (cliRequest.commandLine.hasOption("emp")) {
            throw new UnsupportedOperationException("Unsupported option: emp");
        }
        if (cliRequest.commandLine.hasOption("ep")) {
            throw new UnsupportedOperationException("Unsupported option: ep");
        }
    }

    private void environment(String workingDir, Map<String, String> clientEnv) {
        EnvHelper.environment(workingDir, clientEnv);
    }

    private int execute(CliRequest cliRequest) throws MavenExecutionRequestPopulationException {
        this.commands(cliRequest);
        MavenExecutionRequest request = this.executionRequestPopulator.populateDefaults(cliRequest.request);
        this.eventSpyDispatcher.onEvent((Object)request);
        this.slf4jLogger.info(MessageUtils.buffer().a((CharSequence)"Processing build on daemon ").strong((Object)Environment.MVND_ID.asString()).toString());
        MavenExecutionResult result = this.maven.execute(request);
        LoggingOutputStream.forceFlush((PrintStream)System.out);
        LoggingOutputStream.forceFlush((PrintStream)System.err);
        this.eventSpyDispatcher.onEvent((Object)result);
        if (result.hasExceptions()) {
            boolean canResume;
            DefaultExceptionHandler handler = new DefaultExceptionHandler();
            LinkedHashMap<String, String> references = new LinkedHashMap<String, String>();
            ArrayList<MavenProject> failedProjects = new ArrayList<MavenProject>();
            for (Throwable throwable : result.getExceptions()) {
                MavenProject project;
                ExceptionSummary summary = handler.handleException(throwable);
                this.logSummary(summary, references, "", cliRequest.showErrors);
                if (!(throwable instanceof LifecycleExecutionException) || (project = ((LifecycleExecutionException)throwable).getProject()) == null) continue;
                failedProjects.add(project);
            }
            this.slf4jLogger.error("");
            if (!cliRequest.showErrors) {
                this.slf4jLogger.error("To see the full stack trace of the errors, re-run Maven with the {} switch.", (Object)MessageUtils.buffer().strong((Object)"-e"));
            }
            if (!this.slf4jLogger.isDebugEnabled()) {
                this.slf4jLogger.error("Re-run Maven using the {} switch to enable full debug logging.", (Object)MessageUtils.buffer().strong((Object)"-X"));
            }
            if (!references.isEmpty()) {
                this.slf4jLogger.error("");
                this.slf4jLogger.error("For more information about the errors and possible solutions, please read the following articles:");
                for (Map.Entry entry : references.entrySet()) {
                    this.slf4jLogger.error("{} {}", (Object)MessageUtils.buffer().strong(entry.getValue()), entry.getKey());
                }
            }
            if (canResume = new DefaultBuildResumptionAnalyzer().determineBuildResumptionData(result).map(resumption -> {
                try {
                    Path directory = Paths.get(request.getBaseDirectory(), new String[0]).resolve("target");
                    new DefaultBuildResumptionDataRepository().persistResumptionData(directory, (BuildResumptionData)resumption);
                    return true;
                }
                catch (BuildResumptionPersistenceException e) {
                    this.slf4jLogger.warn("Could not persist build resumption data", (Throwable)e);
                    return false;
                }
            }).orElse(false).booleanValue()) {
                this.logBuildResumeHint("mvn <args> -r");
            } else if (!failedProjects.isEmpty()) {
                List list = result.getTopologicallySortedProjects();
                failedProjects.sort(Comparator.comparing(list::indexOf));
                MavenProject firstFailedProject = (MavenProject)failedProjects.get(0);
                if (!firstFailedProject.equals(list.get(0))) {
                    String resumeFromSelector = this.getResumeFromSelector(list, firstFailedProject);
                    this.logBuildResumeHint("mvn <args> -rf " + resumeFromSelector);
                }
            }
            if ("FAIL_NEVER".equals(cliRequest.request.getReactorFailureBehavior())) {
                this.slf4jLogger.info("Build failures were ignored.");
                return 0;
            }
            return 1;
        }
        Path directory = Paths.get(request.getBaseDirectory(), new String[0]).resolve("target");
        new DefaultBuildResumptionDataRepository().removeResumptionData(directory);
        return 0;
    }

    private void logBuildResumeHint(String resumeBuildHint) {
        this.slf4jLogger.error("");
        this.slf4jLogger.error("After correcting the problems, you can resume the build with the command");
        this.slf4jLogger.error(MessageUtils.buffer().a((CharSequence)"  ").strong((Object)resumeBuildHint).toString());
    }

    private String getResumeFromSelector(List<MavenProject> mavenProjects, MavenProject failedProject) {
        for (MavenProject buildProject : mavenProjects) {
            if (!failedProject.getArtifactId().equals(buildProject.getArtifactId()) || failedProject.equals((Object)buildProject)) continue;
            return failedProject.getGroupId() + ":" + failedProject.getArtifactId();
        }
        return ":" + failedProject.getArtifactId();
    }

    private void logSummary(ExceptionSummary summary, Map<String, String> references, String indent, boolean showErrors) {
        String msg = summary.getMessage();
        if (!summary.getReference().isEmpty()) {
            String referenceKey = references.computeIfAbsent(summary.getReference(), k -> "[Help " + (references.size() + 1) + "]");
            msg = msg.indexOf(10) < 0 ? msg + " -> " + MessageUtils.buffer().strong((Object)referenceKey) : msg + "\n-> " + MessageUtils.buffer().strong((Object)referenceKey);
        }
        String[] lines = msg.split("(\r\n)|(\r)|(\n)");
        String currentColor = "";
        for (int i = 0; i < lines.length; ++i) {
            String line = currentColor + lines[i];
            Matcher matcher = LAST_ANSI_SEQUENCE.matcher(line);
            String nextColor = "";
            if (matcher.find() && ANSI_RESET.equals(nextColor = matcher.group(1))) {
                nextColor = "";
            }
            line = indent + line + ("".equals(nextColor) ? "" : ANSI_RESET);
            if (i == lines.length - 1 && (showErrors || summary.getException() instanceof InternalErrorException)) {
                this.slf4jLogger.error(line, summary.getException());
            } else {
                this.slf4jLogger.error(line);
            }
            currentColor = nextColor;
        }
        indent = indent + "  ";
        for (ExceptionSummary child : summary.getChildren()) {
            this.logSummary(child, references, indent, showErrors);
        }
    }

    private static void configure(CliRequest cliRequest, EventSpyDispatcher eventSpyDispatcher, Map<String, ConfigurationProcessor> configurationProcessors) throws Exception {
        cliRequest.request.setEventSpyDispatcher(eventSpyDispatcher);
        int userSuppliedConfigurationProcessorCount = configurationProcessors.size() - 1;
        if (userSuppliedConfigurationProcessorCount == 0) {
            configurationProcessors.get("settings").process(cliRequest);
        } else if (userSuppliedConfigurationProcessorCount == 1) {
            for (Map.Entry<String, ConfigurationProcessor> entry : configurationProcessors.entrySet()) {
                String hint = entry.getKey();
                if (hint.equals("settings")) continue;
                ConfigurationProcessor configurationProcessor = entry.getValue();
                configurationProcessor.process(cliRequest);
            }
        } else if (userSuppliedConfigurationProcessorCount > 1) {
            StringBuilder sb = new StringBuilder(String.format("\nThere can only be one user supplied ConfigurationProcessor, there are %s:\n\n", userSuppliedConfigurationProcessorCount));
            for (Map.Entry<String, ConfigurationProcessor> entry : configurationProcessors.entrySet()) {
                String hint = entry.getKey();
                if (hint.equals("settings")) continue;
                ConfigurationProcessor configurationProcessor = entry.getValue();
                sb.append(String.format("%s\n", configurationProcessor.getClass().getName()));
            }
            sb.append("\n");
            throw new Exception(sb.toString());
        }
    }

    void toolchains(CliRequest cliRequest) throws Exception {
        File globalToolchainsFile;
        File userToolchainsFile;
        if (cliRequest.commandLine.hasOption('t')) {
            userToolchainsFile = new File(cliRequest.commandLine.getOptionValue('t'));
            if (!(userToolchainsFile = DaemonMavenCli.resolveFile(userToolchainsFile, cliRequest.workingDirectory)).isFile()) {
                throw new FileNotFoundException("The specified user toolchains file does not exist: " + userToolchainsFile);
            }
        } else {
            userToolchainsFile = DEFAULT_USER_TOOLCHAINS_FILE;
        }
        if (cliRequest.commandLine.hasOption("gt")) {
            globalToolchainsFile = new File(cliRequest.commandLine.getOptionValue("gt"));
            if (!(globalToolchainsFile = DaemonMavenCli.resolveFile(globalToolchainsFile, cliRequest.workingDirectory)).isFile()) {
                throw new FileNotFoundException("The specified global toolchains file does not exist: " + globalToolchainsFile);
            }
        } else {
            globalToolchainsFile = DEFAULT_GLOBAL_TOOLCHAINS_FILE;
        }
        cliRequest.request.setGlobalToolchainsFile(globalToolchainsFile);
        cliRequest.request.setUserToolchainsFile(userToolchainsFile);
        DefaultToolchainsBuildingRequest toolchainsRequest = new DefaultToolchainsBuildingRequest();
        if (globalToolchainsFile.isFile()) {
            toolchainsRequest.setGlobalToolchainsSource((Source)new FileSource(globalToolchainsFile));
        }
        if (userToolchainsFile.isFile()) {
            toolchainsRequest.setUserToolchainsSource((Source)new FileSource(userToolchainsFile));
        }
        this.eventSpyDispatcher.onEvent((Object)toolchainsRequest);
        this.slf4jLogger.debug("Reading global toolchains from {}", this.getLocation(toolchainsRequest.getGlobalToolchainsSource(), globalToolchainsFile));
        this.slf4jLogger.debug("Reading user toolchains from {}", this.getLocation(toolchainsRequest.getUserToolchainsSource(), userToolchainsFile));
        ToolchainsBuildingResult toolchainsResult = this.toolchainsBuilder.build((ToolchainsBuildingRequest)toolchainsRequest);
        this.eventSpyDispatcher.onEvent((Object)toolchainsResult);
        this.executionRequestPopulator.populateFromToolchains(cliRequest.request, toolchainsResult.getEffectiveToolchains());
        if (!toolchainsResult.getProblems().isEmpty() && this.slf4jLogger.isWarnEnabled()) {
            this.slf4jLogger.warn("");
            this.slf4jLogger.warn("Some problems were encountered while building the effective toolchains");
            for (Problem problem : toolchainsResult.getProblems()) {
                this.slf4jLogger.warn("{} @ {}", (Object)problem.getMessage(), (Object)problem.getLocation());
            }
            this.slf4jLogger.warn("");
        }
    }

    private Object getLocation(Source source, File defaultLocation) {
        if (source != null) {
            return source.getLocation();
        }
        return defaultLocation;
    }

    private void populateRequest(CliRequest cliRequest) {
        DaemonMavenCli.populateRequest(cliRequest, cliRequest.request, this.slf4jLogger, this.eventSpyDispatcher, this.modelProcessor, this.createTransferListener(cliRequest), this.buildEventListener, this.executionListener);
    }

    private static void populateRequest(CliRequest cliRequest, MavenExecutionRequest request, Logger slf4jLogger, EventSpyDispatcher eventSpyDispatcher, ModelProcessor modelProcessor, TransferListener transferListener, BuildEventListener buildEventListener, LoggingExecutionListener executionListener) {
        String threadConfiguration;
        File pom;
        String[] profileOptionValues;
        String[] deprecatedOptions;
        CommandLine commandLine = cliRequest.commandLine;
        String workingDirectory = cliRequest.workingDirectory;
        boolean showErrors = cliRequest.showErrors;
        for (String deprecatedOption : deprecatedOptions = new String[]{"up", "npu", "cpu", "npr"}) {
            if (!commandLine.hasOption(deprecatedOption)) continue;
            slf4jLogger.warn("Command line option -{} is deprecated and will be removed in future Maven versions.", (Object)deprecatedOption);
        }
        if (commandLine.hasOption('B')) {
            request.setInteractiveMode(false);
        }
        boolean noSnapshotUpdates = false;
        if (commandLine.hasOption("nsu")) {
            noSnapshotUpdates = true;
        }
        List goals = commandLine.getArgList();
        boolean recursive = true;
        String reactorFailureBehaviour = "FAIL_FAST";
        if (commandLine.hasOption('N')) {
            recursive = false;
        }
        if (commandLine.hasOption("ff")) {
            reactorFailureBehaviour = "FAIL_FAST";
        } else if (commandLine.hasOption("fae")) {
            reactorFailureBehaviour = "FAIL_AT_END";
        } else if (commandLine.hasOption("fn")) {
            reactorFailureBehaviour = "FAIL_NEVER";
        }
        if (commandLine.hasOption('o')) {
            request.setOffline(true);
        }
        boolean updateSnapshots = false;
        if (commandLine.hasOption('U')) {
            updateSnapshots = true;
        }
        String globalChecksumPolicy = null;
        if (commandLine.hasOption('C')) {
            globalChecksumPolicy = "fail";
        } else if (commandLine.hasOption('c')) {
            globalChecksumPolicy = "warn";
        }
        File baseDirectory = new File(workingDirectory, "").getAbsoluteFile();
        ArrayList<String> activeProfiles = new ArrayList<String>();
        ArrayList<String> inactiveProfiles = new ArrayList<String>();
        if (commandLine.hasOption('P') && (profileOptionValues = commandLine.getOptionValues('P')) != null) {
            for (String profileOptionValue : profileOptionValues) {
                StringTokenizer profileTokens = new StringTokenizer(profileOptionValue, ",");
                while (profileTokens.hasMoreTokens()) {
                    String profileAction = profileTokens.nextToken().trim();
                    if (profileAction.startsWith("-") || profileAction.startsWith("!")) {
                        inactiveProfiles.add(profileAction.substring(1));
                        continue;
                    }
                    if (profileAction.startsWith("+")) {
                        activeProfiles.add(profileAction.substring(1));
                        continue;
                    }
                    activeProfiles.add(profileAction);
                }
            }
        }
        ExecutionEventLogger executionEventLogger = new ExecutionEventLogger();
        executionListener.init(eventSpyDispatcher.chainListener((ExecutionListener)executionEventLogger), buildEventListener);
        String alternatePomFile = null;
        if (commandLine.hasOption('f')) {
            alternatePomFile = commandLine.getOptionValue('f');
        }
        request.setBaseDirectory(baseDirectory).setGoals(goals).setSystemProperties(cliRequest.systemProperties).setUserProperties(cliRequest.userProperties).setReactorFailureBehavior(reactorFailureBehaviour).setRecursive(recursive).setShowErrors(showErrors).addActiveProfiles(activeProfiles).addInactiveProfiles(inactiveProfiles).setExecutionListener((ExecutionListener)executionListener).setTransferListener(transferListener).setUpdateSnapshots(updateSnapshots).setNoSnapshotUpdates(noSnapshotUpdates).setGlobalChecksumPolicy(globalChecksumPolicy).setMultiModuleProjectDirectory(cliRequest.getMultiModuleProjectDirectory());
        if (alternatePomFile != null) {
            File pom2 = DaemonMavenCli.resolveFile(new File(alternatePomFile), workingDirectory);
            if (pom2.isDirectory()) {
                pom2 = new File(pom2, "pom.xml");
            }
            request.setPom(pom2);
        } else if (modelProcessor != null && (pom = modelProcessor.locatePom(baseDirectory)).isFile()) {
            request.setPom(pom);
        }
        if (request.getPom() != null && request.getPom().getParentFile() != null) {
            request.setBaseDirectory(request.getPom().getParentFile());
        }
        if (commandLine.hasOption(RESUME)) {
            new DefaultBuildResumptionDataRepository().applyResumptionData(request, Paths.get(request.getBaseDirectory(), new String[0]).resolve("target"));
        }
        if (commandLine.hasOption("rf")) {
            request.setResumeFrom(commandLine.getOptionValue("rf"));
        }
        if (commandLine.hasOption("pl")) {
            String[] projectOptionValues = commandLine.getOptionValues("pl");
            ArrayList<String> inclProjects = new ArrayList<String>();
            ArrayList<String> exclProjects = new ArrayList<String>();
            if (projectOptionValues != null) {
                for (String projectOptionValue : projectOptionValues) {
                    StringTokenizer projectTokens = new StringTokenizer(projectOptionValue, ",");
                    while (projectTokens.hasMoreTokens()) {
                        String projectAction = projectTokens.nextToken().trim();
                        if (projectAction.startsWith("-") || projectAction.startsWith("!")) {
                            exclProjects.add(projectAction.substring(1));
                            continue;
                        }
                        if (projectAction.startsWith("+")) {
                            inclProjects.add(projectAction.substring(1));
                            continue;
                        }
                        inclProjects.add(projectAction);
                    }
                }
            }
            request.setSelectedProjects(inclProjects);
            request.setExcludedProjects(exclProjects);
        }
        if (commandLine.hasOption("am") && !commandLine.hasOption("amd")) {
            request.setMakeBehavior("make-upstream");
        } else if (!commandLine.hasOption("am") && commandLine.hasOption("amd")) {
            request.setMakeBehavior("make-downstream");
        } else if (commandLine.hasOption("am") && commandLine.hasOption("amd")) {
            request.setMakeBehavior("make-both");
        }
        String localRepoProperty = request.getUserProperties().getProperty(LOCAL_REPO_PROPERTY);
        if (localRepoProperty == null) {
            localRepoProperty = request.getSystemProperties().getProperty(LOCAL_REPO_PROPERTY);
        }
        if (localRepoProperty != null) {
            request.setLocalRepositoryPath(localRepoProperty);
        }
        request.setCacheNotFound(true);
        request.setCacheTransferError(false);
        request.setIgnoreTransitiveRepositories(commandLine.hasOption("itr"));
        String string = threadConfiguration = commandLine.hasOption("T") ? commandLine.getOptionValue("T") : null;
        if (threadConfiguration != null) {
            request.setBuilderId("multithreaded");
            if (threadConfiguration.contains("C")) {
                request.setDegreeOfConcurrency(DaemonMavenCli.calculateDegreeOfConcurrencyWithCoreMultiplier(threadConfiguration));
            } else {
                request.setDegreeOfConcurrency(Integer.parseInt(threadConfiguration));
            }
        }
        if (commandLine.hasOption("b")) {
            request.setBuilderId(commandLine.getOptionValue("b"));
        }
    }

    static int calculateDegreeOfConcurrencyWithCoreMultiplier(String threadConfiguration) {
        int procs = Runtime.getRuntime().availableProcessors();
        return (int)(Float.parseFloat(threadConfiguration.replace("C", "")) * (float)procs);
    }

    static File resolveFile(File file, String workingDirectory) {
        if (file == null) {
            return null;
        }
        if (file.isAbsolute()) {
            return file;
        }
        if (file.getPath().startsWith(File.separator)) {
            return file.getAbsoluteFile();
        }
        return new File(workingDirectory, file.getPath()).getAbsoluteFile();
    }

    static void populateProperties(CliRequest cliRequest, Properties systemProperties, Properties userProperties) throws InterpolationException {
        String[] defStrs;
        Properties cliProperties = new Properties();
        if (cliRequest.commandLine.hasOption('D') && (defStrs = cliRequest.commandLine.getOptionValues('D')) != null) {
            for (String defStr : defStrs) {
                DaemonMavenCli.setCliProperty(defStr, cliProperties);
            }
        }
        DaemonMavenCli.addEnvVars(systemProperties);
        SystemProperties.addSystemProperties((Properties)systemProperties);
        StringSearchInterpolator interpolator = DaemonMavenCli.createInterpolator(cliRequest, cliProperties, systemProperties);
        for (Map.Entry entry : cliProperties.entrySet()) {
            String name = (String)entry.getKey();
            String value = interpolator.interpolate((String)entry.getValue());
            userProperties.setProperty(name, value);
        }
        systemProperties.putAll((Map<?, ?>)userProperties);
        userProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> System.setProperty((String)k, (String)v)));
        Properties buildProperties = CLIReportingUtils.getBuildProperties();
        String string = buildProperties.getProperty("version");
        systemProperties.setProperty("maven.version", string);
        String mavenBuildVersion = CLIReportingUtils.createMavenVersionString((Properties)buildProperties);
        systemProperties.setProperty("maven.build.version", mavenBuildVersion);
    }

    public static void addEnvVars(Properties props) {
        if (props != null) {
            boolean caseSensitive = Os.current() == Os.WINDOWS;
            for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                String key = "env." + (caseSensitive ? entry.getKey() : entry.getKey().toUpperCase(Locale.ENGLISH));
                props.setProperty(key, entry.getValue());
            }
        }
    }

    private static void setCliProperty(String property, Properties properties) {
        String value;
        String name;
        int i = property.indexOf(61);
        if (i <= 0) {
            name = property.trim();
            value = "true";
        } else {
            name = property.substring(0, i).trim();
            value = property.substring(i + 1);
        }
        properties.setProperty(name, value);
        System.setProperty(name, value);
    }

    protected TransferListener createTransferListener(CliRequest cliRequest) {
        if (cliRequest.quiet || cliRequest.commandLine.hasOption("ntp")) {
            return new QuietMavenTransferListener();
        }
        if (cliRequest.request.isInteractiveMode() && !cliRequest.commandLine.hasOption("l")) {
            return this.getConsoleTransferListener();
        }
        return this.getBatchTransferListener();
    }

    protected TransferListener getConsoleTransferListener() {
        return new DaemonMavenTransferListener(this.buildEventListener, (TransferListener)new Slf4jMavenTransferListener());
    }

    protected TransferListener getBatchTransferListener() {
        return new Slf4jMavenTransferListener();
    }

    protected ModelProcessor createModelProcessor(PlexusContainer container) throws ComponentLookupException {
        return (ModelProcessor)container.lookup(ModelProcessor.class);
    }

    static class ExitException
    extends Exception {
        static final long serialVersionUID = 1L;
        int exitCode;

        ExitException(int exitCode) {
            this.exitCode = exitCode;
        }
    }
}

