/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mvndaemon.mvnd.client.DaemonDiagnostics;
import org.mvndaemon.mvnd.client.DaemonParameters;
import org.mvndaemon.mvnd.common.DaemonConnection;
import org.mvndaemon.mvnd.common.DaemonException;
import org.mvndaemon.mvnd.common.DaemonInfo;
import org.mvndaemon.mvnd.common.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaemonClientConnection
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(DaemonClientConnection.class);
    private final DaemonConnection connection;
    private final DaemonInfo daemon;
    private final StaleAddressDetector staleAddressDetector;
    private final boolean newDaemon;
    private boolean hasReceived;
    private final Lock dispatchLock = new ReentrantLock();
    private final BlockingQueue<Message> queue = new ArrayBlockingQueue<Message>(16);
    private final Thread receiver;
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final AtomicReference<Exception> exception = new AtomicReference();
    private final long maxKeepAliveMs;
    private final DaemonParameters parameters;

    public DaemonClientConnection(DaemonConnection connection, DaemonInfo daemon, StaleAddressDetector staleAddressDetector, boolean newDaemon, DaemonParameters parameters) {
        this.connection = connection;
        this.daemon = daemon;
        this.staleAddressDetector = staleAddressDetector;
        this.newDaemon = newDaemon;
        this.receiver = new Thread(this::doReceive);
        this.receiver.start();
        this.parameters = parameters;
        this.maxKeepAliveMs = parameters.keepAlive().toMillis() * (long)parameters.maxLostKeepAlive();
    }

    public DaemonInfo getDaemon() {
        return this.daemon;
    }

    public void dispatch(Message message) throws DaemonException.ConnectException {
        LOG.debug("thread {}: dispatching {}", (Object)Thread.currentThread().getId(), message.getClass());
        try {
            this.dispatchLock.lock();
            try {
                this.connection.dispatch(message);
                this.connection.flush();
            }
            finally {
                this.dispatchLock.unlock();
            }
        }
        catch (DaemonException.MessageIOException e) {
            LOG.debug("Problem dispatching message to the daemon. Performing 'on failure' operation...");
            if (!this.hasReceived && this.staleAddressDetector.maybeStaleAddress((Exception)((Object)e))) {
                throw new DaemonException.StaleAddressException("Could not dispatch a message to the daemon.", (Throwable)e);
            }
            throw new DaemonException.ConnectException("Could not dispatch a message to the daemon.", (Throwable)e);
        }
        try {
            if (message.getType() == 17) {
                this.queue.put(message);
            }
        }
        catch (InterruptedException e) {
            throw new DaemonException.InterruptedException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> receive() throws DaemonException.ConnectException, DaemonException.StaleAddressException {
        while (true) {
            try {
                Message m = this.queue.poll(this.maxKeepAliveMs, TimeUnit.MILLISECONDS);
                Exception e = this.exception.get();
                if (e != null) {
                    throw e;
                }
                if (m == null) {
                    throw new IOException("No message received within " + this.maxKeepAliveMs + "ms, daemon may have crashed. You may want to check its status using mvnd --status");
                }
                ArrayList<Message> result = new ArrayList<Message>(4);
                result.add(m);
                this.queue.drainTo(result);
                Exception e2 = this.exception.get();
                if (e2 != null) {
                    throw e2;
                }
                ArrayList<Message> arrayList = result;
                return arrayList;
            }
            catch (Exception e) {
                DaemonDiagnostics diag = new DaemonDiagnostics(this.daemon.getId(), this.parameters);
                LOG.debug("Problem receiving message to the daemon. Performing 'on failure' operation...");
                if (!this.hasReceived && this.newDaemon) {
                    throw new DaemonException.ConnectException("Could not receive a message from the daemon.\n" + diag.describe(), (Throwable)e);
                }
                if (!this.staleAddressDetector.maybeStaleAddress(e)) continue;
                throw new DaemonException.StaleAddressException("Could not receive a message from the daemon.\n" + diag.describe(), (Throwable)e);
            }
            finally {
                this.hasReceived = true;
                continue;
            }
            break;
        }
    }

    public void enqueue(Message message) {
        try {
            this.queue.put(message);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doReceive() {
        block3: {
            try {
                Message m;
                while (this.running.get() && (m = this.connection.receive()) != null) {
                    this.queue.put(m);
                }
            }
            catch (Exception e) {
                if (!this.running.get()) break block3;
                this.exception.set(e);
            }
        }
    }

    @Override
    public void close() {
        LOG.debug("thread {}: connection stop", (Object)Thread.currentThread().getId());
        this.running.set(false);
        this.receiver.interrupt();
        this.connection.close();
    }

    public static interface StaleAddressDetector {
        public boolean maybeStaleAddress(Exception var1);
    }
}

