/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.artifact;

import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.artifact.AbstractArtifact;
import org.eclipse.aether.artifact.Artifact;

public final class SubArtifact
extends AbstractArtifact {
    private final Artifact mainArtifact;
    private final String classifier;
    private final String extension;
    private final Path path;
    private final Map<String, String> properties;

    public SubArtifact(Artifact mainArtifact, String classifier, String extension) {
        this(mainArtifact, classifier, extension, (File)null);
    }

    public SubArtifact(Artifact mainArtifact, String classifier, String extension, File file) {
        this(mainArtifact, classifier, extension, null, file);
    }

    public SubArtifact(Artifact mainArtifact, String classifier, String extension, Path path) {
        this(mainArtifact, classifier, extension, null, path);
    }

    public SubArtifact(Artifact mainArtifact, String classifier, String extension, Map<String, String> properties) {
        this(mainArtifact, classifier, extension, properties, (Path)null);
    }

    public SubArtifact(Artifact mainArtifact, String classifier, String extension, Map<String, String> properties, File file) {
        this(mainArtifact, classifier, extension, properties, file != null ? file.toPath() : null);
    }

    public SubArtifact(Artifact mainArtifact, String classifier, String extension, Map<String, String> properties, Path path) {
        this.mainArtifact = Objects.requireNonNull(mainArtifact, "main artifact cannot be null");
        this.classifier = classifier;
        this.extension = extension;
        this.path = path;
        this.properties = SubArtifact.copyProperties(properties);
    }

    private SubArtifact(Artifact mainArtifact, String classifier, String extension, Path path, Map<String, String> properties) {
        this.mainArtifact = mainArtifact;
        this.classifier = classifier;
        this.extension = extension;
        this.path = path;
        this.properties = properties;
    }

    public String getGroupId() {
        return this.mainArtifact.getGroupId();
    }

    public String getArtifactId() {
        return this.mainArtifact.getArtifactId();
    }

    public String getVersion() {
        return this.mainArtifact.getVersion();
    }

    public String getBaseVersion() {
        return this.mainArtifact.getBaseVersion();
    }

    public boolean isSnapshot() {
        return this.mainArtifact.isSnapshot();
    }

    public String getClassifier() {
        return SubArtifact.expand(this.classifier, this.mainArtifact.getClassifier());
    }

    public String getExtension() {
        return SubArtifact.expand(this.extension, this.mainArtifact.getExtension());
    }

    @Deprecated
    public File getFile() {
        return this.path != null ? this.path.toFile() : null;
    }

    public Path getPath() {
        return this.path;
    }

    @Deprecated
    public Artifact setFile(File file) {
        return this.setPath(file != null ? file.toPath() : null);
    }

    public Artifact setPath(Path path) {
        if (Objects.equals(this.path, path)) {
            return this;
        }
        return new SubArtifact(this.mainArtifact, this.classifier, this.extension, path, this.properties);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Artifact setProperties(Map<String, String> properties) {
        if (this.properties.equals(properties) || properties == null && this.properties.isEmpty()) {
            return this;
        }
        return new SubArtifact(this.mainArtifact, this.classifier, this.extension, properties, this.path);
    }

    private static String expand(String pattern, String replacement) {
        String result = "";
        if (pattern != null) {
            result = pattern.replace("*", replacement);
            if (replacement.isEmpty()) {
                char c;
                int i;
                if (pattern.startsWith("*")) {
                    for (i = 0; i < result.length() && ((c = result.charAt(i)) == '-' || c == '.'); ++i) {
                    }
                    result = result.substring(i);
                }
                if (pattern.endsWith("*")) {
                    for (i = result.length() - 1; i >= 0 && ((c = result.charAt(i)) == '-' || c == '.'); --i) {
                    }
                    result = result.substring(0, i + 1);
                }
            }
        }
        return result;
    }
}

