/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.visitor;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;

abstract class AbstractDependencyNodeConsumerVisitor
implements DependencyVisitor {
    protected final Consumer<DependencyNode> nodeConsumer;
    private final Map<DependencyNode, Object> visitedNodes;

    protected AbstractDependencyNodeConsumerVisitor(Consumer<DependencyNode> nodeConsumer) {
        this.nodeConsumer = Objects.requireNonNull(nodeConsumer);
        this.visitedNodes = new IdentityHashMap<DependencyNode, Object>(512);
    }

    protected boolean setVisited(DependencyNode node) {
        return this.visitedNodes.put(node, Boolean.TRUE) == null;
    }

    public abstract boolean visitEnter(DependencyNode var1);

    public abstract boolean visitLeave(DependencyNode var1);
}

