/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.Objects;
import java.util.Set;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.spi.artifact.ArtifactPredicate;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactorySelector;

public final class DefaultArtifactPredicate
implements ArtifactPredicate {
    private final ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector;
    private final Set<String> extensionsWithoutChecksums;

    public DefaultArtifactPredicate(ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector, Set<String> extensionsWithoutChecksums) {
        this.checksumAlgorithmFactorySelector = checksumAlgorithmFactorySelector;
        this.extensionsWithoutChecksums = extensionsWithoutChecksums;
    }

    public boolean isWithoutChecksum(Artifact artifact) {
        Objects.requireNonNull(artifact);
        String artifactExtension = artifact.getExtension();
        for (String extensionWithoutChecksums : this.extensionsWithoutChecksums) {
            if (!artifactExtension.endsWith(extensionWithoutChecksums)) continue;
            return true;
        }
        return false;
    }

    public boolean isChecksum(Artifact artifact) {
        Objects.requireNonNull(artifact);
        return this.checksumAlgorithmFactorySelector.isChecksumExtension(artifact.getExtension());
    }
}

