/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.model;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.api.MonotonicClock;

public class MavenBuildTimestamp {
    public static final String DEFAULT_BUILD_TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ssXXX";
    private final String formattedTimestamp;

    public MavenBuildTimestamp() {
        this(MonotonicClock.now());
    }

    public MavenBuildTimestamp(Instant time) {
        this(time, DEFAULT_BUILD_TIMESTAMP_FORMAT);
    }

    public MavenBuildTimestamp(Instant time, Map<String, String> properties) {
        this(time, properties != null ? properties.get("maven.build.timestamp.format") : null);
    }

    @Deprecated
    public MavenBuildTimestamp(Instant time, Properties properties) {
        this(time, properties != null ? properties.getProperty("maven.build.timestamp.format") : null);
    }

    public MavenBuildTimestamp(Instant time, String timestampFormat) {
        if (timestampFormat == null) {
            timestampFormat = DEFAULT_BUILD_TIMESTAMP_FORMAT;
        }
        if (time == null) {
            time = MonotonicClock.now();
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(timestampFormat).withZone(ZoneId.of("UTC"));
        this.formattedTimestamp = formatter.format(time);
    }

    public String formattedTimestamp() {
        return this.formattedTimestamp;
    }
}

