/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ActivationFile;
import org.apache.maven.api.model.ActivationOS;
import org.apache.maven.api.model.ActivationProperty;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Activation
implements Serializable,
InputLocationTracker {
    final boolean activeByDefault;
    final String jdk;
    final ActivationOS os;
    final ActivationProperty property;
    final ActivationFile file;
    final String packaging;
    final String condition;
    final Map<Object, InputLocation> locations;
    final InputLocation importedFrom;

    protected Activation(Builder builder) {
        boolean bl = builder.activeByDefault != null ? builder.activeByDefault : (this.activeByDefault = builder.base != null ? builder.base.activeByDefault : false);
        String string = builder.jdk != null ? builder.jdk : (this.jdk = builder.base != null ? builder.base.jdk : null);
        ActivationOS activationOS = builder.os != null ? builder.os : (this.os = builder.base != null ? builder.base.os : null);
        ActivationProperty activationProperty = builder.property != null ? builder.property : (this.property = builder.base != null ? builder.base.property : null);
        ActivationFile activationFile = builder.file != null ? builder.file : (this.file = builder.base != null ? builder.base.file : null);
        String string2 = builder.packaging != null ? builder.packaging : (this.packaging = builder.base != null ? builder.base.packaging : null);
        this.condition = builder.condition != null ? builder.condition : (builder.base != null ? builder.base.condition : null);
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    public boolean isActiveByDefault() {
        return this.activeByDefault;
    }

    public String getJdk() {
        return this.jdk;
    }

    public ActivationOS getOs() {
        return this.os;
    }

    public ActivationProperty getProperty() {
        return this.property;
    }

    public ActivationFile getFile() {
        return this.file;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getCondition() {
        return this.condition;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations.get(key);
    }

    public Set<Object> getLocationKeys() {
        return this.locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return this.locations.keySet().stream();
    }

    @Override
    public InputLocation getImportedFrom() {
        return this.importedFrom;
    }

    @Nonnull
    public Builder with() {
        return Activation.newBuilder(this);
    }

    @Nonnull
    public Activation withActiveByDefault(boolean activeByDefault) {
        return Activation.newBuilder(this, true).activeByDefault(activeByDefault).build();
    }

    @Nonnull
    public Activation withJdk(String jdk) {
        return Activation.newBuilder(this, true).jdk(jdk).build();
    }

    @Nonnull
    public Activation withOs(ActivationOS os) {
        return Activation.newBuilder(this, true).os(os).build();
    }

    @Nonnull
    public Activation withProperty(ActivationProperty property) {
        return Activation.newBuilder(this, true).property(property).build();
    }

    @Nonnull
    public Activation withFile(ActivationFile file) {
        return Activation.newBuilder(this, true).file(file).build();
    }

    @Nonnull
    public Activation withPackaging(String packaging) {
        return Activation.newBuilder(this, true).packaging(packaging).build();
    }

    @Nonnull
    public Activation withCondition(String condition) {
        return Activation.newBuilder(this, true).condition(condition).build();
    }

    @Nonnull
    public static Activation newInstance() {
        return Activation.newInstance(true);
    }

    @Nonnull
    public static Activation newInstance(boolean withDefaults) {
        return Activation.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Activation.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Activation from) {
        return Activation.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Activation from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        Activation base;
        Boolean activeByDefault;
        String jdk;
        ActivationOS os;
        ActivationProperty property;
        ActivationFile file;
        String packaging;
        String condition;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                this.activeByDefault = false;
            }
        }

        protected Builder(Activation base, boolean forceCopy) {
            if (forceCopy) {
                this.activeByDefault = base.activeByDefault;
                this.jdk = base.jdk;
                this.os = base.os;
                this.property = base.property;
                this.file = base.file;
                this.packaging = base.packaging;
                this.condition = base.condition;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder activeByDefault(boolean activeByDefault) {
            this.activeByDefault = activeByDefault;
            return this;
        }

        @Nonnull
        public Builder jdk(String jdk) {
            this.jdk = jdk;
            return this;
        }

        @Nonnull
        public Builder os(ActivationOS os) {
            this.os = os;
            return this;
        }

        @Nonnull
        public Builder property(ActivationProperty property) {
            this.property = property;
            return this;
        }

        @Nonnull
        public Builder file(ActivationFile file) {
            this.file = file;
            return this;
        }

        @Nonnull
        public Builder packaging(String packaging) {
            this.packaging = packaging;
            return this;
        }

        @Nonnull
        public Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public Activation build() {
            if (!(this.base == null || this.activeByDefault != null && this.activeByDefault != this.base.activeByDefault || this.jdk != null && this.jdk != this.base.jdk || this.os != null && this.os != this.base.os || this.property != null && this.property != this.base.property || this.file != null && this.file != this.base.file || this.packaging != null && this.packaging != this.base.packaging || this.condition != null && this.condition != this.base.condition)) {
                return this.base;
            }
            return new Activation(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map oldlocs;
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Map.of();
            Map<Object, Object> map = oldlocs = this.base != null ? this.base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }
}

