/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.nio.file.Path;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.LocalRepositoryManager;
import org.apache.maven.impl.InternalSession;
import org.eclipse.aether.repository.LocalRepository;

@Named
@Singleton
public class DefaultLocalRepositoryManager
implements LocalRepositoryManager {
    @Nonnull
    public Path getPathForLocalArtifact(@Nonnull Session session, @Nonnull org.apache.maven.api.LocalRepository local, @Nonnull Artifact artifact) {
        InternalSession s = InternalSession.from(session);
        return this.getManager(s, local).getAbsolutePathForLocalArtifact(s.toArtifact(artifact));
    }

    @Nonnull
    public Path getPathForRemoteArtifact(@Nonnull Session session, @Nonnull org.apache.maven.api.LocalRepository local, @Nonnull RemoteRepository remote, @Nonnull Artifact artifact) {
        InternalSession s = InternalSession.from(session);
        return this.getManager(s, local).getAbsolutePathForRemoteArtifact(s.toArtifact(artifact), s.toRepository(remote), null);
    }

    private org.eclipse.aether.repository.LocalRepositoryManager getManager(InternalSession session, org.apache.maven.api.LocalRepository local) {
        LocalRepository repository = session.toRepository(local);
        if ("enhanced".equals(repository.getContentType())) {
            repository = new LocalRepository(repository.getBasePath(), "");
        }
        return session.getRepositorySystem().newLocalRepositoryManager(session.getSession(), repository);
    }
}

