/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.execution;

import java.time.Duration;
import java.util.Objects;
import org.apache.maven.project.MavenProject;

public abstract class BuildSummary {
    private final MavenProject project;
    private final Duration wallTime;
    private final Duration execTime;

    protected BuildSummary(MavenProject project, long time) {
        this(project, Duration.ofMillis(time), Duration.ofMillis(time));
    }

    protected BuildSummary(MavenProject project, Duration execTime, Duration wallTime) {
        this.project = Objects.requireNonNull(project, "project cannot be null");
        this.execTime = execTime;
        this.wallTime = wallTime;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public long getTime() {
        return this.execTime.toMillis();
    }

    public Duration getWallTime() {
        return this.wallTime;
    }

    public Duration getExecTime() {
        return this.execTime;
    }
}

