/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.cli.server.helper;

import java.io.IOException;
import org.apache.sshd.cli.server.helper.ServerEventListenerHelper;
import org.apache.sshd.common.forward.PortForwardingEventListener;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.slf4j.Logger;

public class ServerPortForwardingEventListener
extends ServerEventListenerHelper
implements PortForwardingEventListener {
    public ServerPortForwardingEventListener(Logger logger) {
        super("PORT-FWD", logger);
    }

    public void establishedExplicitTunnel(Session session, SshdSocketAddress local, SshdSocketAddress remote, boolean localForwarding, SshdSocketAddress boundAddress, Throwable reason) throws IOException {
        if (reason == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Estalibshed explicit tunnel for session={}: local={}, remote={}, bound={}, localForward={}", new Object[]{session, local, remote, boundAddress, localForwarding});
            }
        } else {
            this.log.error("Failed ({}) to establish explicit tunnel for session={}, local={}, remote={}, bound={}, localForward={}: {}", new Object[]{reason.getClass().getSimpleName(), session, local, remote, boundAddress, localForwarding, reason.getMessage()});
        }
    }

    public void tornDownExplicitTunnel(Session session, SshdSocketAddress address, boolean localForwarding, SshdSocketAddress remoteAddress, Throwable reason) throws IOException {
        if (reason == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Torn down explicit tunnel for session={}: address={}, remote={}, localForward={}", new Object[]{session, address, remoteAddress, localForwarding});
            }
        } else {
            this.log.error("Failed ({}) to tear down explicit tunnel for session={}, address={}, remote={}, localForward={}: {}", new Object[]{reason.getClass().getSimpleName(), session, address, remoteAddress, localForwarding, reason.getMessage()});
        }
    }

    public void establishedDynamicTunnel(Session session, SshdSocketAddress local, SshdSocketAddress boundAddress, Throwable reason) throws IOException {
        if (reason == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Estalibshed dynamic tunnel for session={}: local={} bound={}", new Object[]{session, local, boundAddress});
            }
        } else {
            this.log.error("Failed ({}) to establish dynamic tunnel for session={}: local={} bound={}: {}", new Object[]{reason.getClass().getSimpleName(), session, local, boundAddress, reason.getMessage()});
        }
    }

    public void tornDownDynamicTunnel(Session session, SshdSocketAddress address, Throwable reason) throws IOException {
        if (reason == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Torn down dynamic tunnel for session={}: address={}", (Object)session, (Object)address);
            }
        } else {
            this.log.error("Failed ({}) to tear down dynamic tunnel for session={}, address={}: {}", new Object[]{reason.getClass().getSimpleName(), session, address, reason.getMessage()});
        }
    }
}

