/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DuplexChannel;
import io.netty.util.Attribute;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.common.future.CancelFuture;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.io.AbstractIoWriteFuture;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.helpers.MissingAttachedSessionException;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.netty.NettyIoService;
import org.apache.sshd.netty.NettySupport;

public class NettyIoSession
extends AbstractCloseable
implements IoSession {
    protected final Map<Object, Object> attributes = new HashMap<Object, Object>();
    protected final NettyIoService service;
    protected final IoHandler handler;
    protected final long id;
    protected volatile ChannelHandlerContext context;
    protected SocketAddress remoteAddr;
    protected ChannelFuture prev;
    protected final ChannelInboundHandlerAdapter adapter = new Adapter();
    protected final AtomicBoolean readSuspended = new AtomicBoolean();
    private final SocketAddress acceptanceAddress;

    public NettyIoSession(NettyIoService service, IoHandler handler, SocketAddress acceptanceAddress) {
        super(Objects.toString(acceptanceAddress, ""));
        this.service = service;
        this.handler = handler;
        this.id = service.sessionSeq.incrementAndGet();
        this.acceptanceAddress = acceptanceAddress;
    }

    public long getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(Object key) {
        Map<Object, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setAttribute(Object key, Object value) {
        Map<Object, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setAttributeIfAbsent(Object key, Object value) {
        Map<Object, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.putIfAbsent(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeAttribute(Object key) {
        Map<Object, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.remove(key);
        }
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddr;
    }

    public SocketAddress getLocalAddress() {
        Channel channel = this.context == null ? null : this.context.channel();
        return channel == null ? null : channel.localAddress();
    }

    public SocketAddress getAcceptanceAddress() {
        return this.acceptanceAddress;
    }

    public IoWriteFuture writeBuffer(Buffer buffer) {
        int bufLen = buffer.available();
        ByteBuf buf = Unpooled.buffer((int)bufLen);
        buf.writeBytes(buffer.array(), buffer.rpos(), bufLen);
        DefaultIoWriteFuture msg = new DefaultIoWriteFuture(this.getRemoteAddress(), null);
        ChannelHandlerContext ctx = this.context;
        if (ctx == null) {
            msg.setValue(new ClosedChannelException());
            return msg;
        }
        ChannelPromise next = ctx.newPromise();
        this.prev.addListener(whatever -> {
            ChannelHandlerContext c = this.context;
            if (c != null) {
                c.writeAndFlush((Object)buf, next);
            } else {
                msg.setValue(new ClosedChannelException());
                next.cancel(true);
            }
        });
        this.prev = next;
        next.addListener(fut -> {
            if (fut.isSuccess()) {
                msg.setValue(Boolean.TRUE);
            } else {
                msg.setValue(fut.cause());
            }
        });
        return msg;
    }

    public IoService getService() {
        return this.service;
    }

    public void suspendRead() {
        ChannelHandlerContext ctx;
        if (!this.readSuspended.getAndSet(true) && (ctx = this.context) != null) {
            Channel ch = ctx.channel();
            ch.config().setAutoRead(false);
        }
    }

    public void resumeRead() {
        ChannelHandlerContext ctx;
        if (this.readSuspended.getAndSet(false) && (ctx = this.context) != null) {
            Channel ch = ctx.channel();
            ch.config().setAutoRead(true);
        }
    }

    public void shutdownOutputStream() throws IOException {
        ChannelHandlerContext ctx = this.context;
        if (ctx == null) {
            return;
        }
        Channel ch = ctx.channel();
        if (ch instanceof DuplexChannel) {
            ((DuplexChannel)ch).shutdownOutput();
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("shutdownOutputStream({}) channel is not DuplexChannel: {}", (Object)this, ch == null ? null : ch.getClass().getSimpleName());
        }
    }

    public void suspend() {
        Channel ch;
        ChannelHandlerContext ctx = this.context;
        if (ctx != null && (ch = ctx.channel()) != null) {
            ch.disconnect();
        }
    }

    protected CloseFuture doCloseGracefully() {
        ChannelHandlerContext ctx = this.context;
        if (ctx != null) {
            ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE).addListener(fut -> this.closeFuture.setClosed());
        } else {
            this.closeFuture.setClosed();
        }
        return this.closeFuture;
    }

    protected void doCloseImmediately() {
        ChannelHandlerContext ctx = this.context;
        if (ctx != null) {
            ctx.close();
        }
        super.doCloseImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.context = ctx;
        Channel channel = ctx.channel();
        this.prev = this.context.newPromise().setSuccess();
        this.remoteAddr = channel.remoteAddress();
        Attribute connectFuture = channel.attr(NettyIoService.CONNECT_FUTURE_KEY);
        IoConnectFuture future = (IoConnectFuture)connectFuture.get();
        try {
            this.service.registerChannel(channel);
            this.handler.sessionCreated((IoSession)this);
            this.service.mapSession(this);
            if (future != null) {
                future.setSession((IoSession)this);
                if (future.getSession() != this) {
                    this.close(true);
                }
            }
        }
        catch (Throwable e) {
            this.warn("channelActive(session={}): could not create SSH session ({}); closing", (Object)this, e.getClass().getName(), e);
            try {
                if (future != null) {
                    future.setException(e);
                }
            }
            finally {
                this.close(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.service.sessions.remove(this.id);
        try {
            this.handler.sessionClosed((IoSession)this);
        }
        catch (MissingAttachedSessionException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("channelInactive(session={}): caught {}", new Object[]{this, ((Object)((Object)e)).getClass().getName(), e});
            }
        }
        finally {
            CancelFuture cancellation;
            Channel channel = ctx.channel();
            Attribute connectFuture = channel.attr(NettyIoService.CONNECT_FUTURE_KEY);
            IoConnectFuture future = (IoConnectFuture)connectFuture.get();
            if (future != null && (cancellation = future.cancel()) != null) {
                cancellation.setCanceled();
            }
            this.context = null;
        }
    }

    protected void channelRead(ChannelHandlerContext ctx, Readable msg) throws Exception {
        this.handler.messageReceived((IoSession)this, msg);
    }

    protected void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.handler.exceptionCaught((IoSession)this, cause);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[local=" + this.getLocalAddress() + ", remote=" + this.getRemoteAddress() + "]";
    }

    protected class Adapter
    extends ChannelInboundHandlerAdapter {
        private ByteArrayBuffer buffer;
        private ByteBuf ioBuffer;

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            NettyIoSession.this.channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.buffer = null;
            if (this.ioBuffer != null) {
                this.ioBuffer.release();
                this.ioBuffer = null;
            }
            NettyIoSession.this.channelInactive(ctx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            ByteBuf buf = (ByteBuf)msg;
            if (this.buffer == null) {
                if (this.ioBuffer == null) {
                    this.ioBuffer = buf;
                    return;
                }
                try {
                    this.buffer = new ByteArrayBuffer(this.ioBuffer.readableBytes() + buf.readableBytes(), false);
                    this.buffer.putBuffer(NettySupport.asReadable(this.ioBuffer), false);
                    this.buffer.putBuffer(NettySupport.asReadable(buf), false);
                }
                finally {
                    this.ioBuffer.release();
                    this.ioBuffer = null;
                    buf.release();
                }
            }
            try {
                this.buffer.putBuffer(NettySupport.asReadable(buf), true);
            }
            finally {
                buf.release();
            }
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            if (this.buffer != null) {
                ByteArrayBuffer buf = this.buffer;
                this.buffer = null;
                NettyIoSession.this.channelRead(ctx, (Readable)buf);
            } else if (this.ioBuffer != null) {
                ByteBuf buf = this.ioBuffer;
                this.ioBuffer = null;
                try {
                    NettyIoSession.this.channelRead(ctx, NettySupport.asReadable(buf));
                }
                finally {
                    buf.release();
                }
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            NettyIoSession.this.exceptionCaught(ctx, cause);
        }
    }

    protected static class DefaultIoWriteFuture
    extends AbstractIoWriteFuture {
        public DefaultIoWriteFuture(Object id, Object lock) {
            super(id, lock);
        }
    }
}

