/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.element.NavigationCase;
import org.apache.myfaces.config.element.NavigationRule;
import org.apache.myfaces.portlet.PortletUtil;
import org.apache.myfaces.shared_impl.util.HashMapUtils;

public class NavigationHandlerImpl
extends NavigationHandler {
    private static final Log log = LogFactory.getLog((Class)NavigationHandlerImpl.class);
    private static final String PARTIAL_STATE_SAVING_METHOD_PARAM_NAME = "javax.faces.PARTIAL_STATE_SAVING_METHOD";
    private static final String PARTIAL_STATE_SAVING_METHOD_ON = "true";
    private static final String PARTIAL_STATE_SAVING_METHOD_OFF = "false";
    private static final String ASTERISK = "*";
    private Boolean _partialStateSaving = null;
    private Map _navigationCases = null;
    private List _wildcardKeys = new ArrayList();

    private boolean isPartialStateSavingOn(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (this._partialStateSaving != null) {
            return this._partialStateSaving;
        }
        String stateSavingMethod = context.getExternalContext().getInitParameter(PARTIAL_STATE_SAVING_METHOD_PARAM_NAME);
        if (stateSavingMethod == null) {
            this._partialStateSaving = Boolean.FALSE;
            context.getExternalContext().log("No context init parameter 'javax.faces.PARTIAL_STATE_SAVING_METHOD' found; no partial state saving method defined, assuming default partial state saving method off.");
        } else if (stateSavingMethod.equals(PARTIAL_STATE_SAVING_METHOD_ON)) {
            this._partialStateSaving = Boolean.TRUE;
        } else if (stateSavingMethod.equals(PARTIAL_STATE_SAVING_METHOD_OFF)) {
            this._partialStateSaving = Boolean.FALSE;
        } else {
            this._partialStateSaving = Boolean.FALSE;
            context.getExternalContext().log("Illegal partial state saving method '" + stateSavingMethod + "', default partial state saving will be used (partial state saving off).");
        }
        return this._partialStateSaving;
    }

    public NavigationHandlerImpl() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"New NavigationHandler instance created");
        }
    }

    public void handleNavigation(FacesContext facesContext, String fromAction, String outcome) {
        if (outcome == null) {
            return;
        }
        NavigationCase navigationCase = this.getNavigationCase(facesContext, fromAction, outcome);
        if (navigationCase != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("handleNavigation fromAction=" + fromAction + " outcome=" + outcome + " toViewId =" + navigationCase.getToViewId() + " redirect=" + navigationCase.isRedirect()));
            }
            if (navigationCase.isRedirect() && !PortletUtil.isPortletRequest(facesContext)) {
                ExternalContext externalContext = facesContext.getExternalContext();
                ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
                String redirectPath = viewHandler.getActionURL(facesContext, navigationCase.getToViewId());
                try {
                    externalContext.redirect(externalContext.encodeActionURL(redirectPath));
                }
                catch (IOException e) {
                    throw new FacesException(e.getMessage(), (Throwable)e);
                }
            } else {
                ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
                String newViewId = navigationCase.getToViewId();
                UIViewRoot viewRoot = null;
                viewRoot = this.isPartialStateSavingOn(facesContext) ? viewHandler.restoreView(facesContext, newViewId) : viewHandler.createView(facesContext, newViewId);
                facesContext.setViewRoot(viewRoot);
                facesContext.renderResponse();
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("handleNavigation fromAction=" + fromAction + " outcome=" + outcome + " no matching navigation-case found, staying on current ViewRoot"));
        }
    }

    public NavigationCase getNavigationCase(FacesContext facesContext, String fromAction, String outcome) {
        String viewId = facesContext.getViewRoot().getViewId();
        Map casesMap = this.getNavigationCases(facesContext);
        NavigationCase navigationCase = null;
        List casesList = (List)casesMap.get(viewId);
        if (casesList != null) {
            navigationCase = this.calcMatchingNavigationCase(casesList, fromAction, outcome);
        }
        if (navigationCase == null) {
            List keys = this.getSortedWildcardKeys();
            int size = keys.size();
            for (int i = 0; i < size; ++i) {
                String fromViewId = (String)keys.get(i);
                if (fromViewId.length() > 2) {
                    String prefix = fromViewId.substring(0, fromViewId.length() - 1);
                    if (viewId == null || !viewId.startsWith(prefix) || (casesList = (List)casesMap.get(fromViewId)) == null || (navigationCase = this.calcMatchingNavigationCase(casesList, fromAction, outcome)) == null) continue;
                    break;
                }
                casesList = (List)casesMap.get(fromViewId);
                if (casesList != null && (navigationCase = this.calcMatchingNavigationCase(casesList, fromAction, outcome)) != null) break;
            }
        }
        return navigationCase;
    }

    public String getViewId(FacesContext context, String fromAction, String outcome) {
        return this.getNavigationCase(context, fromAction, outcome).getToViewId();
    }

    public String beforeNavigation(String viewId) {
        return null;
    }

    private NavigationCase calcMatchingNavigationCase(List casesList, String actionRef, String outcome) {
        int size = casesList.size();
        for (int i = 0; i < size; ++i) {
            NavigationCase caze = (NavigationCase)casesList.get(i);
            String cazeOutcome = caze.getFromOutcome();
            String cazeActionRef = caze.getFromAction();
            if (cazeOutcome != null && !cazeOutcome.equals(outcome) || cazeActionRef != null && !cazeActionRef.equals(actionRef)) continue;
            return caze;
        }
        return null;
    }

    private List getSortedWildcardKeys() {
        return this._wildcardKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getNavigationCases(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(externalContext);
        if (this._navigationCases == null || runtimeConfig.isNavigationRulesChanged()) {
            NavigationHandlerImpl navigationHandlerImpl = this;
            synchronized (navigationHandlerImpl) {
                if (this._navigationCases == null || runtimeConfig.isNavigationRulesChanged()) {
                    Collection rules = runtimeConfig.getNavigationRules();
                    int rulesSize = rules.size();
                    HashMap cases = new HashMap(HashMapUtils.calcCapacity(rulesSize));
                    ArrayList<String> wildcardKeys = new ArrayList<String>();
                    Iterator iterator = rules.iterator();
                    while (iterator.hasNext()) {
                        NavigationRule rule = (NavigationRule)iterator.next();
                        String fromViewId = rule.getFromViewId();
                        fromViewId = fromViewId == null ? ASTERISK : fromViewId.trim();
                        ArrayList list = (ArrayList)cases.get(fromViewId);
                        if (list == null) {
                            list = new ArrayList(rule.getNavigationCases());
                            cases.put(fromViewId, list);
                            if (!fromViewId.endsWith(ASTERISK)) continue;
                            wildcardKeys.add(fromViewId);
                            continue;
                        }
                        list.addAll(rule.getNavigationCases());
                    }
                    Collections.sort(wildcardKeys, new KeyComparator());
                    HashMap hashMap = cases;
                    synchronized (hashMap) {
                        this._navigationCases = cases;
                        this._wildcardKeys = wildcardKeys;
                        runtimeConfig.setNavigationRulesChanged(false);
                    }
                }
            }
        }
        return this._navigationCases;
    }

    private static final class KeyComparator
    implements Comparator {
        private KeyComparator() {
        }

        public int compare(Object o1, Object o2) {
            return -((String)o1).compareTo((String)o2);
        }
    }
}

