/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import javax.faces.FacesException;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;

abstract class _MethodBindingToListener
implements StateHolder {
    protected MethodBinding methodBinding;

    public _MethodBindingToListener() {
    }

    public _MethodBindingToListener(MethodBinding methodBinding) {
        if (methodBinding == null) {
            throw new NullPointerException("methodBinding can not be null");
        }
        if (!(methodBinding instanceof StateHolder)) {
            throw new IllegalArgumentException("methodBinding must implement the StateHolder interface");
        }
        this.methodBinding = methodBinding;
    }

    private FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    protected void invokeMethodBinding(FacesEvent event) throws AbortProcessingException {
        try {
            this.methodBinding.invoke(this.getFacesContext(), new Object[]{event});
        }
        catch (EvaluationException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof AbortProcessingException) {
                throw (AbortProcessingException)cause;
            }
            throw e;
        }
    }

    public MethodBinding getMethodBinding() {
        return this.methodBinding;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] stateArray = (Object[])state;
        try {
            this.methodBinding = (MethodBinding)Thread.currentThread().getContextClassLoader().loadClass((String)stateArray[0]).newInstance();
        }
        catch (Exception e) {
            throw new FacesException(e);
        }
        ((StateHolder)((Object)this.methodBinding)).restoreState(context, stateArray[1]);
    }

    public Object saveState(FacesContext context) {
        Object[] stateArray = new Object[]{this.methodBinding.getClass().getName(), ((StateHolder)((Object)this.methodBinding)).saveState(context)};
        return stateArray;
    }

    public void setTransient(boolean newTransientValue) {
        ((StateHolder)((Object)this.methodBinding)).setTransient(newTransientValue);
    }

    public boolean isTransient() {
        return ((StateHolder)((Object)this.methodBinding)).isTransient();
    }
}

