/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import org.apache.myfaces.shared.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LogMetaInfUtils {
    private static final Logger log = Logger.getLogger(LogMetaInfUtils.class.getName());
    public static final String REGEX_LIBRARY = "(jar|besjar|wsjar|zip):(file:.*/((myfaces|tomahawk|trinidad|tobago|commons\\-el|jsp\\-api)[\\w\\-\\_]+?)-(\\d+.*)\\.jar)!/META-INF/MANIFEST.MF";
    private static final Pattern REGEX_LIBRARY_PATTERN = Pattern.compile("(jar|besjar|wsjar|zip):(file:.*/((myfaces|tomahawk|trinidad|tobago|commons\\-el|jsp\\-api)[\\w\\-\\_]+?)-(\\d+.*)\\.jar)!/META-INF/MANIFEST.MF");
    private static final int REGEX_LIBRARY_FILE_PATH = 2;
    private static final int REGEX_LIBRARY_ARTIFACT_ID = 3;
    private static final int REGEX_LIBRARY_VERSION = 5;

    LogMetaInfUtils() {
    }

    protected static void logMetaInf() {
        if (!log.isLoggable(Level.WARNING)) {
            return;
        }
        try {
            HashMap<String, List<JarInfo>> libs = new HashMap<String, List<JarInfo>>(30);
            Iterator it = ClassUtils.getResources("META-INF/MANIFEST.MF", LogMetaInfUtils.class);
            while (it.hasNext()) {
                URL url = (URL)it.next();
                LogMetaInfUtils.addJarInfo(libs, url);
            }
            ArrayList keys = new ArrayList(libs.keySet());
            Collections.sort(keys);
            if (log.isLoggable(Level.WARNING)) {
                for (String artifactId : keys) {
                    List versions = (List)libs.get(artifactId);
                    if (versions == null || versions.size() <= 1) continue;
                    StringBuilder builder = new StringBuilder(1024);
                    builder.append("You are using the library: ");
                    builder.append(artifactId);
                    builder.append(" in different versions; first (and probably used) version is: ");
                    builder.append(((JarInfo)versions.get(0)).getVersion());
                    builder.append(" loaded from: ");
                    builder.append(((JarInfo)versions.get(0)).getUrl());
                    builder.append(", but also found the following versions: ");
                    boolean needComma = false;
                    for (int i = 1; i < versions.size(); ++i) {
                        JarInfo info = (JarInfo)versions.get(i);
                        if (needComma) {
                            builder.append(", ");
                        }
                        builder.append(info.getVersion());
                        builder.append(" loaded from: ");
                        builder.append(info.getUrl());
                        needComma = true;
                    }
                    log.warning(builder.toString());
                }
            }
            if (log.isLoggable(Level.INFO)) {
                for (String artifactId : keys) {
                    LogMetaInfUtils.logArtifact(artifactId, libs);
                }
            }
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
    }

    protected static void addJarInfo(Map<String, List<JarInfo>> libs, URL url) {
        Matcher matcher = REGEX_LIBRARY_PATTERN.matcher(url.toString());
        if (matcher.matches()) {
            String version;
            String path;
            JarInfo newInfo;
            String artifactId = matcher.group(3);
            List<JarInfo> versions = libs.get(artifactId);
            if (versions == null) {
                versions = new ArrayList<JarInfo>(1);
                libs.put(artifactId, versions);
            }
            if (!versions.contains(newInfo = new JarInfo(path = matcher.group(2), version = matcher.group(5)))) {
                versions.add(newInfo);
            }
        }
    }

    private static void logArtifact(String artifactId, Map<String, List<JarInfo>> libs) {
        List<JarInfo> versions = libs.get(artifactId);
        if (versions == null) {
            log.info("Artifact '" + artifactId + "' was not found.");
        } else {
            JarInfo info = versions.get(0);
            log.info("Artifact '" + artifactId + "' was found in version '" + info.getVersion() + "' from path '" + info.getUrl() + "'");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class JarInfo
    implements Comparable<JarInfo> {
        private String url;
        private String version;

        public JarInfo(String url, String version) {
            this.url = url;
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }

        public String getUrl() {
            return this.url;
        }

        @Override
        public int compareTo(JarInfo info) {
            return this.version.compareTo(info.version);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof JarInfo) {
                JarInfo other = (JarInfo)o;
                return this.version.equals(other.version);
            }
            return false;
        }

        public int hashCode() {
            return this.version.hashCode();
        }
    }
}

