/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.UIViewRoot;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.ValueBinding;
import javax.faces.event.PhaseId;
import javax.faces.model.SelectItem;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.ResponseStateManager;
import org.apache.myfaces.shared.renderkit._SharedRendererUtils;
import org.apache.myfaces.shared.renderkit.html.util.FormInfo;
import org.apache.myfaces.shared.util.HashMapUtils;
import org.apache.myfaces.shared.util.SelectItemsIterator;

public final class RendererUtils {
    private static final Logger log = Logger.getLogger(RendererUtils.class.getName());
    public static final String SELECT_ITEM_LIST_ATTR = RendererUtils.class.getName() + ".LIST";
    public static final String EMPTY_STRING = "";
    public static final Object NOTHING = new Serializable(){

        public boolean equals(Object o) {
            return o != null && o.getClass().equals(this.getClass());
        }

        public int hashCode() {
            return super.hashCode();
        }
    };
    public static final String ACTION_FOR_LIST = "org.apache.myfaces.ActionForList";
    public static final String ACTION_FOR_PHASE_LIST = "org.apache.myfaces.ActionForPhaseList";
    public static final String SEQUENCE_PARAM = "jsf_sequence";
    private static final String RENDER_KIT_IMPL = RendererUtils.class.getName() + ".RenderKitImpl";
    public static final String RES_NOT_FOUND = "RES_NOT_FOUND";
    private static final String TRINIDAD_FORM_COMPONENT_FAMILY = "org.apache.myfaces.trinidad.Form";
    private static final String ADF_FORM_COMPONENT_FAMILY = "oracle.adf.Form";

    private RendererUtils() {
    }

    public static String getPathToComponent(UIComponent component) {
        StringBuilder buf = new StringBuilder();
        if (component == null) {
            buf.append("{Component-Path : ");
            buf.append("[null]}");
            return buf.toString();
        }
        RendererUtils.getPathToComponent(component, buf);
        buf.insert(0, "{Component-Path : ");
        Object location = component.getAttributes().get("javax.faces.component.VIEW_LOCATION_KEY");
        if (location != null) {
            buf.append(" Location: ").append(location);
        }
        buf.append("}");
        return buf.toString();
    }

    private static void getPathToComponent(UIComponent component, StringBuilder buf) {
        if (component == null) {
            return;
        }
        StringBuilder intBuf = new StringBuilder();
        intBuf.append("[Class: ");
        intBuf.append(component.getClass().getName());
        if (component instanceof UIViewRoot) {
            intBuf.append(",ViewId: ");
            intBuf.append(((UIViewRoot)component).getViewId());
        } else {
            intBuf.append(",Id: ");
            intBuf.append(component.getId());
        }
        intBuf.append("]");
        buf.insert(0, intBuf.toString());
        RendererUtils.getPathToComponent(component.getParent(), buf);
    }

    public static String getConcatenatedId(FacesContext context, UIComponent container, String clientId) {
        UIComponent child = container.findComponent(clientId);
        if (child == null) {
            return clientId;
        }
        return RendererUtils.getConcatenatedId(context, child);
    }

    public static String getConcatenatedId(FacesContext context, UIComponent component) {
        UIComponent parent;
        if (context == null) {
            throw new NullPointerException("context");
        }
        StringBuilder idBuf = new StringBuilder();
        idBuf.append(component.getId());
        while ((parent = component.getParent()) != null) {
            if (!(parent instanceof NamingContainer)) continue;
            idBuf.insert(0, UINamingContainer.getSeparatorChar(context));
            idBuf.insert(0, parent.getId());
        }
        return idBuf.toString();
    }

    public static Boolean getBooleanValue(UIComponent component) {
        Object value = RendererUtils.getObjectValue(component);
        if (value instanceof String) {
            value = Boolean.valueOf((String)value);
        }
        if (value == null || value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new IllegalArgumentException("Expected submitted value of type Boolean for Component : " + RendererUtils.getPathToComponent(component));
    }

    public static Date getDateValue(UIComponent component) {
        Object value = RendererUtils.getObjectValue(component);
        if (value == null || value instanceof Date) {
            return (Date)value;
        }
        throw new IllegalArgumentException("Expected submitted value of type Date for component : " + RendererUtils.getPathToComponent(component));
    }

    public static Object getObjectValue(UIComponent component) {
        Object value;
        if (!(component instanceof ValueHolder)) {
            throw new IllegalArgumentException("Component : " + RendererUtils.getPathToComponent(component) + "is not a ValueHolder");
        }
        if (component instanceof EditableValueHolder && (value = ((EditableValueHolder)((Object)component)).getSubmittedValue()) != null) {
            return value;
        }
        return ((ValueHolder)((Object)component)).getValue();
    }

    @Deprecated
    public static String getStringValue(FacesContext context, ValueBinding vb) {
        Object value = vb.getValue(context);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public static String getStringValue(FacesContext context, ValueExpression ve) {
        Object value = ve.getValue(context.getELContext());
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public static String getStringValue(FacesContext facesContext, UIComponent component) {
        EditableValueHolder holder;
        Object submittedValue;
        if (!(component instanceof ValueHolder)) {
            throw new IllegalArgumentException("Component : " + RendererUtils.getPathToComponent(component) + "is not a ValueHolder");
        }
        if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)((Object)component)).getSubmittedValue()) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("returning 1 '" + submittedValue + "'");
            }
            return submittedValue.toString();
        }
        Object value = component instanceof EditableValueHolder ? ((holder = (EditableValueHolder)((Object)component)).isLocalValueSet() ? holder.getLocalValue() : RendererUtils.getValue(component)) : RendererUtils.getValue(component);
        Converter converter = ((ValueHolder)((Object)component)).getConverter();
        if (converter == null && value != null) {
            try {
                converter = facesContext.getApplication().createConverter(value.getClass());
                if (log.isLoggable(Level.FINE)) {
                    log.fine("the created converter is " + converter);
                }
            }
            catch (FacesException e) {
                log.log(Level.SEVERE, "No converter for class " + value.getClass().getName() + " found (component id=" + component.getId() + ").", e);
            }
        }
        if (converter == null) {
            if (value == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("returning an empty string");
                }
                return EMPTY_STRING;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("returning an .toString");
            }
            return value.toString();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("returning converter get as string " + converter);
        }
        return converter.getAsString(facesContext, component, value);
    }

    public static String getStringFromSubmittedValueOrLocalValueReturnNull(FacesContext facesContext, UIComponent component) {
        try {
            EditableValueHolder holder;
            Object submittedValue;
            if (!(component instanceof ValueHolder)) {
                throw new IllegalArgumentException("Component : " + RendererUtils.getPathToComponent(component) + "is not a ValueHolder");
            }
            if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)((Object)component)).getSubmittedValue()) != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("returning 1 '" + submittedValue + "'");
                }
                return submittedValue.toString();
            }
            Object value = component instanceof EditableValueHolder ? ((holder = (EditableValueHolder)((Object)component)).isLocalValueSet() ? holder.getLocalValue() : RendererUtils.getValue(component)) : RendererUtils.getValue(component);
            Converter converter = ((ValueHolder)((Object)component)).getConverter();
            if (converter == null && value != null) {
                try {
                    converter = facesContext.getApplication().createConverter(value.getClass());
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("the created converter is " + converter);
                    }
                }
                catch (FacesException e) {
                    log.log(Level.SEVERE, "No converter for class " + value.getClass().getName() + " found (component id=" + component.getId() + ").", e);
                }
            }
            if (converter == null) {
                if (value == null) {
                    return null;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("returning an .toString");
                }
                return value.toString();
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("returning converter get as string " + converter);
            }
            return converter.getAsString(facesContext, component, value);
        }
        catch (PropertyNotFoundException ex) {
            log.log(Level.SEVERE, "Property not found - called by component : " + RendererUtils.getPathToComponent(component), ex);
            throw ex;
        }
    }

    private static Object getValue(UIComponent component) {
        Object value = ((ValueHolder)((Object)component)).getValue();
        return value;
    }

    public static boolean isDefaultAttributeValue(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                return ((Number)value).intValue() == Integer.MIN_VALUE;
            }
            if (value instanceof Double) {
                return ((Number)value).doubleValue() == Double.MIN_VALUE;
            }
            if (value instanceof Long) {
                return ((Number)value).longValue() == Long.MIN_VALUE;
            }
            if (value instanceof Byte) {
                return ((Number)value).byteValue() == -128;
            }
            if (value instanceof Float) {
                return ((Number)value).floatValue() == Float.MIN_VALUE;
            }
            if (value instanceof Short) {
                return ((Number)value).shortValue() == Short.MIN_VALUE;
            }
        }
        return false;
    }

    public static Converter findUIOutputConverter(FacesContext facesContext, UIOutput component) throws FacesException {
        return _SharedRendererUtils.findUIOutputConverter(facesContext, component);
    }

    public static Converter findUISelectManyConverter(FacesContext facesContext, UISelectMany component) {
        return RendererUtils.findUISelectManyConverter(facesContext, component, false);
    }

    public static Converter findUISelectManyConverter(FacesContext facesContext, UISelectMany component, boolean considerValueType) {
        Converter converter = component.getConverter();
        if (converter != null) {
            return converter;
        }
        if (considerValueType && (converter = _SharedRendererUtils.getValueTypeConverter(facesContext, component)) != null) {
            return converter;
        }
        ValueExpression ve = component.getValueExpression("value");
        if (ve == null) {
            return null;
        }
        Class valueType = null;
        Object value = ve.getValue(facesContext.getELContext());
        Class clazz = valueType = value != null ? value.getClass() : ve.getType(facesContext.getELContext());
        if (valueType == null) {
            return null;
        }
        if (Collection.class.isAssignableFrom(valueType) || Object.class.equals((Object)valueType)) {
            return _SharedRendererUtils.getSelectItemsValueConverter(new SelectItemsIterator(component, facesContext), facesContext);
        }
        if (!valueType.isArray()) {
            throw new IllegalArgumentException("ValueExpression for UISelectMany : " + RendererUtils.getPathToComponent(component) + " must be of type Collection or Array");
        }
        Class<?> arrayComponentType = valueType.getComponentType();
        if (String.class.equals(arrayComponentType)) {
            return null;
        }
        if (Object.class.equals(arrayComponentType)) {
            return _SharedRendererUtils.getSelectItemsValueConverter(new SelectItemsIterator(component, facesContext), facesContext);
        }
        try {
            return facesContext.getApplication().createConverter(arrayComponentType);
        }
        catch (FacesException e) {
            log.log(Level.SEVERE, "No Converter for type " + arrayComponentType.getName() + " found", e);
            return null;
        }
    }

    public static void checkParamValidity(FacesContext facesContext, UIComponent uiComponent, Class compClass) {
        if (facesContext == null) {
            throw new NullPointerException("facesContext may not be null");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent may not be null");
        }
        if (compClass != null && !compClass.isInstance(uiComponent)) {
            throw new IllegalArgumentException("uiComponent : " + RendererUtils.getPathToComponent(uiComponent) + " is not instance of " + compClass.getName() + " as it should be");
        }
    }

    public static void renderChildren(FacesContext facesContext, UIComponent component) throws IOException {
        if (component.getChildCount() > 0) {
            for (int i = 0; i < component.getChildCount(); ++i) {
                UIComponent child = component.getChildren().get(i);
                child.encodeAll(facesContext);
            }
        }
    }

    @Deprecated
    public static void renderChild(FacesContext facesContext, UIComponent child) throws IOException {
        if (!RendererUtils.isRendered(facesContext, child)) {
            return;
        }
        child.encodeBegin(facesContext);
        if (child.getRendersChildren()) {
            child.encodeChildren(facesContext);
        } else {
            RendererUtils.renderChildren(facesContext, child);
        }
        child.encodeEnd(facesContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRendered(FacesContext facesContext, UIComponent uiComponent) {
        try {
            uiComponent.pushComponentToEL(facesContext, uiComponent);
            boolean bl = uiComponent.isRendered();
            return bl;
        }
        finally {
            uiComponent.popComponentFromEL(facesContext);
        }
    }

    public static List getSelectItemList(UISelectOne uiSelectOne) {
        return RendererUtils.internalGetSelectItemList(uiSelectOne, FacesContext.getCurrentInstance());
    }

    public static List getSelectItemList(UISelectOne uiSelectOne, FacesContext facesContext) {
        return RendererUtils.internalGetSelectItemList(uiSelectOne, facesContext);
    }

    public static List getSelectItemList(UISelectMany uiSelectMany) {
        return RendererUtils.internalGetSelectItemList(uiSelectMany, FacesContext.getCurrentInstance());
    }

    public static List getSelectItemList(UISelectMany uiSelectMany, FacesContext facesContext) {
        return RendererUtils.internalGetSelectItemList(uiSelectMany, facesContext);
    }

    private static List internalGetSelectItemList(UIComponent uiComponent, FacesContext facesContext) {
        ArrayList list = new ArrayList();
        SelectItemsIterator iter = new SelectItemsIterator(uiComponent, facesContext);
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public static Set getSubmittedValuesAsSet(FacesContext context, UIComponent component, Converter converter, UISelectMany uiSelectMany) {
        Object submittedValues = uiSelectMany.getSubmittedValue();
        if (submittedValues == null) {
            return null;
        }
        if (converter != null) {
            converter = new PassThroughAsStringConverter(converter);
        }
        return RendererUtils.internalSubmittedOrSelectedValuesAsSet(context, component, converter, uiSelectMany, submittedValues, false);
    }

    public static Set getSelectedValuesAsSet(FacesContext context, UIComponent component, Converter converter, UISelectMany uiSelectMany) {
        Object selectedValues = uiSelectMany.getValue();
        return RendererUtils.internalSubmittedOrSelectedValuesAsSet(context, component, converter, uiSelectMany, selectedValues, true);
    }

    public static String getConvertedStringValue(FacesContext context, UIComponent component, Converter converter, Object value) {
        if (converter == null) {
            if (value == null) {
                return EMPTY_STRING;
            }
            if (value instanceof String) {
                return (String)value;
            }
            return value.toString();
        }
        return converter.getAsString(context, component, value);
    }

    public static String getConvertedStringValue(FacesContext context, UIComponent component, Converter converter, SelectItem selectItem) {
        return RendererUtils.getConvertedStringValue(context, component, converter, selectItem.getValue());
    }

    private static Set internalSubmittedOrSelectedValuesAsSet(FacesContext context, UIComponent component, Converter converter, UISelectMany uiSelectMany, Object values, boolean allowNonArrayOrCollectionValue) {
        if (values == null || EMPTY_STRING.equals(values)) {
            return Collections.EMPTY_SET;
        }
        if (values instanceof Object[]) {
            Object[] ar = (Object[])values;
            if (ar.length == 0) {
                return Collections.EMPTY_SET;
            }
            HashSet<String> set = new HashSet<String>(HashMapUtils.calcCapacity(ar.length));
            for (int i = 0; i < ar.length; ++i) {
                set.add(RendererUtils.getConvertedStringValue(context, component, converter, ar[i]));
            }
            return set;
        }
        if (values.getClass().isArray()) {
            int len = Array.getLength(values);
            HashSet<String> set = new HashSet<String>(HashMapUtils.calcCapacity(len));
            for (int i = 0; i < len; ++i) {
                set.add(RendererUtils.getConvertedStringValue(context, component, converter, Array.get(values, i)));
            }
            return set;
        }
        if (values instanceof Collection) {
            Collection col = (Collection)values;
            if (col.size() == 0) {
                return Collections.EMPTY_SET;
            }
            HashSet<String> set = new HashSet<String>(HashMapUtils.calcCapacity(col.size()));
            Iterator i = col.iterator();
            while (i.hasNext()) {
                set.add(RendererUtils.getConvertedStringValue(context, component, converter, i.next()));
            }
            return set;
        }
        if (allowNonArrayOrCollectionValue) {
            HashSet<Object> set = new HashSet<Object>(HashMapUtils.calcCapacity(1));
            set.add(values);
            return set;
        }
        throw new IllegalArgumentException("Value of UISelectMany component with path : " + RendererUtils.getPathToComponent(uiSelectMany) + " is not of type Array or List");
    }

    public static Object getConvertedUISelectOneValue(FacesContext facesContext, UISelectOne output, Object submittedValue) {
        Converter converter;
        if (submittedValue != null && !(submittedValue instanceof String)) {
            throw new IllegalArgumentException("Submitted value of type String for component : " + RendererUtils.getPathToComponent(output) + "expected");
        }
        if (submittedValue != null && submittedValue instanceof String && EMPTY_STRING.equals(submittedValue)) {
            submittedValue = null;
        }
        try {
            converter = RendererUtils.findUIOutputConverter(facesContext, output);
        }
        catch (FacesException e) {
            throw new ConverterException(e);
        }
        return converter == null ? submittedValue : converter.getAsObject(facesContext, output, (String)submittedValue);
    }

    public static Object getConvertedUIOutputValue(FacesContext facesContext, UIOutput output, Object submittedValue) throws ConverterException {
        Converter converter;
        if (submittedValue != null && !(submittedValue instanceof String)) {
            submittedValue = submittedValue.toString();
        }
        try {
            converter = RendererUtils.findUIOutputConverter(facesContext, output);
        }
        catch (FacesException e) {
            throw new ConverterException(e);
        }
        return converter == null ? submittedValue : converter.getAsObject(facesContext, output, (String)submittedValue);
    }

    public static Object getConvertedUISelectManyValue(FacesContext facesContext, UISelectMany selectMany, Object submittedValue) throws ConverterException {
        return RendererUtils.getConvertedUISelectManyValue(facesContext, selectMany, submittedValue, false);
    }

    public static Object getConvertedUISelectManyValue(FacesContext facesContext, UISelectMany selectMany, Object submittedValue, boolean considerValueType) throws ConverterException {
        if (submittedValue == null) {
            return null;
        }
        if (!(submittedValue instanceof String[])) {
            throw new ConverterException("Submitted value of type String[] for component : " + RendererUtils.getPathToComponent(selectMany) + "expected");
        }
        return _SharedRendererUtils.getConvertedUISelectManyValue(facesContext, selectMany, (String[])submittedValue, considerValueType);
    }

    public static boolean getBooleanAttribute(UIComponent component, String attrName, boolean defaultValue) {
        Boolean b = (Boolean)component.getAttributes().get(attrName);
        return b != null ? b : defaultValue;
    }

    public static int getIntegerAttribute(UIComponent component, String attrName, int defaultValue) {
        Integer i = (Integer)component.getAttributes().get(attrName);
        return i != null ? i : defaultValue;
    }

    public static FormInfo findNestingForm(UIComponent uiComponent, FacesContext facesContext) {
        UIComponent parent;
        for (parent = uiComponent.getParent(); !(parent == null || ADF_FORM_COMPONENT_FAMILY.equals(parent.getFamily()) || TRINIDAD_FORM_COMPONENT_FAMILY.equals(parent.getFamily()) || parent instanceof UIForm); parent = parent.getParent()) {
        }
        if (parent != null) {
            String formName = parent.getClientId(facesContext);
            return new FormInfo(parent, formName);
        }
        return null;
    }

    public static boolean getBooleanValue(String attribute, Object value, boolean defaultValue) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        if (value != null) {
            log.severe("value for attribute " + attribute + " must be instanceof 'Boolean' or 'String', is of type : " + value.getClass());
            return defaultValue;
        }
        return defaultValue;
    }

    public static void copyHtmlInputTextAttributes(HtmlInputText src, HtmlInputText dest) {
        dest.setId(src.getId());
        boolean forceId = RendererUtils.getBooleanValue("forceId", src.getAttributes().get("forceId"), false);
        if (forceId) {
            dest.getAttributes().put("forceId", Boolean.TRUE);
        }
        dest.setImmediate(src.isImmediate());
        dest.setTransient(src.isTransient());
        dest.setAccesskey(src.getAccesskey());
        dest.setAlt(src.getAlt());
        dest.setConverter(src.getConverter());
        dest.setDir(src.getDir());
        dest.setDisabled(src.isDisabled());
        dest.setLang(src.getLang());
        dest.setLocalValueSet(src.isLocalValueSet());
        dest.setMaxlength(src.getMaxlength());
        dest.setOnblur(src.getOnblur());
        dest.setOnchange(src.getOnchange());
        dest.setOnclick(src.getOnclick());
        dest.setOndblclick(src.getOndblclick());
        dest.setOnfocus(src.getOnfocus());
        dest.setOnkeydown(src.getOnkeydown());
        dest.setOnkeypress(src.getOnkeypress());
        dest.setOnkeyup(src.getOnkeyup());
        dest.setOnmousedown(src.getOnmousedown());
        dest.setOnmousemove(src.getOnmousemove());
        dest.setOnmouseout(src.getOnmouseout());
        dest.setOnmouseover(src.getOnmouseover());
        dest.setOnmouseup(src.getOnmouseup());
        dest.setOnselect(src.getOnselect());
        dest.setReadonly(src.isReadonly());
        dest.setRendered(src.isRendered());
        dest.setRequired(src.isRequired());
        dest.setSize(src.getSize());
        dest.setStyle(src.getStyle());
        dest.setStyleClass(src.getStyleClass());
        dest.setTabindex(src.getTabindex());
        dest.setTitle(src.getTitle());
        dest.setValidator(src.getValidator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Integer getViewSequence(FacesContext facescontext) {
        Map<String, Object> map = facescontext.getExternalContext().getRequestMap();
        Integer sequence = (Integer)map.get(SEQUENCE_PARAM);
        if (sequence == null) {
            sequence = new Integer(1);
            map.put(SEQUENCE_PARAM, sequence);
            Object object = facescontext.getExternalContext().getSession(true);
            synchronized (object) {
                facescontext.getExternalContext().getSessionMap().put(SEQUENCE_PARAM, sequence);
            }
        }
        return sequence;
    }

    public static UIComponent findComponent(UIComponent headerComp, Class clazz) {
        if (clazz.isAssignableFrom(headerComp.getClass())) {
            return headerComp;
        }
        List<UIComponent> li = headerComp.getChildren();
        for (int i = 0; i < li.size(); ++i) {
            UIComponent comp = li.get(i);
            UIComponent lookupComp = RendererUtils.findComponent(comp, clazz);
            if (lookupComp == null) continue;
            return lookupComp;
        }
        return null;
    }

    public static void addOrReplaceChild(UIInput component, UIComponent child) {
        List<UIComponent> li = component.getChildren();
        for (int i = 0; i < li.size(); ++i) {
            UIComponent oldChild = li.get(i);
            if (oldChild.getId() == null || !oldChild.getId().equals(child.getId())) continue;
            li.set(i, child);
            return;
        }
        component.getChildren().add(child);
    }

    public static String getClientId(FacesContext facesContext, UIComponent uiComponent, String forAttr) {
        UIComponent forComponent = uiComponent.findComponent(forAttr);
        if (forComponent == null) {
            char separatorChar = UINamingContainer.getSeparatorChar(facesContext);
            if (log.isLoggable(Level.INFO)) {
                log.info("Unable to find component '" + forAttr + "' (calling findComponent on component '" + uiComponent.getClientId(facesContext) + "')." + " We'll try to return a guessed client-id anyways -" + " this will be a problem if you put the referenced component" + " into a different naming-container. If this is the case, " + "you can always use the full client-id.");
            }
            if (forAttr.length() > 0 && forAttr.charAt(0) == separatorChar) {
                return forAttr.substring(1);
            }
            String labelClientId = uiComponent.getClientId(facesContext);
            int colon = labelClientId.lastIndexOf(separatorChar);
            return colon == -1 ? forAttr : labelClientId.substring(0, colon + 1) + forAttr;
        }
        return forComponent.getClientId(facesContext);
    }

    public static List convertIdsToClientIds(String actionFor, FacesContext facesContext, UIComponent component) {
        ArrayList<String> li = new ArrayList<String>();
        String[] ids = actionFor.split(",");
        for (int i = 0; i < ids.length; ++i) {
            String trimedId = ids[i].trim();
            if (trimedId.equals("none")) {
                li.add(trimedId);
                continue;
            }
            li.add(RendererUtils.getClientId(facesContext, component, trimedId));
        }
        return li;
    }

    public static List convertPhasesToPhasesIds(String actionForPhase) {
        ArrayList<PhaseId> li = new ArrayList<PhaseId>();
        if (actionForPhase == null) {
            return li;
        }
        String[] ids = actionForPhase.split(",");
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].equals("PROCESS_VALIDATIONS")) {
                li.add(PhaseId.PROCESS_VALIDATIONS);
                continue;
            }
            if (!ids[i].equals("UPDATE_MODEL_VALUES")) continue;
            li.add(PhaseId.UPDATE_MODEL_VALUES);
        }
        return li;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadResourceFile(FacesContext ctx, String file) {
        ByteArrayOutputStream content = new ByteArrayOutputStream(10240);
        InputStream in = null;
        try {
            int read;
            in = ctx.getExternalContext().getResourceAsStream(file);
            if (in == null) {
                String string = null;
                return string;
            }
            byte[] fileBuffer = new byte[10240];
            while ((read = in.read(fileBuffer)) > -1) {
                content.write(fileBuffer, 0, read);
            }
        }
        catch (FileNotFoundException e) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "no such file " + file, e);
            }
            content = null;
        }
        catch (IOException e) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "problems during processing resource " + file, e);
            }
            content = null;
        }
        finally {
            try {
                if (content != null) {
                    content.close();
                }
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
            }
        }
        return content.toString();
    }

    public static void initPartialValidationAndModelUpdate(UIComponent component, FacesContext facesContext) {
        String actionFor = (String)component.getAttributes().get("actionFor");
        if (actionFor != null) {
            List li = RendererUtils.convertIdsToClientIds(actionFor, facesContext, component);
            facesContext.getExternalContext().getRequestMap().put(ACTION_FOR_LIST, li);
            String actionForPhase = (String)component.getAttributes().get("actionForPhase");
            if (actionForPhase != null) {
                List phaseList = RendererUtils.convertPhasesToPhasesIds(actionForPhase);
                facesContext.getExternalContext().getRequestMap().put(ACTION_FOR_PHASE_LIST, phaseList);
            }
        }
    }

    public static boolean isAdfOrTrinidadForm(UIComponent component) {
        if (component == null) {
            return false;
        }
        return ADF_FORM_COMPONENT_FAMILY.equals(component.getFamily()) || TRINIDAD_FORM_COMPONENT_FAMILY.equals(component.getFamily());
    }

    @Deprecated
    public static ResponseStateManager getResponseStateManager(FacesContext facesContext, String renderKitId) throws FacesException {
        RenderKit renderKit = facesContext.getRenderKit();
        if (renderKit == null) {
            Map<Object, Object> attributesMap = facesContext.getAttributes();
            RenderKitFactory factory = (RenderKitFactory)attributesMap.get(RENDER_KIT_IMPL);
            if (factory != null) {
                renderKit = factory.getRenderKit(facesContext, renderKitId);
            } else {
                factory = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
                if (factory == null) {
                    throw new IllegalStateException("Factory is null");
                }
                attributesMap.put(RENDER_KIT_IMPL, factory);
                renderKit = factory.getRenderKit(facesContext, renderKitId);
            }
        }
        if (renderKit == null) {
            throw new IllegalArgumentException("Could not find a RenderKit for \"" + renderKitId + "\"");
        }
        return renderKit.getResponseStateManager();
    }

    public static String getIconSrc(FacesContext facesContext, UIComponent component, String attributeName) {
        Map<String, Object> attributes = component.getAttributes();
        String resourceName = (String)attributes.get("name");
        if (resourceName != null && resourceName.length() > 0) {
            ResourceHandler resourceHandler = facesContext.getApplication().getResourceHandler();
            String libraryName = (String)component.getAttributes().get("library");
            Resource resource = libraryName != null && libraryName.length() > 0 ? resourceHandler.createResource(resourceName, libraryName) : resourceHandler.createResource(resourceName);
            if (resource == null) {
                if (facesContext.isProjectStage(ProjectStage.Development)) {
                    String summary = "Unable to find resource: " + resourceName;
                    if (libraryName != null) {
                        summary = summary + " from library: " + libraryName;
                    }
                    facesContext.addMessage(component.getClientId(facesContext), new FacesMessage(FacesMessage.SEVERITY_WARN, summary, summary));
                }
                return RES_NOT_FOUND;
            }
            return resource.getRequestPath();
        }
        String value = (String)component.getAttributes().get(attributeName);
        return RendererUtils.toResourceUri(facesContext, value);
    }

    public static String toResourceUri(FacesContext facesContext, Object o) {
        if (o == null) {
            return null;
        }
        String uri = o.toString();
        if (uri.length() == 0) {
            return null;
        }
        if (uri.contains("/javax.faces.resource")) {
            return uri;
        }
        if (uri.startsWith("//")) {
            return uri.substring(1);
        }
        String resourceURL = facesContext.getApplication().getViewHandler().getResourceURL(facesContext, uri);
        return facesContext.getExternalContext().encodeResourceURL(resourceURL);
    }

    private static class PassThroughAsStringConverter
    implements Converter {
        private final Converter converter;

        public PassThroughAsStringConverter(Converter converter) {
            this.converter = converter;
        }

        public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
            return this.converter.getAsObject(context, component, value);
        }

        public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
            return (String)value;
        }
    }
}

