/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.dependent;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import org.apache.myfaces.cdi.dependent.DependentBeanEntry;

public abstract class AbstractBeanStorage {
    private static final Logger LOG = Logger.getLogger(AbstractBeanStorage.class.getName());
    private List<DependentBeanEntry> dependentBeanEntries = new ArrayList<DependentBeanEntry>();

    public void add(DependentBeanEntry dependentBeanEntry) {
        this.dependentBeanEntries.add(dependentBeanEntry);
    }

    @PreDestroy
    public void cleanup() {
        for (DependentBeanEntry beanEntry : this.dependentBeanEntries) {
            try {
                beanEntry.getBean().destroy(beanEntry.getInstance(), beanEntry.getCreationalContext());
            }
            catch (RuntimeException e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.dependentBeanEntries.clear();
    }
}

