/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.resource;

import java.io.InputStream;
import java.net.URL;
import org.apache.myfaces.shared.resource.ContractResourceLoader;
import org.apache.myfaces.shared.resource.ResourceMeta;
import org.apache.myfaces.shared.resource.ResourceMetaImpl;
import org.apache.myfaces.shared.util.ClassUtils;

public class ClassLoaderContractResourceLoader
extends ContractResourceLoader {
    public ClassLoaderContractResourceLoader(String prefix) {
        super(prefix);
    }

    @Override
    public String getLibraryVersion(String path, String contractName) {
        return null;
    }

    @Override
    public InputStream getResourceInputStream(ResourceMeta resourceMeta) {
        InputStream is = null;
        if (this.getPrefix() != null && !"".equals(this.getPrefix())) {
            String name = this.getPrefix() + '/' + resourceMeta.getContractName() + '/' + resourceMeta.getResourceIdentifier();
            is = this.getClassLoader().getResourceAsStream(name);
            if (is == null) {
                is = this.getClass().getClassLoader().getResourceAsStream(name);
            }
            return is;
        }
        String name = resourceMeta.getContractName() + '/' + resourceMeta.getResourceIdentifier();
        is = this.getClassLoader().getResourceAsStream(name);
        if (is == null) {
            is = this.getClass().getClassLoader().getResourceAsStream(name);
        }
        return is;
    }

    @Override
    public URL getResourceURL(ResourceMeta resourceMeta) {
        URL url = null;
        if (this.getPrefix() != null && !"".equals(this.getPrefix())) {
            String name = this.getPrefix() + '/' + resourceMeta.getContractName() + '/' + resourceMeta.getResourceIdentifier();
            url = this.getClassLoader().getResource(name);
            if (url == null) {
                url = this.getClass().getClassLoader().getResource(name);
            }
            return url;
        }
        String name = resourceMeta.getContractName() + '/' + resourceMeta.getResourceIdentifier();
        url = this.getClassLoader().getResource(name);
        if (url == null) {
            url = this.getClass().getClassLoader().getResource(name);
        }
        return url;
    }

    @Override
    public String getResourceVersion(String path, String contractName) {
        return null;
    }

    @Override
    public ResourceMeta createResourceMeta(String prefix, String libraryName, String libraryVersion, String resourceName, String resourceVersion, String contractName) {
        return new ResourceMetaImpl(prefix, libraryName, libraryVersion, resourceName, resourceVersion, contractName);
    }

    protected ClassLoader getClassLoader() {
        return ClassUtils.getContextClassLoader();
    }

    @Override
    public boolean libraryExists(String libraryName, String contractName) {
        if (this.getPrefix() != null && !"".equals(this.getPrefix())) {
            String name = this.getPrefix() + '/' + contractName + '/' + libraryName;
            URL url = this.getClassLoader().getResource(name);
            if (url == null) {
                url = this.getClass().getClassLoader().getResource(name);
            }
            if (url != null) {
                return true;
            }
        } else {
            String name = contractName + '/' + libraryName;
            URL url = this.getClassLoader().getResource(name);
            if (url == null) {
                url = this.getClass().getClassLoader().getResource(name);
            }
            if (url != null) {
                return true;
            }
        }
        return false;
    }
}

