/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.apache.AnnotationProcessor;
import org.apache.myfaces.spi.InjectionProvider;
import org.apache.myfaces.spi.InjectionProviderException;

public class TomcatAnnotationInjectionProvider
extends InjectionProvider {
    private static Logger log = Logger.getLogger(TomcatAnnotationInjectionProvider.class.getName());
    private ExternalContext externalContext;
    private AnnotationProcessor annotationProcessor;

    public TomcatAnnotationInjectionProvider(ExternalContext externalContext) {
        this.externalContext = externalContext;
    }

    @Override
    public Object inject(Object instance) throws InjectionProviderException {
        try {
            this.annotationProcessor.processAnnotations(instance);
        }
        catch (IllegalAccessException ex) {
            throw new InjectionProviderException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new InjectionProviderException(ex);
        }
        catch (NamingException ex) {
            throw new InjectionProviderException(ex);
        }
        return null;
    }

    @Override
    public void preDestroy(Object instance, Object creationMetaData) throws InjectionProviderException {
        if (log.isLoggable(Level.FINEST)) {
            log.info("Destroy instance of " + instance.getClass().getName());
        }
        try {
            this.annotationProcessor.preDestroy(instance);
        }
        catch (IllegalAccessException ex) {
            throw new InjectionProviderException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new InjectionProviderException(ex);
        }
    }

    @Override
    public boolean isAvailable() {
        try {
            this.annotationProcessor = (AnnotationProcessor)((ServletContext)this.externalContext.getContext()).getAttribute(AnnotationProcessor.class.getName());
            return this.annotationProcessor != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public void postConstruct(Object instance, Object creationMetaData) throws InjectionProviderException {
        try {
            this.annotationProcessor.postConstruct(instance);
        }
        catch (IllegalAccessException ex) {
            throw new InjectionProviderException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new InjectionProviderException(ex);
        }
    }
}

