/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;

public final class TagAttributesImpl
extends TagAttributes {
    private static final TagAttribute[] EMPTY = new TagAttribute[0];
    private final TagAttribute[] _attributes;
    private final String[] _namespaces;
    private final List<TagAttribute[]> _nsattrs;

    public TagAttributesImpl(TagAttribute[] attrs) {
        this._attributes = attrs;
        HashSet<String> set = new HashSet<String>();
        for (TagAttribute attribute : this._attributes) {
            set.add(attribute.getNamespace());
        }
        this._namespaces = set.toArray(new String[set.size()]);
        Arrays.sort(this._namespaces);
        int size = this._namespaces.length;
        ArrayList temp = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            temp.add(new ArrayList());
        }
        for (TagAttribute attribute : this._attributes) {
            ((List)temp.get(Arrays.binarySearch(this._namespaces, attribute.getNamespace()))).add(attribute);
        }
        this._nsattrs = new ArrayList<TagAttribute[]>(size);
        for (int i = 0; i < size; ++i) {
            List l = (List)temp.get(i);
            this._nsattrs.add(l.toArray(new TagAttribute[l.size()]));
        }
    }

    @Override
    public TagAttribute[] getAll() {
        return this._attributes;
    }

    @Override
    public TagAttribute get(String localName) {
        return this.get("", localName);
    }

    @Override
    public TagAttribute get(String ns, String localName) {
        int idx;
        if (ns != null && localName != null && (idx = Arrays.binarySearch(this._namespaces, ns)) >= 0) {
            for (TagAttribute attribute : this._nsattrs.get(idx)) {
                if (!localName.equals(attribute.getLocalName())) continue;
                return attribute;
            }
        }
        return null;
    }

    @Override
    public TagAttribute[] getAll(String namespace) {
        int idx = 0;
        idx = namespace == null ? Arrays.binarySearch(this._namespaces, "") : Arrays.binarySearch(this._namespaces, namespace);
        if (idx >= 0) {
            return this._nsattrs.get(idx);
        }
        return EMPTY;
    }

    @Override
    public String[] getNamespaces() {
        return this._namespaces;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (TagAttribute attribute : this._attributes) {
            sb.append(attribute);
            sb.append(' ');
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

