/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.search;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.component.search.SearchExpressionContext;
import javax.faces.component.search.SearchExpressionHint;
import javax.faces.component.search.SearchKeywordContext;
import javax.faces.component.search.SearchKeywordResolver;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;

public class IdSearchKeywordResolver
extends SearchKeywordResolver {
    public static final String ID_KEYWORD = "id";
    private static final Pattern PATTERN = Pattern.compile("id\\((\\w+)\\)");

    public void resolve(final SearchKeywordContext expressionContext, UIComponent current, String keyword) {
        FacesContext facesContext = expressionContext.getSearchExpressionContext().getFacesContext();
        final String targetId = this.extractId(keyword);
        if (expressionContext.getSearchExpressionContext().getExpressionHints() != null && expressionContext.getSearchExpressionContext().getExpressionHints().contains(SearchExpressionHint.SKIP_VIRTUAL_COMPONENTS)) {
            IdSearchKeywordResolver.withId(facesContext, targetId, current, expressionContext.getCallback());
            expressionContext.setKeywordResolved(true);
        } else {
            current.visitTree(VisitContext.createVisitContext((FacesContext)facesContext, null, (Set)expressionContext.getSearchExpressionContext().getVisitHints()), new VisitCallback(){

                public VisitResult visit(VisitContext context, UIComponent target) {
                    if (targetId.equals(target.getId())) {
                        expressionContext.invokeContextCallback(target);
                        if (expressionContext.getSearchExpressionContext().getExpressionHints() != null && expressionContext.getSearchExpressionContext().getExpressionHints().contains(SearchExpressionHint.RESOLVE_SINGLE_COMPONENT)) {
                            return VisitResult.COMPLETE;
                        }
                        return VisitResult.ACCEPT;
                    }
                    return VisitResult.ACCEPT;
                }
            });
        }
    }

    protected String extractId(String expression) {
        Matcher matcher = PATTERN.matcher(expression);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new FacesException("Expression does not match following pattern @id(id). Expression: \"" + expression + '\"');
    }

    private static void withId(FacesContext context, String id, UIComponent base, ContextCallback callback) {
        int childCount;
        if (id.equals(base.getId())) {
            callback.invokeContextCallback(context, base);
        }
        if (base.getFacetCount() > 0) {
            for (UIComponent facet : base.getFacets().values()) {
                IdSearchKeywordResolver.withId(context, id, facet, callback);
            }
        }
        if ((childCount = base.getChildCount()) > 0) {
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)base.getChildren().get(i);
                IdSearchKeywordResolver.withId(context, id, child, callback);
            }
        }
    }

    public boolean isResolverForKeyword(SearchExpressionContext searchExpressionContext, String command) {
        if (command.length() > 6 && command.substring(0, ID_KEYWORD.length()).equalsIgnoreCase(ID_KEYWORD)) {
            Matcher matcher = PATTERN.matcher(command);
            return matcher.matches();
        }
        return false;
    }

    public boolean isPassthrough(SearchExpressionContext searchExpressionContext, String keyword) {
        return false;
    }

    public boolean isLeaf(SearchExpressionContext searchExpressionContext, String keyword) {
        return false;
    }
}

