/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.resolver;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.BeanELResolver;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.core.api.shared.lang.LambdaPropertyDescriptor;
import org.apache.myfaces.core.api.shared.lang.PropertyDescriptorUtils;
import org.apache.myfaces.core.api.shared.lang.PropertyDescriptorWrapper;

public class LambdaBeanELResolver
extends BeanELResolver {
    private final ConcurrentHashMap<String, Map<String, ? extends PropertyDescriptorWrapper>> cache = new ConcurrentHashMap(1000);

    public Class<?> getType(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base == null || property == null) {
            return null;
        }
        context.setPropertyResolved(base, property);
        return this.getPropertyDescriptor(base, property).getPropertyType();
    }

    public Object getValue(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base == null || property == null) {
            return null;
        }
        context.setPropertyResolved(base, property);
        try {
            PropertyDescriptorWrapper pd = this.getPropertyDescriptor(base, property);
            if (pd instanceof LambdaPropertyDescriptor) {
                return ((LambdaPropertyDescriptor)pd).getReadFunction().apply(base);
            }
            return pd.getWrapped().getReadMethod().invoke(base, new Object[0]);
        }
        catch (Exception e) {
            throw new ELException((Throwable)e);
        }
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        Objects.requireNonNull(context);
        if (base == null || property == null) {
            return;
        }
        context.setPropertyResolved(base, property);
        PropertyDescriptorWrapper pd = this.getPropertyDescriptor(base, property);
        if (pd.getWrapped().getWriteMethod() == null) {
            throw new PropertyNotWritableException("Property \"" + (String)property + "\" in \"" + base.getClass().getName() + "\" is not writable!");
        }
        try {
            if (pd instanceof LambdaPropertyDescriptor) {
                ((LambdaPropertyDescriptor)pd).getWriteFunction().accept(base, value);
            } else {
                pd.getWrapped().getWriteMethod().invoke(base, value);
            }
        }
        catch (Exception e) {
            throw new ELException((Throwable)e);
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base == null || property == null) {
            return false;
        }
        context.setPropertyResolved(base, property);
        return this.getPropertyDescriptor(base, property).getWrapped().getWriteMethod() == null;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base != null) {
            return Object.class;
        }
        return null;
    }

    protected PropertyDescriptorWrapper getPropertyDescriptor(Object base, Object property) {
        PropertyDescriptorWrapper pd;
        Map beanCache = this.cache.get(base.getClass().getName());
        if (beanCache == null) {
            beanCache = PropertyDescriptorUtils.getCachedPropertyDescriptors((ExternalContext)FacesContext.getCurrentInstance().getExternalContext(), base.getClass());
            this.cache.put(base.getClass().getName(), beanCache);
        }
        if ((pd = beanCache.get((String)property)) == null) {
            throw new PropertyNotFoundException("Property [" + property + "] not found on type [" + base.getClass().getName() + "]");
        }
        return pd;
    }
}

