/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewDeclarationLanguageFactory;
import org.apache.myfaces.config.MyfacesConfig;
import org.apache.myfaces.view.ViewDeclarationLanguageStrategy;
import org.apache.myfaces.view.facelets.FaceletViewDeclarationLanguageStrategy;
import org.apache.myfaces.view.jsp.JspViewDeclarationLanguageStrategy;

public class ViewDeclarationLanguageFactoryImpl
extends ViewDeclarationLanguageFactory {
    private static final String FACELETS_1_VIEW_HANDLER = "com.sun.facelets.FaceletViewHandler";
    private static final Logger LOGGER = Logger.getLogger(ViewDeclarationLanguageFactoryImpl.class.getName());
    private volatile boolean _initialized = false;
    private volatile ViewDeclarationLanguageStrategy[] _supportedLanguages;
    private volatile List<ViewDeclarationLanguage> _supportedVDLs = null;

    @Override
    public ViewDeclarationLanguage getViewDeclarationLanguage(String viewId) {
        if (!this._initialized) {
            this.initialize();
        }
        for (ViewDeclarationLanguageStrategy strategy : this._supportedLanguages) {
            if (!strategy.handles(viewId)) continue;
            return strategy.getViewDeclarationLanguage();
        }
        return null;
    }

    @Override
    public List<ViewDeclarationLanguage> getAllViewDeclarationLanguages() {
        if (!this._initialized) {
            this.initialize();
        }
        if (this._supportedVDLs == null) {
            ArrayList<ViewDeclarationLanguage> list = new ArrayList<ViewDeclarationLanguage>(this._supportedLanguages.length);
            for (ViewDeclarationLanguageStrategy strategy : this._supportedLanguages) {
                list.add(strategy.getViewDeclarationLanguage());
            }
            this._supportedVDLs = Collections.unmodifiableList(list);
        }
        return this._supportedVDLs;
    }

    private synchronized void initialize() {
        if (!this._initialized) {
            FacesContext context = FacesContext.getCurrentInstance();
            this.logWarningIfLegacyFaceletViewHandlerIsPresent(context);
            if (MyfacesConfig.getCurrentInstance(context).isSupportJSP()) {
                this._supportedLanguages = new ViewDeclarationLanguageStrategy[2];
                this._supportedLanguages[0] = new FaceletViewDeclarationLanguageStrategy();
                this._supportedLanguages[1] = new JspViewDeclarationLanguageStrategy();
            } else {
                this._supportedLanguages = new ViewDeclarationLanguageStrategy[1];
                this._supportedLanguages[0] = new FaceletViewDeclarationLanguageStrategy();
            }
            this._initialized = true;
        }
    }

    private void logWarningIfLegacyFaceletViewHandlerIsPresent(FacesContext context) {
        boolean facelets1ViewHandlerPresent = context.getApplication().getViewHandler().getClass().getName().equals(FACELETS_1_VIEW_HANDLER);
        if (facelets1ViewHandlerPresent && LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "Your faces-config.xml contains the com.sun.facelets.FaceletViewHandler class.\nYou need to remove it since it's not supported anymore since JSF 2.0");
        }
    }
}

