/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.component;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.base.HtmlRenderer;
import org.apache.myfaces.renderkit.html.util.ClientBehaviorRendererUtils;
import org.apache.myfaces.renderkit.html.util.CommonEventUtils;
import org.apache.myfaces.renderkit.html.util.CommonPropertyUtils;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.ResourceUtils;
import org.apache.myfaces.view.facelets.LocationAwareFacesException;
import org.apache.myfaces.view.facelets.component.JsfElement;

public class JsfElementRenderer
extends HtmlRenderer {
    @Override
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        ClientBehaviorRendererUtils.decodeClientBehaviors(context, component);
    }

    @Override
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String elementName = (String)component.getPassThroughAttributes().get("elementName");
        if (elementName == null) {
            throw new LocationAwareFacesException("jsf:element with clientId" + component.getClientId(facesContext) + " requires 'elementName' passthrough attribute", component);
        }
        JsfElement jsfElement = (JsfElement)component;
        Map<String, List<ClientBehavior>> behaviors = jsfElement.getClientBehaviors();
        if (behaviors != null && !behaviors.isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
        }
        writer.startElement(elementName, component);
        if (!behaviors.isEmpty()) {
            HtmlRendererUtils.writeIdAndName(writer, component, facesContext);
        } else {
            HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
        }
        long commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked(component);
        if (behaviors.isEmpty()) {
            CommonPropertyUtils.renderEventProperties(writer, commonPropertiesMarked, component);
            CommonPropertyUtils.renderFocusBlurEventProperties(writer, commonPropertiesMarked, component);
            CommonPropertyUtils.renderChangeSelectEventProperties(writer, commonPropertiesMarked, component);
        } else {
            long commonEventsMarked = CommonEventUtils.getCommonEventsMarked(component);
            CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, component, behaviors);
            CommonEventUtils.renderBehaviorizedFieldEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, component, component.getClientId(facesContext), behaviors);
        }
        CommonPropertyUtils.renderStyleProperties(writer, commonPropertiesMarked, component);
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onload", component, "load", behaviors, "onload");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onunload", component, "unload", behaviors, "onunload");
    }

    @Override
    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.renderChildren(facesContext, component);
    }

    @Override
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String elementName = (String)component.getPassThroughAttributes().get("elementName");
        writer.endElement(elementName);
    }

    @Override
    protected boolean isCommonPropertiesOptimizationEnabled(FacesContext facesContext) {
        return true;
    }

    @Override
    protected boolean isCommonEventsOptimizationEnabled(FacesContext facesContext) {
        return true;
    }
}

