/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.FacesMessage;
import javax.faces.application.NavigationCase;
import javax.faces.application.ProjectStage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewAction;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.flow.Flow;
import javax.faces.flow.FlowCallNode;
import javax.faces.flow.FlowHandler;
import javax.faces.flow.FlowNode;
import javax.faces.flow.MethodCallNode;
import javax.faces.flow.Parameter;
import javax.faces.flow.ReturnNode;
import javax.faces.flow.SwitchCase;
import javax.faces.flow.SwitchNode;
import javax.faces.flow.ViewNode;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewMetadata;
import org.apache.myfaces.application.FlowNavigationCase;
import org.apache.myfaces.application.ViewIdSupport;
import org.apache.myfaces.application._FlowNavigationStructure;
import org.apache.myfaces.application._WildcardPattern;
import org.apache.myfaces.component.visit.MyFacesVisitHints;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.element.NavigationRule;
import org.apache.myfaces.flow.FlowHandlerImpl;
import org.apache.myfaces.util.NavigationUtils;
import org.apache.myfaces.util.SharedStringBuilder;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.util.lang.FilenameUtils;
import org.apache.myfaces.util.lang.HashMapUtils;
import org.apache.myfaces.util.lang.StringUtils;
import org.apache.myfaces.view.facelets.ViewPoolProcessor;
import org.apache.myfaces.view.facelets.tag.jsf.PreDisposeViewEvent;

public class NavigationHandlerImpl
extends ConfigurableNavigationHandler {
    private static final Logger log = Logger.getLogger(NavigationHandlerImpl.class.getName());
    public static final String CALL_PRE_DISPOSE_VIEW = "oam.CALL_PRE_DISPOSE_VIEW";
    private static final String OUTCOME_NAVIGATION_SB = "oam.navigation.OUTCOME_NAVIGATION_SB";
    private static final Pattern AMP_PATTERN = Pattern.compile("&(amp;)?");
    private static final String ASTERISK = "*";
    private Map<String, Set<NavigationCase>> _navigationCases = null;
    private List<_WildcardPattern> _wildcardPatterns = new ArrayList<_WildcardPattern>();
    private Boolean _developmentStage;
    private Map<String, _FlowNavigationStructure> _flowNavigationStructureMap = new ConcurrentHashMap<String, _FlowNavigationStructure>();
    private ViewIdSupport viewIdSupport;

    public NavigationHandlerImpl() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("New NavigationHandler instance created");
        }
    }

    public void handleNavigation(FacesContext facesContext, String fromAction, String outcome) {
        this.handleNavigation(facesContext, fromAction, outcome, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNavigation(FacesContext facesContext, String fromAction, String outcome, String toFlowDocumentId) {
        NavigationContext navigationContext = new NavigationContext();
        NavigationCase navigationCase = null;
        try {
            navigationCase = this.getNavigationCommand(facesContext, navigationContext, fromAction, outcome, toFlowDocumentId);
        }
        finally {
            navigationContext.finish(facesContext);
        }
        if (navigationCase != null) {
            ViewMetadata metadata;
            ViewDeclarationLanguage vdl;
            String viewId;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("handleNavigation fromAction=" + fromAction + " outcome=" + outcome + " toViewId =" + navigationCase.getToViewId(facesContext) + " redirect=" + navigationCase.isRedirect());
            }
            boolean isViewActionProcessingBroadcastAndRequiresRedirect = false;
            if (UIViewAction.isProcessingBroadcast((FacesContext)facesContext)) {
                facesContext.getExternalContext().getFlash().setKeepMessages(true);
                String fromViewId = facesContext.getViewRoot() == null ? null : facesContext.getViewRoot().getViewId();
                String toViewId = navigationCase.getToViewId(facesContext);
                if (fromViewId == null && toViewId != null) {
                    isViewActionProcessingBroadcastAndRequiresRedirect = true;
                } else if (fromViewId != null && !fromViewId.equals(toViewId)) {
                    isViewActionProcessingBroadcastAndRequiresRedirect = true;
                }
            }
            if (navigationCase.isRedirect() || isViewActionProcessingBroadcastAndRequiresRedirect) {
                ViewPoolProcessor processor;
                String viewId2;
                Map viewMap;
                FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
                List<Flow> activeFlows = FlowHandlerImpl.getActiveFlows(facesContext, flowHandler);
                Flow currentFlow = flowHandler.getCurrentFlow(facesContext);
                Flow targetFlow = this.calculateTargetFlow(facesContext, outcome, flowHandler, activeFlows, toFlowDocumentId);
                HashMap<String, List<String>> navigationCaseParameters = navigationCase.getParameters();
                if (currentFlow != targetFlow && (currentFlow != null && !currentFlow.equals(targetFlow) || targetFlow != null && !targetFlow.equals(currentFlow))) {
                    if (navigationCaseParameters == null) {
                        navigationCaseParameters = new HashMap<String, List<String>>(5, 1.0f);
                    }
                    if (currentFlow != null && targetFlow == null) {
                        navigationCaseParameters.put("jftfdi", Arrays.asList("javax.faces.flow.NullFlow"));
                        navigationCaseParameters.put("jffi", Arrays.asList(""));
                    } else {
                        navigationCaseParameters.put("jftfdi", Arrays.asList(toFlowDocumentId == null ? "" : toFlowDocumentId));
                        navigationCaseParameters.put("jffi", Arrays.asList(targetFlow.getId()));
                    }
                }
                ExternalContext externalContext = facesContext.getExternalContext();
                ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
                String toViewId = navigationCase.getToViewId(facesContext);
                String redirectPath = viewHandler.getRedirectURL(facesContext, toViewId, NavigationUtils.getEvaluatedNavigationParameters(facesContext, navigationCaseParameters), navigationCase.isIncludeViewParams());
                this.applyFlowTransition(facesContext, navigationContext);
                UIViewRoot viewRoot = facesContext.getViewRoot();
                if (viewRoot != null && !toViewId.equals(viewRoot.getViewId()) && (viewMap = viewRoot.getViewMap(false)) != null) {
                    viewMap.clear();
                }
                PartialViewContext partialViewContext = facesContext.getPartialViewContext();
                String string = viewId2 = facesContext.getViewRoot() != null ? facesContext.getViewRoot().getViewId() : null;
                if (partialViewContext.isPartialRequest() && !partialViewContext.isRenderAll() && toViewId != null && !toViewId.equals(viewId2)) {
                    partialViewContext.setRenderAll(true);
                }
                if ((processor = ViewPoolProcessor.getInstance(facesContext)) != null && processor.isViewPoolEnabledForThisView(facesContext, facesContext.getViewRoot())) {
                    processor.disposeView(facesContext, facesContext.getViewRoot());
                }
                externalContext.getFlash().setRedirect(true);
                try {
                    externalContext.redirect(redirectPath);
                    facesContext.responseComplete();
                }
                catch (IOException e) {
                    throw new FacesException(e.getMessage(), (Throwable)e);
                }
            }
            ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
            String newViewId = navigationCase.getToViewId(facesContext);
            PartialViewContext partialViewContext = facesContext.getPartialViewContext();
            String string = viewId = facesContext.getViewRoot() != null ? facesContext.getViewRoot().getViewId() : null;
            if (partialViewContext.isPartialRequest() && !partialViewContext.isRenderAll() && newViewId != null && !newViewId.equals(viewId)) {
                partialViewContext.setRenderAll(true);
            }
            if (facesContext.getViewRoot() != null && facesContext.getViewRoot().getAttributes().containsKey(CALL_PRE_DISPOSE_VIEW)) {
                try {
                    facesContext.getAttributes().put("javax.faces.visit.SKIP_ITERATION", Boolean.TRUE);
                    VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, MyFacesVisitHints.SET_SKIP_ITERATION);
                    facesContext.getViewRoot().visitTree(visitContext, (VisitCallback)PreDisposeViewCallback.INSTANCE);
                }
                finally {
                    facesContext.getAttributes().remove("javax.faces.visit.SKIP_ITERATION");
                }
            }
            this.applyFlowTransition(facesContext, navigationContext);
            ViewPoolProcessor processor = ViewPoolProcessor.getInstance(facesContext);
            if (processor != null && processor.isViewPoolEnabledForThisView(facesContext, facesContext.getViewRoot())) {
                processor.disposeView(facesContext, facesContext.getViewRoot());
            }
            UIViewRoot viewRoot = null;
            String derivedViewId = viewHandler.deriveViewId(facesContext, newViewId);
            if (derivedViewId != null && (vdl = viewHandler.getViewDeclarationLanguage(facesContext, derivedViewId)) != null && (metadata = vdl.getViewMetadata(facesContext, newViewId)) != null) {
                viewRoot = metadata.createMetadataView(facesContext);
            }
            if (viewRoot == null) {
                viewRoot = viewHandler.createView(facesContext, newViewId);
            }
            facesContext.setViewRoot(viewRoot);
            facesContext.renderResponse();
        } else if (log.isLoggable(Level.FINEST)) {
            log.finest("handleNavigation fromAction=" + fromAction + " outcome=" + outcome + " no matching navigation-case found, staying on current ViewRoot");
        }
    }

    private void applyFlowTransition(FacesContext facesContext, NavigationContext navigationContext) {
        if (navigationContext != null && navigationContext.getSourceFlows() != null || navigationContext.getTargetFlows() != null && !navigationContext.getTargetFlows().isEmpty()) {
            FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
            for (int i = 0; i < navigationContext.getTargetFlows().size(); ++i) {
                Flow sourceFlow = navigationContext.getSourceFlows().get(i);
                Flow targetFlow = navigationContext.getTargetFlows().get(i);
                flowHandler.transition(facesContext, sourceFlow, targetFlow, navigationContext.getFlowCallNodes().get(i), navigationContext.getNavigationCase().getToViewId(facesContext));
                sourceFlow = targetFlow;
            }
        }
    }

    protected ViewIdSupport getViewIdSupport() {
        if (this.viewIdSupport == null) {
            this.viewIdSupport = ViewIdSupport.getInstance(FacesContext.getCurrentInstance());
        }
        return this.viewIdSupport;
    }

    public void setViewIdSupport(ViewIdSupport viewIdSupport) {
        this.viewIdSupport = viewIdSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigationCase getNavigationCase(FacesContext facesContext, String fromAction, String outcome) {
        NavigationContext navigationContext = new NavigationContext();
        try {
            NavigationCase navigationCase = this.getNavigationCommand(facesContext, navigationContext, fromAction, outcome, null);
            return navigationCase;
        }
        finally {
            navigationContext.finish(facesContext);
        }
    }

    public NavigationCase getNavigationCommandFromGlobalNavigationCases(FacesContext facesContext, String viewId, NavigationContext navigationContext, String fromAction, String outcome) {
        Set<NavigationCase> casesSet;
        Map<String, Set<NavigationCase>> casesMap = this.getNavigationCases();
        NavigationCase navigationCase = null;
        if (viewId != null && (casesSet = casesMap.get(viewId)) != null) {
            navigationCase = this.calcMatchingNavigationCase(facesContext, casesSet, fromAction, outcome);
        }
        if (navigationCase == null) {
            _WildcardPattern wildcardPattern;
            List<_WildcardPattern> wildcardPatterns = this.getSortedWildcardPatterns();
            for (int i = 0; !(i >= wildcardPatterns.size() || (wildcardPattern = wildcardPatterns.get(i)).match(viewId) && (casesSet = casesMap.get(wildcardPattern.getPattern())) != null && (navigationCase = this.calcMatchingNavigationCase(facesContext, casesSet, fromAction, outcome)) != null); ++i) {
            }
        }
        return navigationCase;
    }

    private Flow calculateTargetFlow(FacesContext facesContext, String outcome, FlowHandler flowHandler, List<Flow> activeFlows, String toFlowDocumentId) {
        Flow targetFlow = null;
        if (toFlowDocumentId != null) {
            targetFlow = flowHandler.getFlow(facesContext, toFlowDocumentId, outcome);
        }
        if (targetFlow == null && !activeFlows.isEmpty()) {
            Flow currentFlow;
            Iterator<Flow> iterator = activeFlows.iterator();
            while (iterator.hasNext() && (targetFlow = flowHandler.getFlow(facesContext, (currentFlow = iterator.next()).getDefiningDocumentId(), outcome)) == null) {
            }
        }
        if (targetFlow == null) {
            targetFlow = flowHandler.getFlow(facesContext, "", outcome);
        }
        return targetFlow;
    }

    public NavigationCase getNavigationCommand(FacesContext facesContext, NavigationContext navigationContext, String fromAction, String outcome, String toFlowDocumentId) {
        String viewId = facesContext.getViewRoot() != null ? facesContext.getViewRoot().getViewId() : null;
        Object navigationCase = this.getNavigationCommandFromGlobalNavigationCases(facesContext, viewId, navigationContext, fromAction, outcome);
        if (outcome != null && navigationCase == null) {
            _FlowNavigationStructure flowNavigationStructure;
            FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
            List<Flow> activeFlows = FlowHandlerImpl.getActiveFlows(facesContext, flowHandler);
            Flow targetFlow = this.calculateTargetFlow(facesContext, outcome, flowHandler, activeFlows, toFlowDocumentId);
            Flow currentFlow = navigationContext.getCurrentFlow(facesContext);
            FlowCallNode targetFlowCallNode = null;
            boolean startFlow = false;
            String startFlowDocumentId = null;
            String startFlowId = null;
            boolean checkFlowNode = false;
            String outcomeToGo = outcome;
            String actionToGo = fromAction;
            if (currentFlow != null) {
                if (targetFlow != null) {
                    if (flowHandler.isActive(facesContext, targetFlow.getDefiningDocumentId(), targetFlow.getId())) {
                        FlowNode flowNode = targetFlow.getNode(outcome);
                        if (flowNode != null) {
                            checkFlowNode = true;
                        } else {
                            startFlow = true;
                        }
                    } else {
                        startFlow = true;
                    }
                } else {
                    checkFlowNode = true;
                }
            } else if (targetFlow != null) {
                startFlow = true;
            }
            if (!startFlow) {
                for (Flow activeFlow : activeFlows) {
                    FlowNode node = activeFlow.getNode(outcome);
                    if (node != null) {
                        currentFlow = activeFlow;
                        break;
                    }
                    flowNavigationStructure = this._flowNavigationStructureMap.get(activeFlow.getId());
                    navigationCase = this.getNavigationCaseFromFlowStructure(facesContext, flowNavigationStructure, fromAction, outcome, viewId);
                    if (navigationCase == null) continue;
                    currentFlow = activeFlow;
                    break;
                }
            }
            if (startFlow || checkFlowNode && currentFlow != null) {
                boolean complete = false;
                boolean checkNavCase = true;
                while (!complete && (startFlow || checkFlowNode)) {
                    if (startFlow) {
                        if (flowHandler.isActive(facesContext, targetFlow.getDefiningDocumentId(), targetFlow.getId()) && targetFlowCallNode == null) {
                            Flow baseReturnFlow = navigationContext.getCurrentFlow(facesContext);
                            while (!(baseReturnFlow == null || baseReturnFlow.getDefiningDocumentId().equals(targetFlow.getDefiningDocumentId()) && baseReturnFlow.getId().equals(targetFlow.getId()))) {
                                navigationContext.popFlow(facesContext);
                                baseReturnFlow = navigationContext.getCurrentFlow(facesContext);
                            }
                            navigationContext.popFlow(facesContext);
                            currentFlow = navigationContext.getCurrentFlow(facesContext);
                            navigationContext.addTargetFlow(baseReturnFlow, currentFlow, null);
                        }
                        if (startFlowId == null) {
                            startFlowDocumentId = targetFlow.getDefiningDocumentId();
                            startFlowId = targetFlowCallNode == null ? targetFlow.getId() : targetFlowCallNode.getId();
                        }
                        navigationContext.addTargetFlow(currentFlow, targetFlow, targetFlowCallNode);
                        targetFlowCallNode = null;
                        navigationContext.pushFlow(facesContext, targetFlow);
                        currentFlow = targetFlow;
                        outcomeToGo = this.resolveStartNodeOutcome(targetFlow);
                        checkFlowNode = true;
                        startFlow = false;
                    }
                    if (!checkFlowNode) continue;
                    FlowNode flowNode = currentFlow.getNode(outcomeToGo);
                    if (flowNode != null) {
                        checkNavCase = true;
                        if (!complete && flowNode instanceof SwitchNode) {
                            outcomeToGo = this.calculateSwitchOutcome(facesContext, (SwitchNode)flowNode);
                            actionToGo = currentFlow.getId();
                            flowNode = currentFlow.getNode(outcomeToGo);
                            continue;
                        }
                        if (!complete && flowNode instanceof FlowCallNode) {
                            FlowCallNode flowCallNode = (FlowCallNode)flowNode;
                            targetFlow = this.calculateFlowCallTargetFlow(facesContext, flowHandler, flowCallNode, currentFlow);
                            if (targetFlow != null) {
                                targetFlowCallNode = flowCallNode;
                                startFlow = true;
                                continue;
                            }
                            complete = true;
                        }
                        if (!complete && flowNode instanceof MethodCallNode) {
                            MethodCallNode methodCallNode = (MethodCallNode)flowNode;
                            String vdlViewIdentifier = this.calculateVdlViewIdentifier(facesContext, methodCallNode);
                            if (vdlViewIdentifier != null) {
                                outcomeToGo = vdlViewIdentifier;
                                actionToGo = currentFlow.getId();
                                continue;
                            }
                            complete = true;
                        }
                        if (!complete && flowNode instanceof ReturnNode) {
                            ReturnNode returnNode = (ReturnNode)flowNode;
                            String fromOutcome = returnNode.getFromOutcome(facesContext);
                            actionToGo = currentFlow.getId();
                            Flow sourceFlow = currentFlow;
                            Flow baseReturnFlow = navigationContext.getCurrentFlow(facesContext);
                            while (!(baseReturnFlow == null || baseReturnFlow.getDefiningDocumentId().equals(currentFlow.getDefiningDocumentId()) && baseReturnFlow.getId().equals(currentFlow.getId()))) {
                                navigationContext.popFlow(facesContext);
                                baseReturnFlow = navigationContext.getCurrentFlow(facesContext);
                            }
                            navigationContext.popFlow(facesContext);
                            currentFlow = navigationContext.getCurrentFlow(facesContext);
                            navigationContext.addTargetFlow(sourceFlow, currentFlow, null);
                            outcomeToGo = fromOutcome;
                            String lastDisplayedViewId = navigationContext.getLastDisplayedViewId(facesContext, currentFlow);
                            navigationCase = this.getNavigationCommand(facesContext, navigationContext, actionToGo, outcomeToGo, "javax.faces.flow.NullFlow");
                            if (navigationCase != null) {
                                navigationCase = new FlowNavigationCase((NavigationCase)navigationCase, flowNode.getId(), "javax.faces.flow.NullFlow");
                                complete = true;
                            } else if (lastDisplayedViewId != null) {
                                navigationCase = this.createNavigationCase(viewId, flowNode.getId(), lastDisplayedViewId, "javax.faces.flow.NullFlow");
                                complete = true;
                            }
                            if (currentFlow != null) continue;
                            complete = true;
                            continue;
                        }
                        if (!complete && flowNode instanceof ViewNode) {
                            ViewNode viewNode = (ViewNode)flowNode;
                            navigationCase = this.createNavigationCase(viewId, flowNode.getId(), viewNode.getVdlDocumentId());
                            complete = true;
                            continue;
                        }
                        complete = true;
                        continue;
                    }
                    if (checkNavCase) {
                        flowNavigationStructure = this._flowNavigationStructureMap.get(currentFlow.getId());
                        navigationCase = this.getNavigationCaseFromFlowStructure(facesContext, flowNavigationStructure, actionToGo, outcomeToGo, viewId);
                        if (navigationCase != null) {
                            outcomeToGo = navigationCase.getToViewId(facesContext);
                            checkNavCase = false;
                            continue;
                        }
                        complete = true;
                        continue;
                    }
                    complete = true;
                }
                if (outcomeToGo != null && navigationCase == null) {
                    navigationCase = this.getOutcomeNavigationCase(facesContext, actionToGo, outcomeToGo);
                }
            }
            if (startFlowId != null) {
                navigationCase = new FlowNavigationCase((NavigationCase)navigationCase, startFlowId, startFlowDocumentId);
            }
        }
        if (outcome != null && navigationCase == null) {
            navigationCase = this.getOutcomeNavigationCase(facesContext, fromAction, outcome);
        }
        if (outcome != null && navigationCase == null && !facesContext.isProjectStage(ProjectStage.Production)) {
            FacesMessage facesMessage = new FacesMessage("No navigation case match for viewId " + viewId + ",  action " + fromAction + " and outcome " + outcome);
            facesMessage.setSeverity(FacesMessage.SEVERITY_WARN);
            facesContext.addMessage(null, facesMessage);
        }
        if (navigationCase != null) {
            navigationContext.setNavigationCase((NavigationCase)navigationCase);
        }
        return navigationContext.getNavigationCase();
    }

    private String resolveStartNodeOutcome(Flow targetFlow) {
        String outcomeToGo = targetFlow.getStartNodeId() == null ? '/' + targetFlow.getId() + '/' + targetFlow.getId() + ".xhtml" : targetFlow.getStartNodeId();
        return outcomeToGo;
    }

    private String calculateSwitchOutcome(FacesContext facesContext, SwitchNode switchNode) {
        String outcomeToGo = null;
        boolean resolved = false;
        for (SwitchCase switchCase : switchNode.getCases()) {
            Boolean isConditionTrue = switchCase.getCondition(facesContext);
            if (!Boolean.TRUE.equals(isConditionTrue)) continue;
            outcomeToGo = switchCase.getFromOutcome();
            resolved = true;
            break;
        }
        if (!resolved) {
            outcomeToGo = switchNode.getDefaultOutcome(facesContext);
        }
        return outcomeToGo;
    }

    private Flow calculateFlowCallTargetFlow(FacesContext facesContext, FlowHandler flowHandler, FlowCallNode flowCallNode, Flow currentFlow) {
        Flow targetFlow;
        String calledFlowDocumentId = flowCallNode.getCalledFlowDocumentId(facesContext);
        if (calledFlowDocumentId == null) {
            calledFlowDocumentId = currentFlow.getDefiningDocumentId();
        }
        if ((targetFlow = flowHandler.getFlow(facesContext, calledFlowDocumentId, flowCallNode.getCalledFlowId(facesContext))) == null && StringUtils.isNotBlank(calledFlowDocumentId)) {
            targetFlow = flowHandler.getFlow(facesContext, "", flowCallNode.getCalledFlowId(facesContext));
        }
        return targetFlow;
    }

    private String calculateVdlViewIdentifier(FacesContext facesContext, MethodCallNode methodCallNode) {
        String vdlViewIdentifier = null;
        MethodExpression method = methodCallNode.getMethodExpression();
        if (method != null) {
            Object value = this.invokeMethodCallNode(facesContext, methodCallNode);
            if (value != null) {
                vdlViewIdentifier = value.toString();
            } else if (methodCallNode.getOutcome() != null) {
                vdlViewIdentifier = (String)methodCallNode.getOutcome().getValue(facesContext.getELContext());
            }
        }
        return vdlViewIdentifier;
    }

    private Object invokeMethodCallNode(FacesContext facesContext, MethodCallNode methodCallNode) {
        MethodExpression method = methodCallNode.getMethodExpression();
        Object value = null;
        if (methodCallNode.getParameters() != null && !methodCallNode.getParameters().isEmpty()) {
            Object[] parameters = new Object[methodCallNode.getParameters().size()];
            Class[] clazzes = new Class[methodCallNode.getParameters().size()];
            for (int i = 0; i < methodCallNode.getParameters().size(); ++i) {
                Parameter param = (Parameter)methodCallNode.getParameters().get(i);
                parameters[i] = param.getValue().getValue(facesContext.getELContext());
                clazzes[i] = param.getName() != null ? ClassUtils.simpleJavaTypeToClass((String)param.getName()) : (parameters[i] == null ? String.class : parameters[i].getClass());
            }
            method = facesContext.getApplication().getExpressionFactory().createMethodExpression(facesContext.getELContext(), method.getExpressionString(), null, clazzes);
            value = method.invoke(facesContext.getELContext(), parameters);
        } else {
            value = method.invoke(facesContext.getELContext(), null);
        }
        return value;
    }

    private NavigationCase getNavigationCaseFromFlowStructure(FacesContext facesContext, _FlowNavigationStructure flowNavigationStructure, String fromAction, String outcome, String viewId) {
        Set<NavigationCase> casesSet = null;
        NavigationCase navigationCase = null;
        if (flowNavigationStructure == null) {
            return navigationCase;
        }
        if (viewId != null && (casesSet = flowNavigationStructure.getNavigationCases().get(viewId)) != null) {
            navigationCase = this.calcMatchingNavigationCase(facesContext, casesSet, fromAction, outcome);
        }
        if (navigationCase == null) {
            _WildcardPattern wildcardPattern;
            List<_WildcardPattern> wildcardPatterns = flowNavigationStructure.getWildcardKeys();
            for (int i = 0; !(i >= wildcardPatterns.size() || (wildcardPattern = wildcardPatterns.get(i)).match(viewId) && (casesSet = flowNavigationStructure.getNavigationCases().get(wildcardPattern.getPattern())) != null && (navigationCase = this.calcMatchingNavigationCase(facesContext, casesSet, fromAction, outcome)) != null); ++i) {
            }
        }
        return navigationCase;
    }

    private NavigationCase createNavigationCase(String fromViewId, String outcome, String toViewId) {
        return new NavigationCase(fromViewId, null, outcome, null, toViewId, null, false, false);
    }

    private NavigationCase createNavigationCase(String fromViewId, String outcome, String toViewId, String toFlowDocumentId) {
        return new NavigationCase(fromViewId, null, outcome, null, toViewId, toFlowDocumentId, null, false, false);
    }

    private NavigationCase getOutcomeNavigationCase(FacesContext facesContext, String fromAction, String outcome) {
        String implicitViewId = null;
        boolean includeViewParams = false;
        boolean isRedirect = false;
        String queryString = null;
        NavigationCase result = null;
        String viewId = facesContext.getViewRoot() != null ? facesContext.getViewRoot().getViewId() : null;
        StringBuilder viewIdToTest = SharedStringBuilder.get(facesContext, OUTCOME_NAVIGATION_SB);
        viewIdToTest.append(outcome);
        int index = viewIdToTest.indexOf("?");
        if (index != -1) {
            queryString = viewIdToTest.substring(index + 1);
            viewIdToTest.setLength(index);
            if (queryString.contains("faces-redirect=true")) {
                isRedirect = true;
            }
            if (queryString.contains("includeViewParams=true") || queryString.contains("faces-include-view-params=true")) {
                includeViewParams = true;
            }
        }
        if ((index = viewIdToTest.indexOf(".")) == -1) {
            if (viewId != null) {
                index = viewId.lastIndexOf(46);
                if (index != -1) {
                    viewIdToTest.append(viewId.substring(index));
                }
            } else {
                String tempViewId = this.getViewIdSupport().calculateViewId(facesContext);
                if (tempViewId != null && (index = tempViewId.lastIndexOf(46)) != -1) {
                    viewIdToTest.append(tempViewId.substring(index));
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("getOutcomeNavigationCase -> viewIdToTest: " + viewIdToTest);
            }
        }
        boolean startWithSlash = false;
        if (viewIdToTest.length() > 0) {
            boolean bl = startWithSlash = viewIdToTest.charAt(0) == '/';
        }
        if (!startWithSlash) {
            index = -1;
            if (viewId != null) {
                index = viewId.lastIndexOf(47);
            }
            if (index == -1) {
                viewIdToTest.insert(0, '/');
            } else {
                viewIdToTest.insert(0, viewId, 0, index + 1);
            }
        }
        String viewIdToTestString = null;
        boolean applyNormalization = false;
        for (int i = 0; i < viewIdToTest.length() - 1; ++i) {
            if (viewIdToTest.charAt(i) != '.' || viewIdToTest.charAt(i + 1) != '/') continue;
            applyNormalization = true;
            break;
        }
        viewIdToTestString = applyNormalization ? FilenameUtils.normalize(viewIdToTest.toString(), true) : viewIdToTest.toString();
        implicitViewId = facesContext.getApplication().getViewHandler().deriveViewId(facesContext, viewIdToTestString);
        if (implicitViewId != null) {
            HashMap<String, ArrayList<String>> params = null;
            if (StringUtils.isNotBlank(queryString)) {
                String[] splitQueryParams = AMP_PATTERN.split(queryString);
                params = new HashMap<String, ArrayList<String>>(splitQueryParams.length, 1.0f);
                for (String queryParam : splitQueryParams) {
                    String[] splitParam = StringUtils.splitShortString(queryParam, '=');
                    if (splitParam.length == 2) {
                        if ("includeViewParams".equals(splitParam[0]) || "faces-include-view-params".equals(splitParam[0]) || "faces-redirect".equals(splitParam[0])) continue;
                        ArrayList<String> paramValues = (ArrayList<String>)params.get(splitParam[0]);
                        if (paramValues == null) {
                            paramValues = new ArrayList<String>(5);
                            params.put(splitParam[0], paramValues);
                        }
                        paramValues.add(splitParam[1]);
                        continue;
                    }
                    throw new FacesException("Invalid parameter \"" + queryParam + "\" in outcome " + outcome);
                }
            }
            result = new NavigationCase(viewId, fromAction, outcome, null, implicitViewId, params, isRedirect, includeViewParams);
        }
        return result;
    }

    public String getViewId(FacesContext context, String fromAction, String outcome) {
        return this.getNavigationCase(context, fromAction, outcome).getToViewId(context);
    }

    /*
     * Enabled aggressive block sorting
     */
    private NavigationCase calcMatchingNavigationCase(FacesContext context, Set<? extends NavigationCase> casesList, String actionRef, String outcome) {
        NavigationCase noConditionCase = null;
        NavigationCase firstCase = null;
        NavigationCase firstCaseIf = null;
        NavigationCase secondCase = null;
        NavigationCase secondCaseIf = null;
        NavigationCase thirdCase = null;
        NavigationCase thirdCaseIf = null;
        NavigationCase fourthCase = null;
        NavigationCase fourthCaseIf = null;
        for (NavigationCase navigationCase : casesList) {
            boolean ifMatches;
            Boolean cazeIf;
            block19: {
                String cazeOutcome;
                block18: {
                    cazeOutcome = navigationCase.getFromOutcome();
                    String cazeActionRef = navigationCase.getFromAction();
                    cazeIf = navigationCase.getCondition(context);
                    boolean bl = ifMatches = cazeIf == null ? false : cazeIf;
                    if (outcome == null && (cazeOutcome != null || cazeIf == null) && actionRef == null) continue;
                    if (cazeOutcome == null && cazeActionRef == null && cazeIf == null && noConditionCase == null && outcome != null) {
                        noConditionCase = navigationCase;
                    }
                    if (cazeActionRef == null) break block18;
                    if (cazeOutcome != null) {
                        if (actionRef != null && outcome != null && cazeActionRef.equals(actionRef) && cazeOutcome.equals(outcome)) {
                            if (cazeIf != null) {
                                if (!ifMatches) continue;
                                firstCaseIf = navigationCase;
                                continue;
                            }
                            firstCase = navigationCase;
                        }
                        break block19;
                    } else {
                        if (actionRef == null || !cazeActionRef.equals(actionRef)) continue;
                        if (cazeIf != null) {
                            if (!ifMatches) continue;
                            thirdCaseIf = navigationCase;
                            continue;
                        }
                        if (outcome == null) continue;
                        thirdCase = navigationCase;
                        continue;
                    }
                }
                if (cazeOutcome != null && outcome != null && cazeOutcome.equals(outcome)) {
                    if (cazeIf != null) {
                        if (!ifMatches) continue;
                        secondCaseIf = navigationCase;
                        continue;
                    }
                    secondCase = navigationCase;
                }
            }
            if (outcome != null && cazeIf != null) {
                if (!ifMatches) continue;
                fourthCaseIf = navigationCase;
                continue;
            }
            if (cazeIf == null || !ifMatches) continue;
            fourthCase = navigationCase;
        }
        if (firstCaseIf != null) {
            return firstCaseIf;
        }
        if (firstCase != null) {
            return firstCase;
        }
        if (secondCaseIf != null) {
            return secondCaseIf;
        }
        if (secondCase != null) {
            return secondCase;
        }
        if (thirdCaseIf != null) {
            return thirdCaseIf;
        }
        if (thirdCase != null) {
            return thirdCase;
        }
        if (fourthCaseIf != null) {
            return fourthCaseIf;
        }
        if (fourthCase != null) {
            return fourthCase;
        }
        return noConditionCase;
    }

    private List<_WildcardPattern> getSortedWildcardPatterns() {
        return this._wildcardPatterns;
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        if (this._developmentStage == null) {
            this._developmentStage = FacesContext.getCurrentInstance().isProjectStage(ProjectStage.Development);
        }
        if (!Boolean.TRUE.equals(this._developmentStage)) {
            if (this._navigationCases == null) {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                ExternalContext externalContext = facesContext.getExternalContext();
                RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(externalContext);
                this.calculateNavigationCases(runtimeConfig);
            }
            return this._navigationCases;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(externalContext);
        if (this._navigationCases == null || runtimeConfig.isNavigationRulesChanged()) {
            this.calculateNavigationCases(runtimeConfig);
        }
        return this._navigationCases;
    }

    public void inspectFlow(FacesContext context, Flow flow) {
        Map rules = flow.getNavigationCases();
        int rulesSize = rules.size();
        HashMap<String, Set<NavigationCase>> cases = new HashMap<String, Set<NavigationCase>>(HashMapUtils.calcCapacity(rulesSize));
        ArrayList<_WildcardPattern> wildcardPatterns = new ArrayList<_WildcardPattern>();
        for (Map.Entry entry : rules.entrySet()) {
            String fromViewId = (String)entry.getKey();
            fromViewId = fromViewId == null ? ASTERISK : fromViewId.trim();
            HashSet set = (HashSet)cases.get(fromViewId);
            if (set == null) {
                set = new HashSet((Collection)entry.getValue());
                cases.put(fromViewId, set);
                if (!fromViewId.endsWith(ASTERISK)) continue;
                wildcardPatterns.add(new _WildcardPattern(fromViewId));
                continue;
            }
            set.addAll((Collection)entry.getValue());
        }
        Collections.sort(wildcardPatterns, KeyComparator.INSTANCE);
        this._flowNavigationStructureMap.put(flow.getId(), new _FlowNavigationStructure(flow.getDefiningDocumentId(), flow.getId(), cases, wildcardPatterns));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void calculateNavigationCases(RuntimeConfig runtimeConfig) {
        if (this._navigationCases == null || runtimeConfig.isNavigationRulesChanged()) {
            Collection<NavigationRule> rules = runtimeConfig.getNavigationRules();
            int rulesSize = rules.size();
            HashMap<String, Set<NavigationCase>> cases = new HashMap<String, Set<NavigationCase>>(HashMapUtils.calcCapacity(rulesSize));
            ArrayList<_WildcardPattern> wildcardPatterns = new ArrayList<_WildcardPattern>();
            for (NavigationRule rule : rules) {
                String fromViewId = rule.getFromViewId();
                fromViewId = fromViewId == null ? ASTERISK : fromViewId.trim();
                HashSet<NavigationCase> set = (HashSet<NavigationCase>)cases.get(fromViewId);
                if (set == null) {
                    set = new HashSet<NavigationCase>(this.convertNavigationCasesToAPI(rule));
                    cases.put(fromViewId, set);
                    if (!fromViewId.endsWith(ASTERISK)) continue;
                    wildcardPatterns.add(new _WildcardPattern(fromViewId));
                    continue;
                }
                set.addAll(this.convertNavigationCasesToAPI(rule));
            }
            Collections.sort(wildcardPatterns, KeyComparator.INSTANCE);
            HashMap<String, Set<NavigationCase>> hashMap = cases;
            synchronized (hashMap) {
                this._navigationCases = cases;
                this._wildcardPatterns = wildcardPatterns;
                runtimeConfig.setNavigationRulesChanged(false);
            }
        }
    }

    private Set<NavigationCase> convertNavigationCasesToAPI(NavigationRule rule) {
        List<? extends org.apache.myfaces.config.element.NavigationCase> configCases = rule.getNavigationCases();
        HashSet<NavigationCase> apiCases = new HashSet<NavigationCase>(configCases.size());
        for (org.apache.myfaces.config.element.NavigationCase navigationCase : configCases) {
            if (navigationCase.getRedirect() != null) {
                String includeViewParamsAttribute = navigationCase.getRedirect().getIncludeViewParams();
                boolean includeViewParams = false;
                if (includeViewParamsAttribute != null) {
                    includeViewParams = Boolean.valueOf(includeViewParamsAttribute);
                }
                apiCases.add(new NavigationCase(rule.getFromViewId(), navigationCase.getFromAction(), navigationCase.getFromOutcome(), navigationCase.getIf(), navigationCase.getToViewId(), navigationCase.getRedirect().getViewParams(), true, includeViewParams));
                continue;
            }
            apiCases.add(new NavigationCase(rule.getFromViewId(), navigationCase.getFromAction(), navigationCase.getFromOutcome(), navigationCase.getIf(), navigationCase.getToViewId(), null, false, false));
        }
        return apiCases;
    }

    protected static class NavigationContext {
        private NavigationCase navigationCase;
        private List<Flow> sourceFlows;
        private List<Flow> targetFlows;
        private List<FlowCallNode> targetFlowCallNodes;
        private List<Flow> currentFlows;
        private int returnCount = 0;

        public NavigationContext() {
        }

        public NavigationContext(NavigationCase navigationCase) {
            this.navigationCase = navigationCase;
        }

        public NavigationCase getNavigationCase() {
            return this.navigationCase;
        }

        public void setNavigationCase(NavigationCase navigationCase) {
            this.navigationCase = navigationCase;
        }

        public List<Flow> getSourceFlows() {
            return this.sourceFlows;
        }

        public List<Flow> getTargetFlows() {
            return this.targetFlows;
        }

        public List<FlowCallNode> getFlowCallNodes() {
            return this.targetFlowCallNodes;
        }

        public void addTargetFlow(Flow sourceFlow, Flow targetFlow, FlowCallNode flowCallNode) {
            if (this.targetFlows == null) {
                this.sourceFlows = new ArrayList<Flow>(4);
                this.targetFlows = new ArrayList<Flow>(4);
                this.targetFlowCallNodes = new ArrayList<FlowCallNode>(4);
            }
            this.sourceFlows.add(sourceFlow);
            this.targetFlows.add(targetFlow);
            this.targetFlowCallNodes.add(flowCallNode);
        }

        public Flow getCurrentFlow(FacesContext facesContext) {
            if (this.currentFlows != null && !this.currentFlows.isEmpty()) {
                return this.currentFlows.get(this.currentFlows.size() - 1);
            }
            FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
            return flowHandler.getCurrentFlow(facesContext);
        }

        public void finish(FacesContext facesContext) {
            for (int i = 0; i < this.returnCount; ++i) {
                FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
                flowHandler.popReturnMode(facesContext);
            }
            this.returnCount = 0;
        }

        public void popFlow(FacesContext facesContext) {
            if (this.currentFlows != null && !this.currentFlows.isEmpty()) {
                this.currentFlows.remove(this.currentFlows.size() - 1);
            } else {
                FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
                flowHandler.pushReturnMode(facesContext);
                ++this.returnCount;
            }
        }

        public void pushFlow(FacesContext facesContext, Flow flow) {
            if (this.currentFlows == null) {
                this.currentFlows = new ArrayList<Flow>();
            }
            this.currentFlows.add(flow);
        }

        public String getLastDisplayedViewId(FacesContext facesContext, Flow flow) {
            FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
            return flowHandler.getLastDisplayedViewId(facesContext);
        }
    }

    private static final class KeyComparator
    implements Comparator<_WildcardPattern> {
        private static final KeyComparator INSTANCE = new KeyComparator();

        private KeyComparator() {
        }

        @Override
        public int compare(_WildcardPattern s1, _WildcardPattern s2) {
            return -s1.getPattern().compareTo(s2.getPattern());
        }
    }

    private static class PreDisposeViewCallback
    implements VisitCallback {
        public static final PreDisposeViewCallback INSTANCE = new PreDisposeViewCallback();

        private PreDisposeViewCallback() {
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            context.getFacesContext().getApplication().publishEvent(context.getFacesContext(), PreDisposeViewEvent.class, (Object)target);
            return VisitResult.ACCEPT;
        }
    }
}

