/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag;

import java.util.ArrayList;
import javax.faces.view.facelets.CompositeFaceletHandler;
import javax.faces.view.facelets.FaceletHandler;

public final class TagHandlerUtils {
    public static <T> T findFirstNextByType(FaceletHandler nextHandler, Class<T> type) {
        if (type.isAssignableFrom(nextHandler.getClass())) {
            return (T)nextHandler;
        }
        if (nextHandler instanceof CompositeFaceletHandler) {
            for (FaceletHandler handler : ((CompositeFaceletHandler)nextHandler).getHandlers()) {
                if (!type.isAssignableFrom(handler.getClass())) continue;
                return (T)handler;
            }
        }
        return null;
    }

    public static <T> ArrayList<T> findNextByType(FaceletHandler nextHandler, Class<T> type) {
        ArrayList<FaceletHandler> found = new ArrayList<FaceletHandler>();
        if (type.isAssignableFrom(nextHandler.getClass())) {
            found.add(nextHandler);
        } else if (nextHandler instanceof CompositeFaceletHandler) {
            for (FaceletHandler handler : ((CompositeFaceletHandler)nextHandler).getHandlers()) {
                if (!type.isAssignableFrom(handler.getClass())) continue;
                found.add(handler);
            }
        }
        return found;
    }

    private TagHandlerUtils() {
    }

    public static ArrayList<FaceletHandler> findNextByType(FaceletHandler nextHandler, Class<?> ... type1) {
        ArrayList<FaceletHandler> found = new ArrayList<FaceletHandler>();
        boolean isAssignable = false;
        for (int i = 0; i < type1.length && !isAssignable; ++i) {
            isAssignable = type1[i].isAssignableFrom(nextHandler.getClass());
        }
        if (isAssignable) {
            found.add(nextHandler);
        } else if (nextHandler instanceof CompositeFaceletHandler) {
            for (FaceletHandler handler : ((CompositeFaceletHandler)nextHandler).getHandlers()) {
                isAssignable = false;
                for (int i = 0; i < type1.length && !isAssignable; ++i) {
                    isAssignable = type1[i].isAssignableFrom(handler.getClass());
                }
                if (!isAssignable) continue;
                found.add(handler);
            }
        }
        return found;
    }

    public static ArrayList<FaceletHandler> findNextByType(FaceletHandler nextHandler, Class<?> type1, Class<?> type2) {
        ArrayList<FaceletHandler> found = new ArrayList<FaceletHandler>();
        if (type1.isAssignableFrom(nextHandler.getClass()) || type2.isAssignableFrom(nextHandler.getClass())) {
            found.add(nextHandler);
        } else if (nextHandler instanceof CompositeFaceletHandler) {
            for (FaceletHandler handler : ((CompositeFaceletHandler)nextHandler).getHandlers()) {
                if (!type1.isAssignableFrom(handler.getClass()) && !type2.isAssignableFrom(handler.getClass())) continue;
                found.add(handler);
            }
        }
        return found;
    }
}

