/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.util;

import java.util.ArrayList;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.util.lang.StringUtils;

public class FaceletsViewDeclarationLanguageUtils {
    public static Class getReturnType(String signature) {
        int endName = signature.indexOf(40);
        if (endName < 0) {
            throw new FacesException("Invalid method signature:" + signature);
        }
        int end = signature.lastIndexOf(32, endName);
        if (end < 0) {
            throw new FacesException("Invalid method signature:" + signature);
        }
        try {
            return ClassUtils.javaDefaultTypeToClass(signature.substring(0, end));
        }
        catch (ClassNotFoundException e) {
            throw new FacesException("Invalid method signature:" + signature);
        }
    }

    public static Class[] getParameters(String signature) throws FacesException {
        ArrayList<Class> params = new ArrayList<Class>();
        int start = signature.indexOf(40) + 1;
        boolean lastArg = false;
        while (true) {
            String arg;
            int p;
            if ((p = signature.indexOf(44, start)) < 0) {
                p = signature.indexOf(41, start);
                if (p < 0) {
                    throw new FacesException("Invalid method signature:" + signature);
                }
                lastArg = true;
            }
            if (StringUtils.isNotBlank(arg = signature.substring(start, p))) {
                try {
                    params.add(ClassUtils.javaDefaultTypeToClass(arg.trim()));
                }
                catch (ClassNotFoundException e) {
                    throw new FacesException("Invalid method signature:" + signature);
                }
            }
            if (lastArg) break;
            start = p + 1;
        }
        return params.toArray(new Class[params.size()]);
    }

    public static void markRenderedResources(FacesContext facesContext, UIViewRoot view) {
        if (view != null && facesContext.getPartialViewContext().isAjaxRequest()) {
            FaceletsViewDeclarationLanguageUtils.markRenderedResources(facesContext, view, view.getComponentResources(facesContext, "head"));
            FaceletsViewDeclarationLanguageUtils.markRenderedResources(facesContext, view, view.getComponentResources(facesContext, "body"));
        }
    }

    private static void markRenderedResources(FacesContext facesContext, UIViewRoot view, List<UIComponent> componentResources) {
        if (componentResources != null) {
            for (UIComponent component : componentResources) {
                if (!"javax.faces.resource.Script".equals(component.getRendererType()) && !"javax.faces.resource.Stylesheet".equals(component.getRendererType())) continue;
                String resourceName = (String)component.getAttributes().get("name");
                String libraryName = (String)component.getAttributes().get("library");
                if (resourceName == null || resourceName.isEmpty()) continue;
                int index = resourceName.indexOf(63);
                if (index >= 0) {
                    resourceName = resourceName.substring(0, index);
                }
                facesContext.getApplication().getResourceHandler().markResourceRendered(facesContext, resourceName, libraryName);
            }
        }
    }
}

