/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application.viewstate.token;

import java.io.UnsupportedEncodingException;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.apache.myfaces.application.viewstate.token.StateTokenProcessor;
import org.apache.myfaces.shared.util.StateUtils;

public class ServiceSideStateTokenProcessor
extends StateTokenProcessor {
    @Override
    public Object decode(FacesContext facesContext, String token) {
        if ("stateless".equals(token)) {
            return null;
        }
        try {
            byte[] tokenBytes = token.getBytes("ISO-8859-1");
            byte[] tokenBytesDecoded = StateUtils.decode(tokenBytes);
            String tokenDecoded = new String(tokenBytesDecoded, "ISO-8859-1");
            return tokenDecoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new FacesException(e);
        }
    }

    @Override
    public String encode(FacesContext facesContext, Object savedStateObject) {
        if (facesContext.getViewRoot().isTransient()) {
            return "stateless";
        }
        try {
            String token = (String)savedStateObject;
            byte[] tokenBytes = token.getBytes("ISO-8859-1");
            byte[] tokenBytesEncoded = StateUtils.encode(tokenBytes);
            String tokenEncoded = new String(tokenBytesEncoded, "ISO-8859-1");
            return tokenEncoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new FacesException(e);
        }
    }
}

