/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;

public final class TagAttributesImpl
extends TagAttributes {
    private static final TagAttribute[] EMPTY = new TagAttribute[0];
    private final TagAttribute[] attributes;
    private final String[] namespaces;
    private final HashMap<String, TagAttribute[]> namespaceAttributes;
    private final HashMap<String, Map<String, TagAttribute>> namespaceLocalNameAttributes;

    public TagAttributesImpl(TagAttribute[] attributes) {
        this.attributes = attributes;
        this.namespaceAttributes = new HashMap(1);
        this.namespaceLocalNameAttributes = new HashMap(1);
        HashSet<String> namespacesSet = new HashSet<String>();
        HashMap<String, ArrayList<TagAttribute>> namespaceAttributesAsList = new HashMap<String, ArrayList<TagAttribute>>();
        for (TagAttribute attribute : attributes) {
            namespacesSet.add(attribute.getNamespace());
            ArrayList<TagAttribute> tagAttributes = (ArrayList<TagAttribute>)namespaceAttributesAsList.get(attribute.getNamespace());
            if (tagAttributes == null) {
                tagAttributes = new ArrayList<TagAttribute>(attributes.length);
                namespaceAttributesAsList.put(attribute.getNamespace(), tagAttributes);
            }
            tagAttributes.add(attribute);
            Map<String, TagAttribute> localeNameAttributes = this.namespaceLocalNameAttributes.get(attribute.getNamespace());
            if (localeNameAttributes == null) {
                localeNameAttributes = new HashMap<String, TagAttribute>(attributes.length);
                this.namespaceLocalNameAttributes.put(attribute.getNamespace(), localeNameAttributes);
            }
            localeNameAttributes.put(attribute.getLocalName(), attribute);
        }
        this.namespaces = namespacesSet.toArray(new String[namespacesSet.size()]);
        Arrays.sort(this.namespaces);
        for (Map.Entry entry : namespaceAttributesAsList.entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            this.namespaceAttributes.put(key, value.toArray(new TagAttribute[value.size()]));
        }
    }

    @Override
    public TagAttribute[] getAll() {
        return this.attributes;
    }

    @Override
    public TagAttribute get(String localName) {
        return this.get("", localName);
    }

    @Override
    public TagAttribute get(String ns, String localName) {
        Map<String, TagAttribute> nsAttributes = this.namespaceLocalNameAttributes.get(ns);
        if (nsAttributes != null) {
            return nsAttributes.get(localName);
        }
        return null;
    }

    @Override
    public TagAttribute[] getAll(String namespace) {
        TagAttribute[] retVal = this.namespaceAttributes.get(namespace);
        return retVal == null ? EMPTY : retVal;
    }

    @Override
    public String[] getNamespaces() {
        return this.namespaces;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (TagAttribute attribute : this.attributes) {
            sb.append(attribute);
            sb.append(' ');
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

