/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.spi.FacesConfigurationMerger;
import org.apache.myfaces.spi.impl.DefaultFacesConfigurationMergerFactory;
import org.apache.myfaces.spi.impl.SpiUtils;

public abstract class FacesConfigurationMergerFactory {
    protected static final String FACTORY_DEFAULT = DefaultFacesConfigurationMergerFactory.class.getName();
    private static final String FACTORY_KEY = FacesConfigurationMergerFactory.class.getName();

    public static FacesConfigurationMergerFactory getFacesConfigurationMergerFactory(ExternalContext ctx) {
        FacesConfigurationMergerFactory factory = (FacesConfigurationMergerFactory)ctx.getApplicationMap().get(FACTORY_KEY);
        if (factory != null) {
            return factory;
        }
        try {
            if (System.getSecurityManager() != null) {
                final ExternalContext ectx = ctx;
                factory = (FacesConfigurationMergerFactory)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws PrivilegedActionException {
                        return SpiUtils.build(ectx, FacesConfigurationMergerFactory.class, FACTORY_DEFAULT);
                    }
                });
            } else {
                factory = (FacesConfigurationMergerFactory)SpiUtils.build(ctx, FacesConfigurationMergerFactory.class, FACTORY_DEFAULT);
            }
        }
        catch (PrivilegedActionException pae) {
            throw new FacesException(pae);
        }
        if (factory != null) {
            FacesConfigurationMergerFactory.setFacesConfigurationMergerFactory(ctx, factory);
        }
        return factory;
    }

    public static void setFacesConfigurationMergerFactory(ExternalContext ctx, FacesConfigurationMergerFactory factory) {
        ctx.getApplicationMap().put(FACTORY_KEY, factory);
    }

    public abstract FacesConfigurationMerger getFacesConfigurationMerger(ExternalContext var1);
}

