/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.myfaces.config.util.CyclicDependencyException;

public final class Vertex<T>
implements Comparable<Vertex<T>> {
    private final String m_name;
    private final T m_node;
    private int m_order;
    private boolean m_seen;
    private final List<Vertex<T>> m_dependencies;

    public Vertex(T node) {
        this(node.toString(), node);
    }

    public Vertex(String name, T node) {
        this.m_name = name;
        this.m_node = node;
        this.m_dependencies = new ArrayList<Vertex<T>>();
        this.reset();
    }

    public void reset() {
        this.m_order = 0;
        this.m_seen = false;
    }

    public String getName() {
        return this.m_name;
    }

    public T getNode() {
        return this.m_node;
    }

    public void addDependency(Vertex<T> v) {
        if (!this.m_dependencies.contains(v)) {
            this.m_dependencies.add(v);
        }
    }

    public void resolveOrder() throws CyclicDependencyException {
        this.resolveOrder(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int resolveOrder(String path) throws CyclicDependencyException {
        this.m_seen = true;
        try {
            int highOrder = -1;
            for (Vertex<T> dv : this.m_dependencies) {
                if (dv.m_seen) {
                    throw new CyclicDependencyException(path + " -> " + dv.getName());
                }
                highOrder = Math.max(highOrder, super.resolveOrder(path + " -> " + dv.getName()));
            }
            int n = this.m_order = highOrder + 1;
            return n;
        }
        finally {
            this.m_seen = false;
        }
    }

    public List<Vertex<T>> getDependencies() {
        return this.m_dependencies;
    }

    @Override
    public int compareTo(Vertex<T> o) {
        int orderInd = this.m_order < o.m_order ? -1 : (this.m_order > o.m_order ? 1 : 0);
        return orderInd;
    }

    public int getOrder() {
        return this.m_order;
    }
}

