/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.unified.resolver;

import com.google.inject.Injector;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.PropertyNotFoundException;
import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.el.unified.resolver.ManagedBeanResolver;

public class GuiceResolver
extends ManagedBeanResolver {
    public static final String KEY = "oam." + Injector.class.getName();

    @Override
    public Object getValue(ELContext ctx, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (base != null || !(property instanceof String)) {
            return null;
        }
        FacesContext fctx = (FacesContext)ctx.getContext(FacesContext.class);
        if (fctx == null) {
            return null;
        }
        ExternalContext ectx = fctx.getExternalContext();
        if (ectx == null || ectx.getRequestMap().containsKey(property) || ectx.getSessionMap().containsKey(property) || ectx.getApplicationMap().containsKey(property)) {
            return null;
        }
        ManagedBean managedBean = this.runtimeConfig(ctx).getManagedBean((String)property);
        return managedBean == null ? null : this.getValue(ctx, ectx, managedBean.getManagedBeanClass());
    }

    private Object getValue(ELContext ctx, ExternalContext ectx, Class<?> managedBeanClass) {
        Injector injector = (Injector)ectx.getApplicationMap().get(KEY);
        if (injector == null) {
            throw new FacesException("Could not find an instance of " + Injector.class.getName() + " in application scope using key '" + KEY + "'");
        }
        Object value = injector.getInstance(managedBeanClass);
        ctx.setPropertyResolved(true);
        return value;
    }
}

