/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import jakarta.el.ExpressionFactory;
import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import jakarta.servlet.ServletContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.webapp.AbstractFacesInitializer;

public class FaceletsInitilializer
extends AbstractFacesInitializer {
    private static final Logger log = Logger.getLogger(FaceletsInitilializer.class.getName());

    @Override
    protected void initContainerIntegration(ServletContext servletContext, ExternalContext externalContext) {
        ExpressionFactory expressionFactory = FaceletsInitilializer.getUserDefinedExpressionFactory(externalContext);
        if (expressionFactory == null) {
            String[] candidates;
            for (String candidate : candidates = new String[]{"org.apache.el.ExpressionFactoryImpl", "com.sun.el.ExpressionFactoryImpl", "de.odysseus.el.ExpressionFactoryImpl", "org.jboss.el.ExpressionFactoryImpl", "com.caucho.el.ExpressionFactoryImpl"}) {
                expressionFactory = FaceletsInitilializer.loadExpressionFactory(candidate, false);
                if (expressionFactory == null) continue;
                if (!log.isLoggable(Level.FINE)) break;
                log.fine("jakarta.el.ExpressionFactory implementation found: " + candidate);
                break;
            }
        }
        if (expressionFactory == null) {
            throw new FacesException("No jakarta.el.ExpressionFactory found. Please provide <context-param> in web.xml: org.apache.myfaces.EXPRESSION_FACTORY");
        }
        this.buildConfiguration(servletContext, externalContext, expressionFactory);
    }
}

