/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.util;

import jakarta.el.ValueExpression;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UISelectItem;
import jakarta.faces.component.UISelectItems;
import jakarta.faces.context.FacesContext;
import jakarta.faces.model.SelectItem;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.shared.util.DebugUtils;
import org.apache.myfaces.shared.util._EmptyIterator;

public class SelectItemsIterator
implements Iterator<SelectItem> {
    private static final Logger log = Logger.getLogger(SelectItemsIterator.class.getName());
    private static final String VAR_PROP = "var";
    private static final String ITEM_VALUE_PROP = "itemValue";
    private static final String ITEM_LABEL_PROP = "itemLabel";
    private static final String ITEM_DESCRIPTION_PROP = "itemDescription";
    private static final String ITEM_DISABLED_PROP = "itemDisabled";
    private static final String ITEM_LABEL_ESCAPED_PROP = "itemLabelEscaped";
    private static final String NO_SELECTION_VALUE_PROP = "noSelectionValue";
    private static final Iterator<UIComponent> _EMPTY_UICOMPONENT_ITERATOR = new _EmptyIterator<UIComponent>();
    private final Iterator<UIComponent> _children;
    private Iterator<? extends Object> _nestedItems;
    private SelectItem _nextItem;
    private UIComponent _currentComponent;
    private UISelectItems _currentUISelectItems;
    private Object _currentValue;
    private FacesContext _facesContext;

    public SelectItemsIterator(UIComponent selectItemsParent, FacesContext facesContext) {
        this._children = selectItemsParent.getChildCount() > 0 ? selectItemsParent.getChildren().iterator() : _EMPTY_UICOMPONENT_ITERATOR;
        this._facesContext = facesContext;
    }

    @Override
    public boolean hasNext() {
        if (this._nextItem != null) {
            return true;
        }
        if (this._nestedItems != null) {
            if (this._nestedItems.hasNext()) {
                return true;
            }
            this._nestedItems = null;
            this._currentComponent = null;
            this._currentValue = null;
        }
        if (this._children.hasNext()) {
            UIComponent child = this._children.next();
            while (!(child instanceof UISelectItem) && !(child instanceof UISelectItems)) {
                if (this._children.hasNext()) {
                    child = this._children.next();
                    continue;
                }
                return false;
            }
            if (child instanceof UISelectItem) {
                UISelectItem uiSelectItem = (UISelectItem)child;
                Object item = uiSelectItem.getValue();
                if (item == null) {
                    Object itemValue = uiSelectItem.getItemValue();
                    String label = uiSelectItem.getItemLabel();
                    String description = uiSelectItem.getItemDescription();
                    boolean disabled = uiSelectItem.isItemDisabled();
                    boolean escape = uiSelectItem.isItemEscaped();
                    boolean noSelectionOption = uiSelectItem.isNoSelectionOption();
                    if (label == null && itemValue != null) {
                        label = itemValue.toString();
                    }
                    item = new SelectItem(itemValue, label, description, disabled, escape, noSelectionOption);
                } else if (!(item instanceof SelectItem)) {
                    ValueExpression expression = uiSelectItem.getValueExpression("value");
                    throw new IllegalArgumentException("ValueExpression '" + (expression == null ? null : expression.getExpressionString()) + "' of UISelectItem : " + DebugUtils.getPathToComponent(child) + " does not reference an Object of type SelectItem");
                }
                this._nextItem = (SelectItem)item;
                this._currentComponent = child;
                this._currentValue = item;
                return true;
            }
            if (child instanceof UISelectItems) {
                this._currentUISelectItems = (UISelectItems)child;
                Object value = this._currentUISelectItems.getValue();
                this._currentComponent = child;
                if (value instanceof SelectItem) {
                    this._nextItem = (SelectItem)value;
                    return true;
                }
                if (value != null && value.getClass().isArray()) {
                    int length = Array.getLength(value);
                    ArrayList<Object> items = new ArrayList<Object>(length);
                    for (int i = 0; i < length; ++i) {
                        items.add(Array.get(value, i));
                    }
                    this._nestedItems = items.iterator();
                    return this.hasNext();
                }
                if (value instanceof Iterable) {
                    this._nestedItems = ((Iterable)value).iterator();
                    return this.hasNext();
                }
                if (value instanceof Map) {
                    Map map = (Map)value;
                    ArrayList<SelectItem> items = new ArrayList<SelectItem>(map.size());
                    for (Map.Entry entry : map.entrySet()) {
                        items.add(new SelectItem(entry.getValue(), entry.getKey().toString()));
                    }
                    this._nestedItems = items.iterator();
                    return this.hasNext();
                }
                Level level = Level.FINE;
                if (!this._facesContext.isProjectStage(ProjectStage.Production)) {
                    level = Level.WARNING;
                }
                if (log.isLoggable(level)) {
                    ValueExpression expression = this._currentUISelectItems.getValueExpression("value");
                    log.log(level, "ValueExpression {0} of UISelectItems with component-path {1} does not reference an Object of type SelectItem, array, Iterable or Map, but of type: {2}", new Object[]{expression == null ? null : expression.getExpressionString(), DebugUtils.getPathToComponent(child), value == null ? null : value.getClass().getName()});
                }
            } else {
                this._currentComponent = null;
                this._currentValue = null;
            }
        }
        return false;
    }

    @Override
    public SelectItem next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this._nextItem != null) {
            SelectItem value = this._nextItem;
            this._nextItem = null;
            return value;
        }
        if (this._nestedItems != null) {
            Object item = this._nestedItems.next();
            if (!(item instanceof SelectItem)) {
                Object itemDescription;
                Object itemLabel;
                Object itemValue;
                Map<String, Object> attributeMap = this._currentUISelectItems.getAttributes();
                this._currentValue = item;
                boolean wroteRequestMapVarValue = false;
                Object oldRequestMapVarValue = null;
                String var = (String)attributeMap.get(VAR_PROP);
                if (var != null && !"".equals(var)) {
                    oldRequestMapVarValue = this._facesContext.getExternalContext().getRequestMap().put(var, item);
                    wroteRequestMapVarValue = true;
                }
                if ((itemValue = attributeMap.get(ITEM_VALUE_PROP)) == null) {
                    itemValue = item;
                }
                if ((itemLabel = attributeMap.get(ITEM_LABEL_PROP)) == null) {
                    if (itemValue != null) {
                        itemLabel = itemValue.toString();
                    }
                } else {
                    itemLabel = itemLabel.toString();
                }
                if ((itemDescription = attributeMap.get(ITEM_DESCRIPTION_PROP)) != null) {
                    itemDescription = itemDescription.toString();
                }
                Boolean itemDisabled = this.getBooleanAttribute(this._currentUISelectItems, ITEM_DISABLED_PROP, false);
                Boolean itemLabelEscaped = this.getBooleanAttribute(this._currentUISelectItems, ITEM_LABEL_ESCAPED_PROP, true);
                Object noSelectionValue = attributeMap.get(NO_SELECTION_VALUE_PROP);
                item = new SelectItem(itemValue, (String)itemLabel, (String)itemDescription, itemDisabled, itemLabelEscaped, itemValue.equals(noSelectionValue));
                if (wroteRequestMapVarValue) {
                    if (oldRequestMapVarValue != null) {
                        this._facesContext.getExternalContext().getRequestMap().put(var, oldRequestMapVarValue);
                    } else {
                        this._facesContext.getExternalContext().getRequestMap().remove(var);
                    }
                }
            }
            return (SelectItem)item;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public UIComponent getCurrentComponent() {
        return this._currentComponent;
    }

    public Object getCurrentValue() {
        return this._currentValue;
    }

    private boolean getBooleanAttribute(UIComponent component, String attrName, boolean defaultValue) {
        Object value = component.getAttributes().get(attrName);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.valueOf(value.toString());
    }
}

