/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.util;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.PassivationCapable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.myfaces.cdi.util.ContextualInstanceInfo;

public class ContextualStorage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<Object, ContextualInstanceInfo<?>> contextualInstances;
    private final BeanManager beanManager;
    private final boolean concurrent;
    private final boolean passivationCapable;

    public ContextualStorage(BeanManager beanManager, boolean concurrent, boolean passivationCapable) {
        this.beanManager = beanManager;
        this.concurrent = concurrent;
        this.passivationCapable = passivationCapable;
        this.contextualInstances = concurrent ? new ConcurrentHashMap() : new HashMap();
    }

    public Map<Object, ContextualInstanceInfo<?>> getStorage() {
        return this.contextualInstances;
    }

    public boolean isConcurrent() {
        return this.concurrent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T createContextualInstance(Contextual<T> bean, CreationalContext<T> creationalContext) {
        Object beanKey = this.getBeanKey(bean);
        if (this.isConcurrent()) {
            ConcurrentHashMap concurrentMap = (ConcurrentHashMap)this.contextualInstances;
            ContextualInstanceInfo<T> instanceInfo = new ContextualInstanceInfo<T>();
            ContextualInstanceInfo oldInstanceInfo = concurrentMap.putIfAbsent(beanKey, instanceInfo);
            if (oldInstanceInfo != null) {
                instanceInfo = oldInstanceInfo;
            }
            ContextualInstanceInfo<T> contextualInstanceInfo = instanceInfo;
            synchronized (contextualInstanceInfo) {
                Object instance = instanceInfo.getContextualInstance();
                if (instance == null) {
                    instance = bean.create(creationalContext);
                    instanceInfo.setContextualInstance(instance);
                    instanceInfo.setCreationalContext(creationalContext);
                }
                return instance;
            }
        }
        ContextualInstanceInfo<Object> instanceInfo = new ContextualInstanceInfo<Object>();
        instanceInfo.setCreationalContext(creationalContext);
        instanceInfo.setContextualInstance(bean.create(creationalContext));
        this.contextualInstances.put(beanKey, instanceInfo);
        return instanceInfo.getContextualInstance();
    }

    public <T> Object getBeanKey(Contextual<T> bean) {
        if (this.passivationCapable) {
            return ((PassivationCapable)bean).getId();
        }
        return bean;
    }

    public Contextual<?> getBean(Object beanKey) {
        if (this.passivationCapable) {
            return this.beanManager.getPassivationCapableBean((String)beanKey);
        }
        return (Contextual)beanKey;
    }
}

