/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.resource;

import jakarta.faces.context.FacesContext;
import jakarta.faces.view.Location;
import java.util.regex.Pattern;

public class ResourceELUtils {
    public static final Pattern RESOURCE_EXPRESSION_REGEX = Pattern.compile(".*[^\\w\\.]resource[^\\w].*");
    private static final String RESOURCE = "resource";
    public static final String RESOURCE_LOCATION_KEY = "org.apache.myfaces.view.facelets.resource.location";
    public static final String RESOURCE_THIS_LIBRARY = "oam.resource.library";
    public static final String RESOURCE_THIS_CONTRACT = "oam.resource.contract";

    public static boolean isResourceExpression(String expression) {
        if (expression.contains(RESOURCE)) {
            return RESOURCE_EXPRESSION_REGEX.matcher(expression).matches();
        }
        return false;
    }

    public static Location getResourceLocationForResolver(FacesContext facesContext) {
        return (Location)facesContext.getAttributes().get(RESOURCE_LOCATION_KEY);
    }

    public static void saveResourceLocationForResolver(FacesContext facesContext, Location location) {
        facesContext.getAttributes().put(RESOURCE_LOCATION_KEY, location);
    }

    public static void removeResourceLocationForResolver(FacesContext facesContext) {
        facesContext.getAttributes().remove(RESOURCE_LOCATION_KEY);
    }

    public static String getResourceContractForResolver(FacesContext facesContext) {
        return (String)facesContext.getAttributes().get(RESOURCE_THIS_CONTRACT);
    }

    public static void saveResourceContractForResolver(FacesContext facesContext, String location) {
        facesContext.getAttributes().put(RESOURCE_THIS_CONTRACT, location);
    }

    public static void removeResourceContractForResolver(FacesContext facesContext) {
        facesContext.getAttributes().remove(RESOURCE_THIS_CONTRACT);
    }

    public static String getResourceLibraryForResolver(FacesContext facesContext) {
        return (String)facesContext.getAttributes().get(RESOURCE_THIS_LIBRARY);
    }

    public static void saveResourceLibraryForResolver(FacesContext facesContext, String location) {
        facesContext.getAttributes().put(RESOURCE_THIS_LIBRARY, location);
    }

    public static void removeResourceLibraryForResolver(FacesContext facesContext) {
        facesContext.getAttributes().remove(RESOURCE_THIS_LIBRARY);
    }
}

