/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi;

import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.myfaces.spi.ResourceLibraryContractsProvider;
import org.apache.myfaces.spi.impl.DefaultResourceLibraryContractsProviderFactory;
import org.apache.myfaces.spi.impl.SpiUtils;

public abstract class ResourceLibraryContractsProviderFactory {
    protected static final String FACTORY_DEFAULT = DefaultResourceLibraryContractsProviderFactory.class.getName();
    private static final String FACTORY_KEY = ResourceLibraryContractsProviderFactory.class.getName();

    public static ResourceLibraryContractsProviderFactory getFacesConfigResourceProviderFactory(ExternalContext ctx) {
        ResourceLibraryContractsProviderFactory instance = (ResourceLibraryContractsProviderFactory)ctx.getApplicationMap().get(FACTORY_KEY);
        if (instance != null) {
            return instance;
        }
        ResourceLibraryContractsProviderFactory lpf = null;
        try {
            if (System.getSecurityManager() != null) {
                final ExternalContext ectx = ctx;
                lpf = (ResourceLibraryContractsProviderFactory)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws PrivilegedActionException {
                        return SpiUtils.build(ectx, ResourceLibraryContractsProviderFactory.class, FACTORY_DEFAULT);
                    }
                });
            } else {
                lpf = (ResourceLibraryContractsProviderFactory)SpiUtils.build(ctx, ResourceLibraryContractsProviderFactory.class, FACTORY_DEFAULT);
            }
        }
        catch (PrivilegedActionException pae) {
            throw new FacesException(pae);
        }
        if (lpf != null) {
            ResourceLibraryContractsProviderFactory.setResourceLibraryContractsProviderFactory(ctx, lpf);
        }
        return lpf;
    }

    public static void setResourceLibraryContractsProviderFactory(ExternalContext ctx, ResourceLibraryContractsProviderFactory instance) {
        ctx.getApplicationMap().put(FACTORY_KEY, instance);
    }

    public abstract ResourceLibraryContractsProvider createResourceLibraryContractsProvider(ExternalContext var1);
}

