/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util;

import java.util.function.Supplier;

public class Lazy<T> {
    private static final Object NOT_INITIALIZED = new Object();
    private volatile T value = NOT_INITIALIZED;
    private volatile Supplier<T> init;

    public Lazy(Supplier<T> init) {
        this.init = init;
    }

    public synchronized void reset(Supplier<T> init) {
        this.init = init;
        this.value = NOT_INITIALIZED;
    }

    public synchronized void reset(T value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        T result = this.value;
        if (result == NOT_INITIALIZED) {
            Lazy lazy = this;
            synchronized (lazy) {
                result = this.value;
                if (result == NOT_INITIALIZED) {
                    result = this.value = this.init.get();
                }
            }
        }
        return result;
    }

    public boolean isInitialized() {
        return this.value != NOT_INITIALIZED;
    }
}

