/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component;

import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.UISelectItem;
import jakarta.faces.component._MessageUtils;
import jakarta.faces.component._SelectItemsIterator;
import jakarta.faces.component._SelectItemsUtil;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import java.io.Serializable;
import java.util.ArrayList;

public class UISelectOne
extends UIInput {
    public static final String COMPONENT_TYPE = "jakarta.faces.SelectOne";
    public static final String COMPONENT_FAMILY = "jakarta.faces.SelectOne";
    public static final String INVALID_MESSAGE_ID = "jakarta.faces.component.UISelectOne.INVALID";
    private boolean selectItemValueFound = false;

    public UISelectOne() {
        this.setRendererType("jakarta.faces.Menu");
    }

    @Override
    public String getFamily() {
        return "jakarta.faces.SelectOne";
    }

    @Override
    public void processValidators(FacesContext context) {
        final String group = this.getGroup();
        ValueExpression ve = this.getValueExpression("value");
        final String submittedValue = (String)this.getSubmittedValue();
        if (group != null && !group.isEmpty() && ve != null && !UISelectOne.isEmpty(submittedValue)) {
            UIComponent form = UISelectOne.getRadioNestingForm(context, this);
            form.visitTree(VisitContext.createVisitContext(context), new VisitCallback(){

                @Override
                public VisitResult visit(VisitContext visitContext, UIComponent target) {
                    if (target instanceof UISelectOne && ((UISelectOne)target).getGroup().equals(group)) {
                        UISelectOne radio = (UISelectOne)target;
                        for (UIComponent component : radio.getChildren()) {
                            UISelectItem item;
                            if (!(component instanceof UISelectItem) || !(item = (UISelectItem)component).getItemValue().equals(submittedValue)) continue;
                            UISelectOne.this.selectItemValueFound = true;
                            return VisitResult.COMPLETE;
                        }
                        return VisitResult.REJECT;
                    }
                    return VisitResult.ACCEPT;
                }
            });
        }
        super.processValidators(context);
    }

    private static UIComponent getRadioNestingForm(FacesContext context, UISelectOne radio) {
        UIComponent namingContainer = radio.getNamingContainer();
        while (namingContainer != null && !(namingContainer instanceof UIForm) && namingContainer.getParent() != null) {
            namingContainer = namingContainer.getParent().getNamingContainer();
        }
        if (namingContainer != null) {
            return namingContainer;
        }
        return context.getViewRoot();
    }

    @Override
    protected void validateValue(FacesContext context, Object value) {
        super.validateValue(context, value);
        if (!this.isValid() || value == null) {
            return;
        }
        Converter converter = this.getConverter();
        ArrayList items = new ArrayList();
        _SelectItemsIterator iter = new _SelectItemsIterator(this, context);
        while (iter.hasNext()) {
            items.add(iter.next());
        }
        if (_SelectItemsUtil.matchValue(context, this, value, items.iterator(), converter)) {
            if (!this.isRequired()) {
                return;
            }
            if (!_SelectItemsUtil.isNoSelectionOption(context, this, value, items.iterator(), converter)) {
                return;
            }
        }
        if (this.selectItemValueFound) {
            return;
        }
        _MessageUtils.addErrorMessage(context, this, INVALID_MESSAGE_ID, new Object[]{_MessageUtils.getLabel(context, this)});
        this.setValid(false);
    }

    public String getGroup() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.group));
    }

    public void setGroup(String group) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.group), group);
    }

    static enum PropertyKeys {
        group;

    }
}

