/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.util;

import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.ViewScoped;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;

public class CDIUtils {
    public static BeanManager getBeanManager(FacesContext facesContext) {
        return CDIUtils.getBeanManager(facesContext.getExternalContext());
    }

    public static BeanManager getBeanManager(ExternalContext externalContext) {
        return (BeanManager)externalContext.getApplicationMap().get("oam.cdi.BEAN_MANAGER_INSTANCE");
    }

    public static <T> T get(BeanManager bm, Class<T> clazz) {
        Set beans = bm.getBeans(clazz, new Annotation[0]);
        return CDIUtils.resolveInstance(bm, beans, clazz);
    }

    public static <T> T getOptional(BeanManager bm, Class<T> clazz) {
        Set beans = bm.getBeans(clazz, new Annotation[0]);
        if (beans == null || beans.isEmpty()) {
            return null;
        }
        return CDIUtils.resolveInstance(bm, beans, clazz);
    }

    private static <T> T resolveInstance(BeanManager bm, Set<Bean<?>> beans, Type type) {
        Bean bean = bm.resolve(beans);
        CreationalContext cc = bm.createCreationalContext((Contextual)bean);
        Object instance = bm.getReference(bean, type, cc);
        return (T)instance;
    }

    public static <T> Bean<T> get(BeanManager beanManager, Class<T> beanClass, Annotation ... qualifiers) {
        Set beans = beanManager.getBeans(beanClass, qualifiers);
        for (Bean bean : beans) {
            if (bean.getBeanClass() != beanClass) continue;
            return beanManager.resolve(Collections.singleton(bean));
        }
        return beanManager.resolve(beans);
    }

    public static <T> T get(BeanManager beanManager, Class<T> beanClass, boolean create, Annotation ... qualifiers) {
        try {
            Bean<T> bean = CDIUtils.get(beanManager, beanClass, qualifiers);
            return bean == null ? null : (T)CDIUtils.get(beanManager, bean, beanClass, create);
        }
        catch (ContextNotActiveException e) {
            return null;
        }
    }

    public static <T> T get(BeanManager beanManager, Type type, boolean create, Annotation ... qualifiers) {
        try {
            Set beans = beanManager.getBeans(type, qualifiers);
            Bean bean = beanManager.resolve(beans);
            return bean == null ? null : (T)CDIUtils.get(beanManager, bean, type, create);
        }
        catch (ContextNotActiveException e) {
            return null;
        }
    }

    public static <T> T get(BeanManager beanManager, Bean<T> bean, Type type, boolean create) {
        if (create) {
            CreationalContext creationalContext = beanManager.createCreationalContext(bean);
            return (T)beanManager.getReference(bean, type, creationalContext);
        }
        Context context = beanManager.getContext(bean.getScope());
        return (T)context.get(bean);
    }

    public static boolean isSessionScopeActive(BeanManager beanManager) {
        try {
            Context ctx = beanManager.getContext(SessionScoped.class);
            return ctx != null;
        }
        catch (ContextNotActiveException contextNotActiveException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isViewScopeActive(BeanManager beanManager) {
        try {
            Context ctx = beanManager.getContext(ViewScoped.class);
            return ctx != null;
        }
        catch (ContextNotActiveException contextNotActiveException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

